/*
 * Copyright (c) 2020  InterDigital Communications, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the \"License\");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an \"AS IS\" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE Platform Controller REST API
 * This API is the main Platform Controller API for scenario configuration & sandbox management <p>**Micro-service**<br>[meep-pfm-ctrl](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-platform-ctrl) <p>**Type & Usage**<br>Platform main interface used by controller software to configure scenarios and manage sandboxes in the AdvantEDGE platform <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_
 *
 * OpenAPI spec version: 1.0.0
 * Contact: AdvantEDGE@InterDigital.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.4.9
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD.
    define(['expect.js', '../../src/index'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    factory(require('expect.js'), require('../../src/index'));
  } else {
    // Browser globals (root is window)
    factory(root.expect, root.AdvantEdgePlatformControllerRestApi);
  }
}(this, function(expect, AdvantEdgePlatformControllerRestApi) {
  'use strict';

  var instance;

  beforeEach(function() {
    instance = new AdvantEdgePlatformControllerRestApi.ScenarioConfigurationApi();
  });

  describe('(package)', function() {
    describe('ScenarioConfigurationApi', function() {
      describe('createScenario', function() {
        it('should call createScenario successfully', function(done) {
          // TODO: uncomment, update parameter values for createScenario call
          /*
          var name = "name_example";
          var scenario = new AdvantEdgePlatformControllerRestApi.Scenario();
          scenario.version = "";
          scenario.id = "";
          scenario.name = "";
          scenario.description = "";
          scenario.config = new AdvantEdgePlatformControllerRestApi.ScenarioConfig();
          scenario.config.visualization = "";
          scenario.config.other = "";
          scenario.deployment = new AdvantEdgePlatformControllerRestApi.Deployment();
          scenario.deployment.netChar = new AdvantEdgePlatformControllerRestApi.NetworkCharacteristics();
          scenario.deployment.netChar.latency = 0;
          scenario.deployment.netChar.latencyVariation = 0;
          scenario.deployment.netChar.latencyDistribution = "Normal";
          scenario.deployment.netChar.throughput = 0;
          scenario.deployment.netChar.throughputDl = 0;
          scenario.deployment.netChar.throughputUl = 0;
          scenario.deployment.netChar.packetLoss = 0.0;
          scenario.deployment.interDomainLatency = 0;
          scenario.deployment.interDomainLatencyVariation = 0;
          scenario.deployment.interDomainThroughput = 0;
          scenario.deployment.interDomainPacketLoss = 0.0;
          scenario.deployment.meta = {key: ""};
          scenario.deployment.userMeta = {key: ""};
          scenario.deployment.domains = [new AdvantEdgePlatformControllerRestApi.Domain()];
          scenario.deployment.domains[0].id = "";
          scenario.deployment.domains[0].name = "";
          scenario.deployment.domains[0].type = "OPERATOR";
          scenario.deployment.domains[0].netChar = new AdvantEdgePlatformControllerRestApi.NetworkCharacteristics();
          scenario.deployment.domains[0].netChar.latency = 0;
          scenario.deployment.domains[0].netChar.latencyVariation = 0;
          scenario.deployment.domains[0].netChar.latencyDistribution = "Normal";
          scenario.deployment.domains[0].netChar.throughput = 0;
          scenario.deployment.domains[0].netChar.throughputDl = 0;
          scenario.deployment.domains[0].netChar.throughputUl = 0;
          scenario.deployment.domains[0].netChar.packetLoss = 0.0;
          scenario.deployment.domains[0].interZoneLatency = 0;
          scenario.deployment.domains[0].interZoneLatencyVariation = 0;
          scenario.deployment.domains[0].interZoneThroughput = 0;
          scenario.deployment.domains[0].interZonePacketLoss = 0.0;
          scenario.deployment.domains[0].meta = {key: ""};
          scenario.deployment.domains[0].userMeta = {key: ""};
          scenario.deployment.domains[0].cellularDomainConfig = new AdvantEdgePlatformControllerRestApi.CellularDomainConfig();
          scenario.deployment.domains[0].cellularDomainConfig.mnc = "";
          scenario.deployment.domains[0].cellularDomainConfig.mcc = "";
          scenario.deployment.domains[0].cellularDomainConfig.defaultCellId = "";
          scenario.deployment.domains[0].zones = [new AdvantEdgePlatformControllerRestApi.Zone()];
          scenario.deployment.domains[0].zones[0].id = "";
          scenario.deployment.domains[0].zones[0].name = "";
          scenario.deployment.domains[0].zones[0].type = "ZONE";
          scenario.deployment.domains[0].zones[0].netChar = new AdvantEdgePlatformControllerRestApi.NetworkCharacteristics();
          scenario.deployment.domains[0].zones[0].netChar.latency = 0;
          scenario.deployment.domains[0].zones[0].netChar.latencyVariation = 0;
          scenario.deployment.domains[0].zones[0].netChar.latencyDistribution = "Normal";
          scenario.deployment.domains[0].zones[0].netChar.throughput = 0;
          scenario.deployment.domains[0].zones[0].netChar.throughputDl = 0;
          scenario.deployment.domains[0].zones[0].netChar.throughputUl = 0;
          scenario.deployment.domains[0].zones[0].netChar.packetLoss = 0.0;
          scenario.deployment.domains[0].zones[0].interFogLatency = 0;
          scenario.deployment.domains[0].zones[0].interFogLatencyVariation = 0;
          scenario.deployment.domains[0].zones[0].interFogThroughput = 0;
          scenario.deployment.domains[0].zones[0].interFogPacketLoss = 0.0;
          scenario.deployment.domains[0].zones[0].interEdgeLatency = 0;
          scenario.deployment.domains[0].zones[0].interEdgeLatencyVariation = 0;
          scenario.deployment.domains[0].zones[0].interEdgeThroughput = 0;
          scenario.deployment.domains[0].zones[0].interEdgePacketLoss = 0.0;
          scenario.deployment.domains[0].zones[0].edgeFogLatency = 0;
          scenario.deployment.domains[0].zones[0].edgeFogLatencyVariation = 0;
          scenario.deployment.domains[0].zones[0].edgeFogThroughput = 0;
          scenario.deployment.domains[0].zones[0].edgeFogPacketLoss = 0.0;
          scenario.deployment.domains[0].zones[0].meta = {key: ""};
          scenario.deployment.domains[0].zones[0].userMeta = {key: ""};
          scenario.deployment.domains[0].zones[0].networkLocations = [new AdvantEdgePlatformControllerRestApi.NetworkLocation()];
          scenario.deployment.domains[0].zones[0].networkLocations[0].id = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].name = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].type = "POA";
          scenario.deployment.domains[0].zones[0].networkLocations[0].netChar = new AdvantEdgePlatformControllerRestApi.NetworkCharacteristics();
          scenario.deployment.domains[0].zones[0].networkLocations[0].netChar.latency = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].netChar.latencyVariation = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].netChar.latencyDistribution = "Normal";
          scenario.deployment.domains[0].zones[0].networkLocations[0].netChar.throughput = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].netChar.throughputDl = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].netChar.throughputUl = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].netChar.packetLoss = 0.0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].terminalLinkLatency = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].terminalLinkLatencyVariation = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].terminalLinkThroughput = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].terminalLinkPacketLoss = 0.0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].meta = {key: ""};
          scenario.deployment.domains[0].zones[0].networkLocations[0].userMeta = {key: ""};
          scenario.deployment.domains[0].zones[0].networkLocations[0].cellularPoaConfig = new AdvantEdgePlatformControllerRestApi.CellularPoaConfig();
          scenario.deployment.domains[0].zones[0].networkLocations[0].cellularPoaConfig.cellId = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].poa4GConfig = new AdvantEdgePlatformControllerRestApi.Poa4GConfig();
          scenario.deployment.domains[0].zones[0].networkLocations[0].poa4GConfig.cellId = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].poa5GConfig = new AdvantEdgePlatformControllerRestApi.Poa5GConfig();
          scenario.deployment.domains[0].zones[0].networkLocations[0].poa5GConfig.cellId = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].poaWifiConfig = new AdvantEdgePlatformControllerRestApi.PoaWifiConfig();
          scenario.deployment.domains[0].zones[0].networkLocations[0].poaWifiConfig.macId = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].geoData = new AdvantEdgePlatformControllerRestApi.GeoData();
          scenario.deployment.domains[0].zones[0].networkLocations[0].geoData.location = new AdvantEdgePlatformControllerRestApi.Point();
          scenario.deployment.domains[0].zones[0].networkLocations[0].geoData.location.type = "Point";
          scenario.deployment.domains[0].zones[0].networkLocations[0].geoData.location.coordinates = [];
          scenario.deployment.domains[0].zones[0].networkLocations[0].geoData.radius = ;
          scenario.deployment.domains[0].zones[0].networkLocations[0].geoData.path = new AdvantEdgePlatformControllerRestApi.LineString();
          scenario.deployment.domains[0].zones[0].networkLocations[0].geoData.path.type = "LineString";
          scenario.deployment.domains[0].zones[0].networkLocations[0].geoData.path.coordinates = [[]];
          scenario.deployment.domains[0].zones[0].networkLocations[0].geoData.eopMode = "LOOP";
          scenario.deployment.domains[0].zones[0].networkLocations[0].geoData.velocity = ;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations = [new AdvantEdgePlatformControllerRestApi.PhysicalLocation()];
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].id = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].name = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].type = "UE";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].isExternal = false;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].geoData = new AdvantEdgePlatformControllerRestApi.GeoData();
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].geoData.location = new AdvantEdgePlatformControllerRestApi.Point();
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].geoData.location.type = "Point";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].geoData.location.coordinates = [];
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].geoData.radius = ;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].geoData.path = new AdvantEdgePlatformControllerRestApi.LineString();
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].geoData.path.type = "LineString";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].geoData.path.coordinates = [[]];
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].geoData.eopMode = "LOOP";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].geoData.velocity = ;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].networkLocationsInRange = [""];
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].connected = false;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].wireless = false;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].wirelessType = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].meta = {key: ""};
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].userMeta = {key: ""};
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes = [new AdvantEdgePlatformControllerRestApi.Process()];
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].id = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].name = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].type = "UE-APP";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].isExternal = false;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].image = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].environment = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].commandArguments = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].commandExe = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].serviceConfig = new AdvantEdgePlatformControllerRestApi.ServiceConfig();
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].serviceConfig.name = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].serviceConfig.meSvcName = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].serviceConfig.ports = [new AdvantEdgePlatformControllerRestApi.ServicePort()];
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].serviceConfig.ports[0].protocol = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].serviceConfig.ports[0].port = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].serviceConfig.ports[0].externalPort = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].gpuConfig = new AdvantEdgePlatformControllerRestApi.GpuConfig();
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].gpuConfig.type = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].gpuConfig.count = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].memoryConfig = new AdvantEdgePlatformControllerRestApi.MemoryConfig();
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].memoryConfig.min = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].memoryConfig.max = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].cpuConfig = new AdvantEdgePlatformControllerRestApi.CpuConfig();
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].cpuConfig.min = 0.0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].cpuConfig.max = 0.0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].externalConfig = new AdvantEdgePlatformControllerRestApi.ExternalConfig();
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].externalConfig.ingressServiceMap = [new AdvantEdgePlatformControllerRestApi.IngressService()];
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].externalConfig.ingressServiceMap[0].name = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].externalConfig.ingressServiceMap[0].port = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].externalConfig.ingressServiceMap[0].externalPort = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].externalConfig.ingressServiceMap[0].protocol = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].externalConfig.egressServiceMap = [new AdvantEdgePlatformControllerRestApi.EgressService()];
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].externalConfig.egressServiceMap[0].name = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].externalConfig.egressServiceMap[0].meSvcName = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].externalConfig.egressServiceMap[0].ip = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].externalConfig.egressServiceMap[0].port = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].externalConfig.egressServiceMap[0].protocol = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].status = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].userChartLocation = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].userChartAlternateValues = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].userChartGroup = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].meta = {key: ""};
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].userMeta = {key: ""};
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].netChar = new AdvantEdgePlatformControllerRestApi.NetworkCharacteristics();
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].netChar.latency = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].netChar.latencyVariation = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].netChar.latencyDistribution = "Normal";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].netChar.throughput = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].netChar.throughputDl = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].netChar.throughputUl = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].netChar.packetLoss = 0.0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].appLatency = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].appLatencyVariation = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].appThroughput = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].appPacketLoss = 0.0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].placementId = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].netChar = new AdvantEdgePlatformControllerRestApi.NetworkCharacteristics();
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].netChar.latency = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].netChar.latencyVariation = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].netChar.latencyDistribution = "Normal";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].netChar.throughput = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].netChar.throughputDl = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].netChar.throughputUl = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].netChar.packetLoss = 0.0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].linkLatency = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].linkLatencyVariation = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].linkThroughput = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].linkPacketLoss = 0.0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].macId = "";

          instance.createScenario(name, scenario, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('deleteScenario', function() {
        it('should call deleteScenario successfully', function(done) {
          // TODO: uncomment, update parameter values for deleteScenario call
          /*
          var name = "name_example";

          instance.deleteScenario(name, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('deleteScenarioList', function() {
        it('should call deleteScenarioList successfully', function(done) {
          // TODO: uncomment deleteScenarioList call
          /*

          instance.deleteScenarioList(function(error, data, response) {
            if (error) {
              done(error);
              return;
            }

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('getScenario', function() {
        it('should call getScenario successfully', function(done) {
          // TODO: uncomment, update parameter values for getScenario call and complete the assertions
          /*
          var name = "name_example";

          instance.getScenario(name, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }
            // TODO: update response assertions
            expect(data).to.be.a(AdvantEdgePlatformControllerRestApi.Scenario);
            expect(data.version).to.be.a('string');
            expect(data.version).to.be("");
            expect(data.id).to.be.a('string');
            expect(data.id).to.be("");
            expect(data.name).to.be.a('string');
            expect(data.name).to.be("");
            expect(data.description).to.be.a('string');
            expect(data.description).to.be("");
            expect(data.config).to.be.a(AdvantEdgePlatformControllerRestApi.ScenarioConfig);
                  expect(data.config.visualization).to.be.a('string');
              expect(data.config.visualization).to.be("");
              expect(data.config.other).to.be.a('string');
              expect(data.config.other).to.be("");
            expect(data.deployment).to.be.a(AdvantEdgePlatformControllerRestApi.Deployment);
                  expect(data.deployment.netChar).to.be.a(AdvantEdgePlatformControllerRestApi.NetworkCharacteristics);
                    expect(data.deployment.netChar.latency).to.be.a('number');
                expect(data.deployment.netChar.latency).to.be(0);
                expect(data.deployment.netChar.latencyVariation).to.be.a('number');
                expect(data.deployment.netChar.latencyVariation).to.be(0);
                expect(data.deployment.netChar.latencyDistribution).to.be.a('string');
                expect(data.deployment.netChar.latencyDistribution).to.be("Normal");
                expect(data.deployment.netChar.throughput).to.be.a('number');
                expect(data.deployment.netChar.throughput).to.be(0);
                expect(data.deployment.netChar.throughputDl).to.be.a('number');
                expect(data.deployment.netChar.throughputDl).to.be(0);
                expect(data.deployment.netChar.throughputUl).to.be.a('number');
                expect(data.deployment.netChar.throughputUl).to.be(0);
                expect(data.deployment.netChar.packetLoss).to.be.a('number');
                expect(data.deployment.netChar.packetLoss).to.be(0.0);
              expect(data.deployment.interDomainLatency).to.be.a('number');
              expect(data.deployment.interDomainLatency).to.be(0);
              expect(data.deployment.interDomainLatencyVariation).to.be.a('number');
              expect(data.deployment.interDomainLatencyVariation).to.be(0);
              expect(data.deployment.interDomainThroughput).to.be.a('number');
              expect(data.deployment.interDomainThroughput).to.be(0);
              expect(data.deployment.interDomainPacketLoss).to.be.a('number');
              expect(data.deployment.interDomainPacketLoss).to.be(0.0);
              {
                let dataCtr = data.deployment.meta;
                expect(dataCtr).to.be.an(Object);
                expect(dataCtr).to.not.be.empty();
                for (let p in dataCtr) {
                  let data = dataCtr[p];
                  expect(data).to.be.a('string');
                  expect(data).to.be("");
                }
              }
              {
                let dataCtr = data.deployment.userMeta;
                expect(dataCtr).to.be.an(Object);
                expect(dataCtr).to.not.be.empty();
                for (let p in dataCtr) {
                  let data = dataCtr[p];
                  expect(data).to.be.a('string');
                  expect(data).to.be("");
                }
              }
              {
                let dataCtr = data.deployment.domains;
                expect(dataCtr).to.be.an(Array);
                expect(dataCtr).to.not.be.empty();
                for (let p in dataCtr) {
                  let data = dataCtr[p];
                  expect(data).to.be.a(AdvantEdgePlatformControllerRestApi.Domain);
                  expect(data.id).to.be.a('string');
                  expect(data.id).to.be("");
                  expect(data.name).to.be.a('string');
                  expect(data.name).to.be("");
                  expect(data.type).to.be.a('string');
                  expect(data.type).to.be("OPERATOR");
                  expect(data.netChar).to.be.a(AdvantEdgePlatformControllerRestApi.NetworkCharacteristics);
                        expect(data.netChar.latency).to.be.a('number');
                    expect(data.netChar.latency).to.be(0);
                    expect(data.netChar.latencyVariation).to.be.a('number');
                    expect(data.netChar.latencyVariation).to.be(0);
                    expect(data.netChar.latencyDistribution).to.be.a('string');
                    expect(data.netChar.latencyDistribution).to.be("Normal");
                    expect(data.netChar.throughput).to.be.a('number');
                    expect(data.netChar.throughput).to.be(0);
                    expect(data.netChar.throughputDl).to.be.a('number');
                    expect(data.netChar.throughputDl).to.be(0);
                    expect(data.netChar.throughputUl).to.be.a('number');
                    expect(data.netChar.throughputUl).to.be(0);
                    expect(data.netChar.packetLoss).to.be.a('number');
                    expect(data.netChar.packetLoss).to.be(0.0);
                  expect(data.interZoneLatency).to.be.a('number');
                  expect(data.interZoneLatency).to.be(0);
                  expect(data.interZoneLatencyVariation).to.be.a('number');
                  expect(data.interZoneLatencyVariation).to.be(0);
                  expect(data.interZoneThroughput).to.be.a('number');
                  expect(data.interZoneThroughput).to.be(0);
                  expect(data.interZonePacketLoss).to.be.a('number');
                  expect(data.interZonePacketLoss).to.be(0.0);
                  {
                    let dataCtr = data.meta;
                    expect(dataCtr).to.be.an(Object);
                    expect(dataCtr).to.not.be.empty();
                    for (let p in dataCtr) {
                      let data = dataCtr[p];
                      expect(data).to.be.a('string');
                      expect(data).to.be("");
                    }
                  }
                  {
                    let dataCtr = data.userMeta;
                    expect(dataCtr).to.be.an(Object);
                    expect(dataCtr).to.not.be.empty();
                    for (let p in dataCtr) {
                      let data = dataCtr[p];
                      expect(data).to.be.a('string');
                      expect(data).to.be("");
                    }
                  }
                  expect(data.cellularDomainConfig).to.be.a(AdvantEdgePlatformControllerRestApi.CellularDomainConfig);
                        expect(data.cellularDomainConfig.mnc).to.be.a('string');
                    expect(data.cellularDomainConfig.mnc).to.be("");
                    expect(data.cellularDomainConfig.mcc).to.be.a('string');
                    expect(data.cellularDomainConfig.mcc).to.be("");
                    expect(data.cellularDomainConfig.defaultCellId).to.be.a('string');
                    expect(data.cellularDomainConfig.defaultCellId).to.be("");
                  {
                    let dataCtr = data.zones;
                    expect(dataCtr).to.be.an(Array);
                    expect(dataCtr).to.not.be.empty();
                    for (let p in dataCtr) {
                      let data = dataCtr[p];
                      expect(data).to.be.a(AdvantEdgePlatformControllerRestApi.Zone);
                      expect(data.id).to.be.a('string');
                      expect(data.id).to.be("");
                      expect(data.name).to.be.a('string');
                      expect(data.name).to.be("");
                      expect(data.type).to.be.a('string');
                      expect(data.type).to.be("ZONE");
                      expect(data.netChar).to.be.a(AdvantEdgePlatformControllerRestApi.NetworkCharacteristics);
                            expect(data.netChar.latency).to.be.a('number');
                        expect(data.netChar.latency).to.be(0);
                        expect(data.netChar.latencyVariation).to.be.a('number');
                        expect(data.netChar.latencyVariation).to.be(0);
                        expect(data.netChar.latencyDistribution).to.be.a('string');
                        expect(data.netChar.latencyDistribution).to.be("Normal");
                        expect(data.netChar.throughput).to.be.a('number');
                        expect(data.netChar.throughput).to.be(0);
                        expect(data.netChar.throughputDl).to.be.a('number');
                        expect(data.netChar.throughputDl).to.be(0);
                        expect(data.netChar.throughputUl).to.be.a('number');
                        expect(data.netChar.throughputUl).to.be(0);
                        expect(data.netChar.packetLoss).to.be.a('number');
                        expect(data.netChar.packetLoss).to.be(0.0);
                      expect(data.interFogLatency).to.be.a('number');
                      expect(data.interFogLatency).to.be(0);
                      expect(data.interFogLatencyVariation).to.be.a('number');
                      expect(data.interFogLatencyVariation).to.be(0);
                      expect(data.interFogThroughput).to.be.a('number');
                      expect(data.interFogThroughput).to.be(0);
                      expect(data.interFogPacketLoss).to.be.a('number');
                      expect(data.interFogPacketLoss).to.be(0.0);
                      expect(data.interEdgeLatency).to.be.a('number');
                      expect(data.interEdgeLatency).to.be(0);
                      expect(data.interEdgeLatencyVariation).to.be.a('number');
                      expect(data.interEdgeLatencyVariation).to.be(0);
                      expect(data.interEdgeThroughput).to.be.a('number');
                      expect(data.interEdgeThroughput).to.be(0);
                      expect(data.interEdgePacketLoss).to.be.a('number');
                      expect(data.interEdgePacketLoss).to.be(0.0);
                      expect(data.edgeFogLatency).to.be.a('number');
                      expect(data.edgeFogLatency).to.be(0);
                      expect(data.edgeFogLatencyVariation).to.be.a('number');
                      expect(data.edgeFogLatencyVariation).to.be(0);
                      expect(data.edgeFogThroughput).to.be.a('number');
                      expect(data.edgeFogThroughput).to.be(0);
                      expect(data.edgeFogPacketLoss).to.be.a('number');
                      expect(data.edgeFogPacketLoss).to.be(0.0);
                      {
                        let dataCtr = data.meta;
                        expect(dataCtr).to.be.an(Object);
                        expect(dataCtr).to.not.be.empty();
                        for (let p in dataCtr) {
                          let data = dataCtr[p];
                          expect(data).to.be.a('string');
                          expect(data).to.be("");
                        }
                      }
                      {
                        let dataCtr = data.userMeta;
                        expect(dataCtr).to.be.an(Object);
                        expect(dataCtr).to.not.be.empty();
                        for (let p in dataCtr) {
                          let data = dataCtr[p];
                          expect(data).to.be.a('string');
                          expect(data).to.be("");
                        }
                      }
                      {
                        let dataCtr = data.networkLocations;
                        expect(dataCtr).to.be.an(Array);
                        expect(dataCtr).to.not.be.empty();
                        for (let p in dataCtr) {
                          let data = dataCtr[p];
                          expect(data).to.be.a(AdvantEdgePlatformControllerRestApi.NetworkLocation);
                          expect(data.id).to.be.a('string');
                          expect(data.id).to.be("");
                          expect(data.name).to.be.a('string');
                          expect(data.name).to.be("");
                          expect(data.type).to.be.a('string');
                          expect(data.type).to.be("POA");
                          expect(data.netChar).to.be.a(AdvantEdgePlatformControllerRestApi.NetworkCharacteristics);
                                expect(data.netChar.latency).to.be.a('number');
                            expect(data.netChar.latency).to.be(0);
                            expect(data.netChar.latencyVariation).to.be.a('number');
                            expect(data.netChar.latencyVariation).to.be(0);
                            expect(data.netChar.latencyDistribution).to.be.a('string');
                            expect(data.netChar.latencyDistribution).to.be("Normal");
                            expect(data.netChar.throughput).to.be.a('number');
                            expect(data.netChar.throughput).to.be(0);
                            expect(data.netChar.throughputDl).to.be.a('number');
                            expect(data.netChar.throughputDl).to.be(0);
                            expect(data.netChar.throughputUl).to.be.a('number');
                            expect(data.netChar.throughputUl).to.be(0);
                            expect(data.netChar.packetLoss).to.be.a('number');
                            expect(data.netChar.packetLoss).to.be(0.0);
                          expect(data.terminalLinkLatency).to.be.a('number');
                          expect(data.terminalLinkLatency).to.be(0);
                          expect(data.terminalLinkLatencyVariation).to.be.a('number');
                          expect(data.terminalLinkLatencyVariation).to.be(0);
                          expect(data.terminalLinkThroughput).to.be.a('number');
                          expect(data.terminalLinkThroughput).to.be(0);
                          expect(data.terminalLinkPacketLoss).to.be.a('number');
                          expect(data.terminalLinkPacketLoss).to.be(0.0);
                          {
                            let dataCtr = data.meta;
                            expect(dataCtr).to.be.an(Object);
                            expect(dataCtr).to.not.be.empty();
                            for (let p in dataCtr) {
                              let data = dataCtr[p];
                              expect(data).to.be.a('string');
                              expect(data).to.be("");
                            }
                          }
                          {
                            let dataCtr = data.userMeta;
                            expect(dataCtr).to.be.an(Object);
                            expect(dataCtr).to.not.be.empty();
                            for (let p in dataCtr) {
                              let data = dataCtr[p];
                              expect(data).to.be.a('string');
                              expect(data).to.be("");
                            }
                          }
                          expect(data.cellularPoaConfig).to.be.a(AdvantEdgePlatformControllerRestApi.CellularPoaConfig);
                                expect(data.cellularPoaConfig.cellId).to.be.a('string');
                            expect(data.cellularPoaConfig.cellId).to.be("");
                          expect(data.poa4GConfig).to.be.a(AdvantEdgePlatformControllerRestApi.Poa4GConfig);
                                expect(data.poa4GConfig.cellId).to.be.a('string');
                            expect(data.poa4GConfig.cellId).to.be("");
                          expect(data.poa5GConfig).to.be.a(AdvantEdgePlatformControllerRestApi.Poa5GConfig);
                                expect(data.poa5GConfig.cellId).to.be.a('string');
                            expect(data.poa5GConfig.cellId).to.be("");
                          expect(data.poaWifiConfig).to.be.a(AdvantEdgePlatformControllerRestApi.PoaWifiConfig);
                                expect(data.poaWifiConfig.macId).to.be.a('string');
                            expect(data.poaWifiConfig.macId).to.be("");
                          expect(data.geoData).to.be.a(AdvantEdgePlatformControllerRestApi.GeoData);
                                expect(data.geoData.location).to.be.a(AdvantEdgePlatformControllerRestApi.Point);
                                  expect(data.geoData.location.type).to.be.a('string');
                              expect(data.geoData.location.type).to.be("Point");
                              {
                                let dataCtr = data.geoData.location.coordinates;
                                expect(dataCtr).to.be.an(Array);
                                expect(dataCtr).to.not.be.empty();
                                for (let p in dataCtr) {
                                  let data = dataCtr[p];
                                  expect(data).to.be.a('number');
                                  expect(data).to.be();
                                }
                              }
                            expect(data.geoData.radius).to.be.a('number');
                            expect(data.geoData.radius).to.be();
                            expect(data.geoData.path).to.be.a(AdvantEdgePlatformControllerRestApi.LineString);
                                  expect(data.geoData.path.type).to.be.a('string');
                              expect(data.geoData.path.type).to.be("LineString");
                              {
                                let dataCtr = data.geoData.path.coordinates;
                                expect(dataCtr).to.be.an(Array);
                                expect(dataCtr).to.not.be.empty();
                                for (let p in dataCtr) {
                                  let data = dataCtr[p];
                                  expect(data).to.be.a(Array);
                                  expect(data).to.be([]);
                                }
                              }
                            expect(data.geoData.eopMode).to.be.a('string');
                            expect(data.geoData.eopMode).to.be("LOOP");
                            expect(data.geoData.velocity).to.be.a('number');
                            expect(data.geoData.velocity).to.be();
                          {
                            let dataCtr = data.physicalLocations;
                            expect(dataCtr).to.be.an(Array);
                            expect(dataCtr).to.not.be.empty();
                            for (let p in dataCtr) {
                              let data = dataCtr[p];
                              expect(data).to.be.a(AdvantEdgePlatformControllerRestApi.PhysicalLocation);
                              expect(data.id).to.be.a('string');
                              expect(data.id).to.be("");
                              expect(data.name).to.be.a('string');
                              expect(data.name).to.be("");
                              expect(data.type).to.be.a('string');
                              expect(data.type).to.be("UE");
                              expect(data.isExternal).to.be.a('boolean');
                              expect(data.isExternal).to.be(false);
                              expect(data.geoData).to.be.a(AdvantEdgePlatformControllerRestApi.GeoData);
                                    expect(data.geoData.location).to.be.a(AdvantEdgePlatformControllerRestApi.Point);
                                      expect(data.geoData.location.type).to.be.a('string');
                                  expect(data.geoData.location.type).to.be("Point");
                                  {
                                    let dataCtr = data.geoData.location.coordinates;
                                    expect(dataCtr).to.be.an(Array);
                                    expect(dataCtr).to.not.be.empty();
                                    for (let p in dataCtr) {
                                      let data = dataCtr[p];
                                      expect(data).to.be.a('number');
                                      expect(data).to.be();
                                    }
                                  }
                                expect(data.geoData.radius).to.be.a('number');
                                expect(data.geoData.radius).to.be();
                                expect(data.geoData.path).to.be.a(AdvantEdgePlatformControllerRestApi.LineString);
                                      expect(data.geoData.path.type).to.be.a('string');
                                  expect(data.geoData.path.type).to.be("LineString");
                                  {
                                    let dataCtr = data.geoData.path.coordinates;
                                    expect(dataCtr).to.be.an(Array);
                                    expect(dataCtr).to.not.be.empty();
                                    for (let p in dataCtr) {
                                      let data = dataCtr[p];
                                      expect(data).to.be.a(Array);
                                      expect(data).to.be([]);
                                    }
                                  }
                                expect(data.geoData.eopMode).to.be.a('string');
                                expect(data.geoData.eopMode).to.be("LOOP");
                                expect(data.geoData.velocity).to.be.a('number');
                                expect(data.geoData.velocity).to.be();
                              {
                                let dataCtr = data.networkLocationsInRange;
                                expect(dataCtr).to.be.an(Array);
                                expect(dataCtr).to.not.be.empty();
                                for (let p in dataCtr) {
                                  let data = dataCtr[p];
                                  expect(data).to.be.a('string');
                                  expect(data).to.be("");
                                }
                              }
                              expect(data.connected).to.be.a('boolean');
                              expect(data.connected).to.be(false);
                              expect(data.wireless).to.be.a('boolean');
                              expect(data.wireless).to.be(false);
                              expect(data.wirelessType).to.be.a('string');
                              expect(data.wirelessType).to.be("");
                              {
                                let dataCtr = data.meta;
                                expect(dataCtr).to.be.an(Object);
                                expect(dataCtr).to.not.be.empty();
                                for (let p in dataCtr) {
                                  let data = dataCtr[p];
                                  expect(data).to.be.a('string');
                                  expect(data).to.be("");
                                }
                              }
                              {
                                let dataCtr = data.userMeta;
                                expect(dataCtr).to.be.an(Object);
                                expect(dataCtr).to.not.be.empty();
                                for (let p in dataCtr) {
                                  let data = dataCtr[p];
                                  expect(data).to.be.a('string');
                                  expect(data).to.be("");
                                }
                              }
                              {
                                let dataCtr = data.processes;
                                expect(dataCtr).to.be.an(Array);
                                expect(dataCtr).to.not.be.empty();
                                for (let p in dataCtr) {
                                  let data = dataCtr[p];
                                  expect(data).to.be.a(AdvantEdgePlatformControllerRestApi.Process);
                                  expect(data.id).to.be.a('string');
                                  expect(data.id).to.be("");
                                  expect(data.name).to.be.a('string');
                                  expect(data.name).to.be("");
                                  expect(data.type).to.be.a('string');
                                  expect(data.type).to.be("UE-APP");
                                  expect(data.isExternal).to.be.a('boolean');
                                  expect(data.isExternal).to.be(false);
                                  expect(data.image).to.be.a('string');
                                  expect(data.image).to.be("");
                                  expect(data.environment).to.be.a('string');
                                  expect(data.environment).to.be("");
                                  expect(data.commandArguments).to.be.a('string');
                                  expect(data.commandArguments).to.be("");
                                  expect(data.commandExe).to.be.a('string');
                                  expect(data.commandExe).to.be("");
                                  expect(data.serviceConfig).to.be.a(AdvantEdgePlatformControllerRestApi.ServiceConfig);
                                        expect(data.serviceConfig.name).to.be.a('string');
                                    expect(data.serviceConfig.name).to.be("");
                                    expect(data.serviceConfig.meSvcName).to.be.a('string');
                                    expect(data.serviceConfig.meSvcName).to.be("");
                                    {
                                      let dataCtr = data.serviceConfig.ports;
                                      expect(dataCtr).to.be.an(Array);
                                      expect(dataCtr).to.not.be.empty();
                                      for (let p in dataCtr) {
                                        let data = dataCtr[p];
                                        expect(data).to.be.a(AdvantEdgePlatformControllerRestApi.ServicePort);
                                        expect(data.protocol).to.be.a('string');
                                        expect(data.protocol).to.be("");
                                        expect(data.port).to.be.a('number');
                                        expect(data.port).to.be(0);
                                        expect(data.externalPort).to.be.a('number');
                                        expect(data.externalPort).to.be(0);
                                      }
                                    }
                                  expect(data.gpuConfig).to.be.a(AdvantEdgePlatformControllerRestApi.GpuConfig);
                                        expect(data.gpuConfig.type).to.be.a('string');
                                    expect(data.gpuConfig.type).to.be("");
                                    expect(data.gpuConfig.count).to.be.a('number');
                                    expect(data.gpuConfig.count).to.be(0);
                                  expect(data.memoryConfig).to.be.a(AdvantEdgePlatformControllerRestApi.MemoryConfig);
                                        expect(data.memoryConfig.min).to.be.a('number');
                                    expect(data.memoryConfig.min).to.be(0);
                                    expect(data.memoryConfig.max).to.be.a('number');
                                    expect(data.memoryConfig.max).to.be(0);
                                  expect(data.cpuConfig).to.be.a(AdvantEdgePlatformControllerRestApi.CpuConfig);
                                        expect(data.cpuConfig.min).to.be.a('number');
                                    expect(data.cpuConfig.min).to.be(0.0);
                                    expect(data.cpuConfig.max).to.be.a('number');
                                    expect(data.cpuConfig.max).to.be(0.0);
                                  expect(data.externalConfig).to.be.a(AdvantEdgePlatformControllerRestApi.ExternalConfig);
                                        {
                                      let dataCtr = data.externalConfig.ingressServiceMap;
                                      expect(dataCtr).to.be.an(Array);
                                      expect(dataCtr).to.not.be.empty();
                                      for (let p in dataCtr) {
                                        let data = dataCtr[p];
                                        expect(data).to.be.a(AdvantEdgePlatformControllerRestApi.IngressService);
                                        expect(data.name).to.be.a('string');
                                        expect(data.name).to.be("");
                                        expect(data.port).to.be.a('number');
                                        expect(data.port).to.be(0);
                                        expect(data.externalPort).to.be.a('number');
                                        expect(data.externalPort).to.be(0);
                                        expect(data.protocol).to.be.a('string');
                                        expect(data.protocol).to.be("");
                                      }
                                    }
                                    {
                                      let dataCtr = data.externalConfig.egressServiceMap;
                                      expect(dataCtr).to.be.an(Array);
                                      expect(dataCtr).to.not.be.empty();
                                      for (let p in dataCtr) {
                                        let data = dataCtr[p];
                                        expect(data).to.be.a(AdvantEdgePlatformControllerRestApi.EgressService);
                                        expect(data.name).to.be.a('string');
                                        expect(data.name).to.be("");
                                        expect(data.meSvcName).to.be.a('string');
                                        expect(data.meSvcName).to.be("");
                                        expect(data.ip).to.be.a('string');
                                        expect(data.ip).to.be("");
                                        expect(data.port).to.be.a('number');
                                        expect(data.port).to.be(0);
                                        expect(data.protocol).to.be.a('string');
                                        expect(data.protocol).to.be("");
                                      }
                                    }
                                  expect(data.status).to.be.a('string');
                                  expect(data.status).to.be("");
                                  expect(data.userChartLocation).to.be.a('string');
                                  expect(data.userChartLocation).to.be("");
                                  expect(data.userChartAlternateValues).to.be.a('string');
                                  expect(data.userChartAlternateValues).to.be("");
                                  expect(data.userChartGroup).to.be.a('string');
                                  expect(data.userChartGroup).to.be("");
                                  {
                                    let dataCtr = data.meta;
                                    expect(dataCtr).to.be.an(Object);
                                    expect(dataCtr).to.not.be.empty();
                                    for (let p in dataCtr) {
                                      let data = dataCtr[p];
                                      expect(data).to.be.a('string');
                                      expect(data).to.be("");
                                    }
                                  }
                                  {
                                    let dataCtr = data.userMeta;
                                    expect(dataCtr).to.be.an(Object);
                                    expect(dataCtr).to.not.be.empty();
                                    for (let p in dataCtr) {
                                      let data = dataCtr[p];
                                      expect(data).to.be.a('string');
                                      expect(data).to.be("");
                                    }
                                  }
                                  expect(data.netChar).to.be.a(AdvantEdgePlatformControllerRestApi.NetworkCharacteristics);
                                        expect(data.netChar.latency).to.be.a('number');
                                    expect(data.netChar.latency).to.be(0);
                                    expect(data.netChar.latencyVariation).to.be.a('number');
                                    expect(data.netChar.latencyVariation).to.be(0);
                                    expect(data.netChar.latencyDistribution).to.be.a('string');
                                    expect(data.netChar.latencyDistribution).to.be("Normal");
                                    expect(data.netChar.throughput).to.be.a('number');
                                    expect(data.netChar.throughput).to.be(0);
                                    expect(data.netChar.throughputDl).to.be.a('number');
                                    expect(data.netChar.throughputDl).to.be(0);
                                    expect(data.netChar.throughputUl).to.be.a('number');
                                    expect(data.netChar.throughputUl).to.be(0);
                                    expect(data.netChar.packetLoss).to.be.a('number');
                                    expect(data.netChar.packetLoss).to.be(0.0);
                                  expect(data.appLatency).to.be.a('number');
                                  expect(data.appLatency).to.be(0);
                                  expect(data.appLatencyVariation).to.be.a('number');
                                  expect(data.appLatencyVariation).to.be(0);
                                  expect(data.appThroughput).to.be.a('number');
                                  expect(data.appThroughput).to.be(0);
                                  expect(data.appPacketLoss).to.be.a('number');
                                  expect(data.appPacketLoss).to.be(0.0);
                                  expect(data.placementId).to.be.a('string');
                                  expect(data.placementId).to.be("");
                                }
                              }
                              expect(data.netChar).to.be.a(AdvantEdgePlatformControllerRestApi.NetworkCharacteristics);
                                    expect(data.netChar.latency).to.be.a('number');
                                expect(data.netChar.latency).to.be(0);
                                expect(data.netChar.latencyVariation).to.be.a('number');
                                expect(data.netChar.latencyVariation).to.be(0);
                                expect(data.netChar.latencyDistribution).to.be.a('string');
                                expect(data.netChar.latencyDistribution).to.be("Normal");
                                expect(data.netChar.throughput).to.be.a('number');
                                expect(data.netChar.throughput).to.be(0);
                                expect(data.netChar.throughputDl).to.be.a('number');
                                expect(data.netChar.throughputDl).to.be(0);
                                expect(data.netChar.throughputUl).to.be.a('number');
                                expect(data.netChar.throughputUl).to.be(0);
                                expect(data.netChar.packetLoss).to.be.a('number');
                                expect(data.netChar.packetLoss).to.be(0.0);
                              expect(data.linkLatency).to.be.a('number');
                              expect(data.linkLatency).to.be(0);
                              expect(data.linkLatencyVariation).to.be.a('number');
                              expect(data.linkLatencyVariation).to.be(0);
                              expect(data.linkThroughput).to.be.a('number');
                              expect(data.linkThroughput).to.be(0);
                              expect(data.linkPacketLoss).to.be.a('number');
                              expect(data.linkPacketLoss).to.be(0.0);
                              expect(data.macId).to.be.a('string');
                              expect(data.macId).to.be("");
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('getScenarioList', function() {
        it('should call getScenarioList successfully', function(done) {
          // TODO: uncomment getScenarioList call and complete the assertions
          /*

          instance.getScenarioList(function(error, data, response) {
            if (error) {
              done(error);
              return;
            }
            // TODO: update response assertions
            expect(data).to.be.a(AdvantEdgePlatformControllerRestApi.ScenarioList);
            {
              let dataCtr = data.scenarios;
              expect(dataCtr).to.be.an(Array);
              expect(dataCtr).to.not.be.empty();
              for (let p in dataCtr) {
                let data = dataCtr[p];
                expect(data).to.be.a(AdvantEdgePlatformControllerRestApi.Scenario);
                expect(data.version).to.be.a('string');
                expect(data.version).to.be("");
                expect(data.id).to.be.a('string');
                expect(data.id).to.be("");
                expect(data.name).to.be.a('string');
                expect(data.name).to.be("");
                expect(data.description).to.be.a('string');
                expect(data.description).to.be("");
                expect(data.config).to.be.a(AdvantEdgePlatformControllerRestApi.ScenarioConfig);
                      expect(data.config.visualization).to.be.a('string');
                  expect(data.config.visualization).to.be("");
                  expect(data.config.other).to.be.a('string');
                  expect(data.config.other).to.be("");
                expect(data.deployment).to.be.a(AdvantEdgePlatformControllerRestApi.Deployment);
                      expect(data.deployment.netChar).to.be.a(AdvantEdgePlatformControllerRestApi.NetworkCharacteristics);
                        expect(data.deployment.netChar.latency).to.be.a('number');
                    expect(data.deployment.netChar.latency).to.be(0);
                    expect(data.deployment.netChar.latencyVariation).to.be.a('number');
                    expect(data.deployment.netChar.latencyVariation).to.be(0);
                    expect(data.deployment.netChar.latencyDistribution).to.be.a('string');
                    expect(data.deployment.netChar.latencyDistribution).to.be("Normal");
                    expect(data.deployment.netChar.throughput).to.be.a('number');
                    expect(data.deployment.netChar.throughput).to.be(0);
                    expect(data.deployment.netChar.throughputDl).to.be.a('number');
                    expect(data.deployment.netChar.throughputDl).to.be(0);
                    expect(data.deployment.netChar.throughputUl).to.be.a('number');
                    expect(data.deployment.netChar.throughputUl).to.be(0);
                    expect(data.deployment.netChar.packetLoss).to.be.a('number');
                    expect(data.deployment.netChar.packetLoss).to.be(0.0);
                  expect(data.deployment.interDomainLatency).to.be.a('number');
                  expect(data.deployment.interDomainLatency).to.be(0);
                  expect(data.deployment.interDomainLatencyVariation).to.be.a('number');
                  expect(data.deployment.interDomainLatencyVariation).to.be(0);
                  expect(data.deployment.interDomainThroughput).to.be.a('number');
                  expect(data.deployment.interDomainThroughput).to.be(0);
                  expect(data.deployment.interDomainPacketLoss).to.be.a('number');
                  expect(data.deployment.interDomainPacketLoss).to.be(0.0);
                  {
                    let dataCtr = data.deployment.meta;
                    expect(dataCtr).to.be.an(Object);
                    expect(dataCtr).to.not.be.empty();
                    for (let p in dataCtr) {
                      let data = dataCtr[p];
                      expect(data).to.be.a('string');
                      expect(data).to.be("");
                    }
                  }
                  {
                    let dataCtr = data.deployment.userMeta;
                    expect(dataCtr).to.be.an(Object);
                    expect(dataCtr).to.not.be.empty();
                    for (let p in dataCtr) {
                      let data = dataCtr[p];
                      expect(data).to.be.a('string');
                      expect(data).to.be("");
                    }
                  }
                  {
                    let dataCtr = data.deployment.domains;
                    expect(dataCtr).to.be.an(Array);
                    expect(dataCtr).to.not.be.empty();
                    for (let p in dataCtr) {
                      let data = dataCtr[p];
                      expect(data).to.be.a(AdvantEdgePlatformControllerRestApi.Domain);
                      expect(data.id).to.be.a('string');
                      expect(data.id).to.be("");
                      expect(data.name).to.be.a('string');
                      expect(data.name).to.be("");
                      expect(data.type).to.be.a('string');
                      expect(data.type).to.be("OPERATOR");
                      expect(data.netChar).to.be.a(AdvantEdgePlatformControllerRestApi.NetworkCharacteristics);
                            expect(data.netChar.latency).to.be.a('number');
                        expect(data.netChar.latency).to.be(0);
                        expect(data.netChar.latencyVariation).to.be.a('number');
                        expect(data.netChar.latencyVariation).to.be(0);
                        expect(data.netChar.latencyDistribution).to.be.a('string');
                        expect(data.netChar.latencyDistribution).to.be("Normal");
                        expect(data.netChar.throughput).to.be.a('number');
                        expect(data.netChar.throughput).to.be(0);
                        expect(data.netChar.throughputDl).to.be.a('number');
                        expect(data.netChar.throughputDl).to.be(0);
                        expect(data.netChar.throughputUl).to.be.a('number');
                        expect(data.netChar.throughputUl).to.be(0);
                        expect(data.netChar.packetLoss).to.be.a('number');
                        expect(data.netChar.packetLoss).to.be(0.0);
                      expect(data.interZoneLatency).to.be.a('number');
                      expect(data.interZoneLatency).to.be(0);
                      expect(data.interZoneLatencyVariation).to.be.a('number');
                      expect(data.interZoneLatencyVariation).to.be(0);
                      expect(data.interZoneThroughput).to.be.a('number');
                      expect(data.interZoneThroughput).to.be(0);
                      expect(data.interZonePacketLoss).to.be.a('number');
                      expect(data.interZonePacketLoss).to.be(0.0);
                      {
                        let dataCtr = data.meta;
                        expect(dataCtr).to.be.an(Object);
                        expect(dataCtr).to.not.be.empty();
                        for (let p in dataCtr) {
                          let data = dataCtr[p];
                          expect(data).to.be.a('string');
                          expect(data).to.be("");
                        }
                      }
                      {
                        let dataCtr = data.userMeta;
                        expect(dataCtr).to.be.an(Object);
                        expect(dataCtr).to.not.be.empty();
                        for (let p in dataCtr) {
                          let data = dataCtr[p];
                          expect(data).to.be.a('string');
                          expect(data).to.be("");
                        }
                      }
                      expect(data.cellularDomainConfig).to.be.a(AdvantEdgePlatformControllerRestApi.CellularDomainConfig);
                            expect(data.cellularDomainConfig.mnc).to.be.a('string');
                        expect(data.cellularDomainConfig.mnc).to.be("");
                        expect(data.cellularDomainConfig.mcc).to.be.a('string');
                        expect(data.cellularDomainConfig.mcc).to.be("");
                        expect(data.cellularDomainConfig.defaultCellId).to.be.a('string');
                        expect(data.cellularDomainConfig.defaultCellId).to.be("");
                      {
                        let dataCtr = data.zones;
                        expect(dataCtr).to.be.an(Array);
                        expect(dataCtr).to.not.be.empty();
                        for (let p in dataCtr) {
                          let data = dataCtr[p];
                          expect(data).to.be.a(AdvantEdgePlatformControllerRestApi.Zone);
                          expect(data.id).to.be.a('string');
                          expect(data.id).to.be("");
                          expect(data.name).to.be.a('string');
                          expect(data.name).to.be("");
                          expect(data.type).to.be.a('string');
                          expect(data.type).to.be("ZONE");
                          expect(data.netChar).to.be.a(AdvantEdgePlatformControllerRestApi.NetworkCharacteristics);
                                expect(data.netChar.latency).to.be.a('number');
                            expect(data.netChar.latency).to.be(0);
                            expect(data.netChar.latencyVariation).to.be.a('number');
                            expect(data.netChar.latencyVariation).to.be(0);
                            expect(data.netChar.latencyDistribution).to.be.a('string');
                            expect(data.netChar.latencyDistribution).to.be("Normal");
                            expect(data.netChar.throughput).to.be.a('number');
                            expect(data.netChar.throughput).to.be(0);
                            expect(data.netChar.throughputDl).to.be.a('number');
                            expect(data.netChar.throughputDl).to.be(0);
                            expect(data.netChar.throughputUl).to.be.a('number');
                            expect(data.netChar.throughputUl).to.be(0);
                            expect(data.netChar.packetLoss).to.be.a('number');
                            expect(data.netChar.packetLoss).to.be(0.0);
                          expect(data.interFogLatency).to.be.a('number');
                          expect(data.interFogLatency).to.be(0);
                          expect(data.interFogLatencyVariation).to.be.a('number');
                          expect(data.interFogLatencyVariation).to.be(0);
                          expect(data.interFogThroughput).to.be.a('number');
                          expect(data.interFogThroughput).to.be(0);
                          expect(data.interFogPacketLoss).to.be.a('number');
                          expect(data.interFogPacketLoss).to.be(0.0);
                          expect(data.interEdgeLatency).to.be.a('number');
                          expect(data.interEdgeLatency).to.be(0);
                          expect(data.interEdgeLatencyVariation).to.be.a('number');
                          expect(data.interEdgeLatencyVariation).to.be(0);
                          expect(data.interEdgeThroughput).to.be.a('number');
                          expect(data.interEdgeThroughput).to.be(0);
                          expect(data.interEdgePacketLoss).to.be.a('number');
                          expect(data.interEdgePacketLoss).to.be(0.0);
                          expect(data.edgeFogLatency).to.be.a('number');
                          expect(data.edgeFogLatency).to.be(0);
                          expect(data.edgeFogLatencyVariation).to.be.a('number');
                          expect(data.edgeFogLatencyVariation).to.be(0);
                          expect(data.edgeFogThroughput).to.be.a('number');
                          expect(data.edgeFogThroughput).to.be(0);
                          expect(data.edgeFogPacketLoss).to.be.a('number');
                          expect(data.edgeFogPacketLoss).to.be(0.0);
                          {
                            let dataCtr = data.meta;
                            expect(dataCtr).to.be.an(Object);
                            expect(dataCtr).to.not.be.empty();
                            for (let p in dataCtr) {
                              let data = dataCtr[p];
                              expect(data).to.be.a('string');
                              expect(data).to.be("");
                            }
                          }
                          {
                            let dataCtr = data.userMeta;
                            expect(dataCtr).to.be.an(Object);
                            expect(dataCtr).to.not.be.empty();
                            for (let p in dataCtr) {
                              let data = dataCtr[p];
                              expect(data).to.be.a('string');
                              expect(data).to.be("");
                            }
                          }
                          {
                            let dataCtr = data.networkLocations;
                            expect(dataCtr).to.be.an(Array);
                            expect(dataCtr).to.not.be.empty();
                            for (let p in dataCtr) {
                              let data = dataCtr[p];
                              expect(data).to.be.a(AdvantEdgePlatformControllerRestApi.NetworkLocation);
                              expect(data.id).to.be.a('string');
                              expect(data.id).to.be("");
                              expect(data.name).to.be.a('string');
                              expect(data.name).to.be("");
                              expect(data.type).to.be.a('string');
                              expect(data.type).to.be("POA");
                              expect(data.netChar).to.be.a(AdvantEdgePlatformControllerRestApi.NetworkCharacteristics);
                                    expect(data.netChar.latency).to.be.a('number');
                                expect(data.netChar.latency).to.be(0);
                                expect(data.netChar.latencyVariation).to.be.a('number');
                                expect(data.netChar.latencyVariation).to.be(0);
                                expect(data.netChar.latencyDistribution).to.be.a('string');
                                expect(data.netChar.latencyDistribution).to.be("Normal");
                                expect(data.netChar.throughput).to.be.a('number');
                                expect(data.netChar.throughput).to.be(0);
                                expect(data.netChar.throughputDl).to.be.a('number');
                                expect(data.netChar.throughputDl).to.be(0);
                                expect(data.netChar.throughputUl).to.be.a('number');
                                expect(data.netChar.throughputUl).to.be(0);
                                expect(data.netChar.packetLoss).to.be.a('number');
                                expect(data.netChar.packetLoss).to.be(0.0);
                              expect(data.terminalLinkLatency).to.be.a('number');
                              expect(data.terminalLinkLatency).to.be(0);
                              expect(data.terminalLinkLatencyVariation).to.be.a('number');
                              expect(data.terminalLinkLatencyVariation).to.be(0);
                              expect(data.terminalLinkThroughput).to.be.a('number');
                              expect(data.terminalLinkThroughput).to.be(0);
                              expect(data.terminalLinkPacketLoss).to.be.a('number');
                              expect(data.terminalLinkPacketLoss).to.be(0.0);
                              {
                                let dataCtr = data.meta;
                                expect(dataCtr).to.be.an(Object);
                                expect(dataCtr).to.not.be.empty();
                                for (let p in dataCtr) {
                                  let data = dataCtr[p];
                                  expect(data).to.be.a('string');
                                  expect(data).to.be("");
                                }
                              }
                              {
                                let dataCtr = data.userMeta;
                                expect(dataCtr).to.be.an(Object);
                                expect(dataCtr).to.not.be.empty();
                                for (let p in dataCtr) {
                                  let data = dataCtr[p];
                                  expect(data).to.be.a('string');
                                  expect(data).to.be("");
                                }
                              }
                              expect(data.cellularPoaConfig).to.be.a(AdvantEdgePlatformControllerRestApi.CellularPoaConfig);
                                    expect(data.cellularPoaConfig.cellId).to.be.a('string');
                                expect(data.cellularPoaConfig.cellId).to.be("");
                              expect(data.poa4GConfig).to.be.a(AdvantEdgePlatformControllerRestApi.Poa4GConfig);
                                    expect(data.poa4GConfig.cellId).to.be.a('string');
                                expect(data.poa4GConfig.cellId).to.be("");
                              expect(data.poa5GConfig).to.be.a(AdvantEdgePlatformControllerRestApi.Poa5GConfig);
                                    expect(data.poa5GConfig.cellId).to.be.a('string');
                                expect(data.poa5GConfig.cellId).to.be("");
                              expect(data.poaWifiConfig).to.be.a(AdvantEdgePlatformControllerRestApi.PoaWifiConfig);
                                    expect(data.poaWifiConfig.macId).to.be.a('string');
                                expect(data.poaWifiConfig.macId).to.be("");
                              expect(data.geoData).to.be.a(AdvantEdgePlatformControllerRestApi.GeoData);
                                    expect(data.geoData.location).to.be.a(AdvantEdgePlatformControllerRestApi.Point);
                                      expect(data.geoData.location.type).to.be.a('string');
                                  expect(data.geoData.location.type).to.be("Point");
                                  {
                                    let dataCtr = data.geoData.location.coordinates;
                                    expect(dataCtr).to.be.an(Array);
                                    expect(dataCtr).to.not.be.empty();
                                    for (let p in dataCtr) {
                                      let data = dataCtr[p];
                                      expect(data).to.be.a('number');
                                      expect(data).to.be();
                                    }
                                  }
                                expect(data.geoData.radius).to.be.a('number');
                                expect(data.geoData.radius).to.be();
                                expect(data.geoData.path).to.be.a(AdvantEdgePlatformControllerRestApi.LineString);
                                      expect(data.geoData.path.type).to.be.a('string');
                                  expect(data.geoData.path.type).to.be("LineString");
                                  {
                                    let dataCtr = data.geoData.path.coordinates;
                                    expect(dataCtr).to.be.an(Array);
                                    expect(dataCtr).to.not.be.empty();
                                    for (let p in dataCtr) {
                                      let data = dataCtr[p];
                                      expect(data).to.be.a(Array);
                                      expect(data).to.be([]);
                                    }
                                  }
                                expect(data.geoData.eopMode).to.be.a('string');
                                expect(data.geoData.eopMode).to.be("LOOP");
                                expect(data.geoData.velocity).to.be.a('number');
                                expect(data.geoData.velocity).to.be();
                              {
                                let dataCtr = data.physicalLocations;
                                expect(dataCtr).to.be.an(Array);
                                expect(dataCtr).to.not.be.empty();
                                for (let p in dataCtr) {
                                  let data = dataCtr[p];
                                  expect(data).to.be.a(AdvantEdgePlatformControllerRestApi.PhysicalLocation);
                                  expect(data.id).to.be.a('string');
                                  expect(data.id).to.be("");
                                  expect(data.name).to.be.a('string');
                                  expect(data.name).to.be("");
                                  expect(data.type).to.be.a('string');
                                  expect(data.type).to.be("UE");
                                  expect(data.isExternal).to.be.a('boolean');
                                  expect(data.isExternal).to.be(false);
                                  expect(data.geoData).to.be.a(AdvantEdgePlatformControllerRestApi.GeoData);
                                        expect(data.geoData.location).to.be.a(AdvantEdgePlatformControllerRestApi.Point);
                                          expect(data.geoData.location.type).to.be.a('string');
                                      expect(data.geoData.location.type).to.be("Point");
                                      {
                                        let dataCtr = data.geoData.location.coordinates;
                                        expect(dataCtr).to.be.an(Array);
                                        expect(dataCtr).to.not.be.empty();
                                        for (let p in dataCtr) {
                                          let data = dataCtr[p];
                                          expect(data).to.be.a('number');
                                          expect(data).to.be();
                                        }
                                      }
                                    expect(data.geoData.radius).to.be.a('number');
                                    expect(data.geoData.radius).to.be();
                                    expect(data.geoData.path).to.be.a(AdvantEdgePlatformControllerRestApi.LineString);
                                          expect(data.geoData.path.type).to.be.a('string');
                                      expect(data.geoData.path.type).to.be("LineString");
                                      {
                                        let dataCtr = data.geoData.path.coordinates;
                                        expect(dataCtr).to.be.an(Array);
                                        expect(dataCtr).to.not.be.empty();
                                        for (let p in dataCtr) {
                                          let data = dataCtr[p];
                                          expect(data).to.be.a(Array);
                                          expect(data).to.be([]);
                                        }
                                      }
                                    expect(data.geoData.eopMode).to.be.a('string');
                                    expect(data.geoData.eopMode).to.be("LOOP");
                                    expect(data.geoData.velocity).to.be.a('number');
                                    expect(data.geoData.velocity).to.be();
                                  {
                                    let dataCtr = data.networkLocationsInRange;
                                    expect(dataCtr).to.be.an(Array);
                                    expect(dataCtr).to.not.be.empty();
                                    for (let p in dataCtr) {
                                      let data = dataCtr[p];
                                      expect(data).to.be.a('string');
                                      expect(data).to.be("");
                                    }
                                  }
                                  expect(data.connected).to.be.a('boolean');
                                  expect(data.connected).to.be(false);
                                  expect(data.wireless).to.be.a('boolean');
                                  expect(data.wireless).to.be(false);
                                  expect(data.wirelessType).to.be.a('string');
                                  expect(data.wirelessType).to.be("");
                                  {
                                    let dataCtr = data.meta;
                                    expect(dataCtr).to.be.an(Object);
                                    expect(dataCtr).to.not.be.empty();
                                    for (let p in dataCtr) {
                                      let data = dataCtr[p];
                                      expect(data).to.be.a('string');
                                      expect(data).to.be("");
                                    }
                                  }
                                  {
                                    let dataCtr = data.userMeta;
                                    expect(dataCtr).to.be.an(Object);
                                    expect(dataCtr).to.not.be.empty();
                                    for (let p in dataCtr) {
                                      let data = dataCtr[p];
                                      expect(data).to.be.a('string');
                                      expect(data).to.be("");
                                    }
                                  }
                                  {
                                    let dataCtr = data.processes;
                                    expect(dataCtr).to.be.an(Array);
                                    expect(dataCtr).to.not.be.empty();
                                    for (let p in dataCtr) {
                                      let data = dataCtr[p];
                                      expect(data).to.be.a(AdvantEdgePlatformControllerRestApi.Process);
                                      expect(data.id).to.be.a('string');
                                      expect(data.id).to.be("");
                                      expect(data.name).to.be.a('string');
                                      expect(data.name).to.be("");
                                      expect(data.type).to.be.a('string');
                                      expect(data.type).to.be("UE-APP");
                                      expect(data.isExternal).to.be.a('boolean');
                                      expect(data.isExternal).to.be(false);
                                      expect(data.image).to.be.a('string');
                                      expect(data.image).to.be("");
                                      expect(data.environment).to.be.a('string');
                                      expect(data.environment).to.be("");
                                      expect(data.commandArguments).to.be.a('string');
                                      expect(data.commandArguments).to.be("");
                                      expect(data.commandExe).to.be.a('string');
                                      expect(data.commandExe).to.be("");
                                      expect(data.serviceConfig).to.be.a(AdvantEdgePlatformControllerRestApi.ServiceConfig);
                                            expect(data.serviceConfig.name).to.be.a('string');
                                        expect(data.serviceConfig.name).to.be("");
                                        expect(data.serviceConfig.meSvcName).to.be.a('string');
                                        expect(data.serviceConfig.meSvcName).to.be("");
                                        {
                                          let dataCtr = data.serviceConfig.ports;
                                          expect(dataCtr).to.be.an(Array);
                                          expect(dataCtr).to.not.be.empty();
                                          for (let p in dataCtr) {
                                            let data = dataCtr[p];
                                            expect(data).to.be.a(AdvantEdgePlatformControllerRestApi.ServicePort);
                                            expect(data.protocol).to.be.a('string');
                                            expect(data.protocol).to.be("");
                                            expect(data.port).to.be.a('number');
                                            expect(data.port).to.be(0);
                                            expect(data.externalPort).to.be.a('number');
                                            expect(data.externalPort).to.be(0);
                                          }
                                        }
                                      expect(data.gpuConfig).to.be.a(AdvantEdgePlatformControllerRestApi.GpuConfig);
                                            expect(data.gpuConfig.type).to.be.a('string');
                                        expect(data.gpuConfig.type).to.be("");
                                        expect(data.gpuConfig.count).to.be.a('number');
                                        expect(data.gpuConfig.count).to.be(0);
                                      expect(data.memoryConfig).to.be.a(AdvantEdgePlatformControllerRestApi.MemoryConfig);
                                            expect(data.memoryConfig.min).to.be.a('number');
                                        expect(data.memoryConfig.min).to.be(0);
                                        expect(data.memoryConfig.max).to.be.a('number');
                                        expect(data.memoryConfig.max).to.be(0);
                                      expect(data.cpuConfig).to.be.a(AdvantEdgePlatformControllerRestApi.CpuConfig);
                                            expect(data.cpuConfig.min).to.be.a('number');
                                        expect(data.cpuConfig.min).to.be(0.0);
                                        expect(data.cpuConfig.max).to.be.a('number');
                                        expect(data.cpuConfig.max).to.be(0.0);
                                      expect(data.externalConfig).to.be.a(AdvantEdgePlatformControllerRestApi.ExternalConfig);
                                            {
                                          let dataCtr = data.externalConfig.ingressServiceMap;
                                          expect(dataCtr).to.be.an(Array);
                                          expect(dataCtr).to.not.be.empty();
                                          for (let p in dataCtr) {
                                            let data = dataCtr[p];
                                            expect(data).to.be.a(AdvantEdgePlatformControllerRestApi.IngressService);
                                            expect(data.name).to.be.a('string');
                                            expect(data.name).to.be("");
                                            expect(data.port).to.be.a('number');
                                            expect(data.port).to.be(0);
                                            expect(data.externalPort).to.be.a('number');
                                            expect(data.externalPort).to.be(0);
                                            expect(data.protocol).to.be.a('string');
                                            expect(data.protocol).to.be("");
                                          }
                                        }
                                        {
                                          let dataCtr = data.externalConfig.egressServiceMap;
                                          expect(dataCtr).to.be.an(Array);
                                          expect(dataCtr).to.not.be.empty();
                                          for (let p in dataCtr) {
                                            let data = dataCtr[p];
                                            expect(data).to.be.a(AdvantEdgePlatformControllerRestApi.EgressService);
                                            expect(data.name).to.be.a('string');
                                            expect(data.name).to.be("");
                                            expect(data.meSvcName).to.be.a('string');
                                            expect(data.meSvcName).to.be("");
                                            expect(data.ip).to.be.a('string');
                                            expect(data.ip).to.be("");
                                            expect(data.port).to.be.a('number');
                                            expect(data.port).to.be(0);
                                            expect(data.protocol).to.be.a('string');
                                            expect(data.protocol).to.be("");
                                          }
                                        }
                                      expect(data.status).to.be.a('string');
                                      expect(data.status).to.be("");
                                      expect(data.userChartLocation).to.be.a('string');
                                      expect(data.userChartLocation).to.be("");
                                      expect(data.userChartAlternateValues).to.be.a('string');
                                      expect(data.userChartAlternateValues).to.be("");
                                      expect(data.userChartGroup).to.be.a('string');
                                      expect(data.userChartGroup).to.be("");
                                      {
                                        let dataCtr = data.meta;
                                        expect(dataCtr).to.be.an(Object);
                                        expect(dataCtr).to.not.be.empty();
                                        for (let p in dataCtr) {
                                          let data = dataCtr[p];
                                          expect(data).to.be.a('string');
                                          expect(data).to.be("");
                                        }
                                      }
                                      {
                                        let dataCtr = data.userMeta;
                                        expect(dataCtr).to.be.an(Object);
                                        expect(dataCtr).to.not.be.empty();
                                        for (let p in dataCtr) {
                                          let data = dataCtr[p];
                                          expect(data).to.be.a('string');
                                          expect(data).to.be("");
                                        }
                                      }
                                      expect(data.netChar).to.be.a(AdvantEdgePlatformControllerRestApi.NetworkCharacteristics);
                                            expect(data.netChar.latency).to.be.a('number');
                                        expect(data.netChar.latency).to.be(0);
                                        expect(data.netChar.latencyVariation).to.be.a('number');
                                        expect(data.netChar.latencyVariation).to.be(0);
                                        expect(data.netChar.latencyDistribution).to.be.a('string');
                                        expect(data.netChar.latencyDistribution).to.be("Normal");
                                        expect(data.netChar.throughput).to.be.a('number');
                                        expect(data.netChar.throughput).to.be(0);
                                        expect(data.netChar.throughputDl).to.be.a('number');
                                        expect(data.netChar.throughputDl).to.be(0);
                                        expect(data.netChar.throughputUl).to.be.a('number');
                                        expect(data.netChar.throughputUl).to.be(0);
                                        expect(data.netChar.packetLoss).to.be.a('number');
                                        expect(data.netChar.packetLoss).to.be(0.0);
                                      expect(data.appLatency).to.be.a('number');
                                      expect(data.appLatency).to.be(0);
                                      expect(data.appLatencyVariation).to.be.a('number');
                                      expect(data.appLatencyVariation).to.be(0);
                                      expect(data.appThroughput).to.be.a('number');
                                      expect(data.appThroughput).to.be(0);
                                      expect(data.appPacketLoss).to.be.a('number');
                                      expect(data.appPacketLoss).to.be(0.0);
                                      expect(data.placementId).to.be.a('string');
                                      expect(data.placementId).to.be("");
                                    }
                                  }
                                  expect(data.netChar).to.be.a(AdvantEdgePlatformControllerRestApi.NetworkCharacteristics);
                                        expect(data.netChar.latency).to.be.a('number');
                                    expect(data.netChar.latency).to.be(0);
                                    expect(data.netChar.latencyVariation).to.be.a('number');
                                    expect(data.netChar.latencyVariation).to.be(0);
                                    expect(data.netChar.latencyDistribution).to.be.a('string');
                                    expect(data.netChar.latencyDistribution).to.be("Normal");
                                    expect(data.netChar.throughput).to.be.a('number');
                                    expect(data.netChar.throughput).to.be(0);
                                    expect(data.netChar.throughputDl).to.be.a('number');
                                    expect(data.netChar.throughputDl).to.be(0);
                                    expect(data.netChar.throughputUl).to.be.a('number');
                                    expect(data.netChar.throughputUl).to.be(0);
                                    expect(data.netChar.packetLoss).to.be.a('number');
                                    expect(data.netChar.packetLoss).to.be(0.0);
                                  expect(data.linkLatency).to.be.a('number');
                                  expect(data.linkLatency).to.be(0);
                                  expect(data.linkLatencyVariation).to.be.a('number');
                                  expect(data.linkLatencyVariation).to.be(0);
                                  expect(data.linkThroughput).to.be.a('number');
                                  expect(data.linkThroughput).to.be(0);
                                  expect(data.linkPacketLoss).to.be.a('number');
                                  expect(data.linkPacketLoss).to.be(0.0);
                                  expect(data.macId).to.be.a('string');
                                  expect(data.macId).to.be("");
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
              }
            }

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('setScenario', function() {
        it('should call setScenario successfully', function(done) {
          // TODO: uncomment, update parameter values for setScenario call
          /*
          var name = "name_example";
          var scenario = new AdvantEdgePlatformControllerRestApi.Scenario();
          scenario.version = "";
          scenario.id = "";
          scenario.name = "";
          scenario.description = "";
          scenario.config = new AdvantEdgePlatformControllerRestApi.ScenarioConfig();
          scenario.config.visualization = "";
          scenario.config.other = "";
          scenario.deployment = new AdvantEdgePlatformControllerRestApi.Deployment();
          scenario.deployment.netChar = new AdvantEdgePlatformControllerRestApi.NetworkCharacteristics();
          scenario.deployment.netChar.latency = 0;
          scenario.deployment.netChar.latencyVariation = 0;
          scenario.deployment.netChar.latencyDistribution = "Normal";
          scenario.deployment.netChar.throughput = 0;
          scenario.deployment.netChar.throughputDl = 0;
          scenario.deployment.netChar.throughputUl = 0;
          scenario.deployment.netChar.packetLoss = 0.0;
          scenario.deployment.interDomainLatency = 0;
          scenario.deployment.interDomainLatencyVariation = 0;
          scenario.deployment.interDomainThroughput = 0;
          scenario.deployment.interDomainPacketLoss = 0.0;
          scenario.deployment.meta = {key: ""};
          scenario.deployment.userMeta = {key: ""};
          scenario.deployment.domains = [new AdvantEdgePlatformControllerRestApi.Domain()];
          scenario.deployment.domains[0].id = "";
          scenario.deployment.domains[0].name = "";
          scenario.deployment.domains[0].type = "OPERATOR";
          scenario.deployment.domains[0].netChar = new AdvantEdgePlatformControllerRestApi.NetworkCharacteristics();
          scenario.deployment.domains[0].netChar.latency = 0;
          scenario.deployment.domains[0].netChar.latencyVariation = 0;
          scenario.deployment.domains[0].netChar.latencyDistribution = "Normal";
          scenario.deployment.domains[0].netChar.throughput = 0;
          scenario.deployment.domains[0].netChar.throughputDl = 0;
          scenario.deployment.domains[0].netChar.throughputUl = 0;
          scenario.deployment.domains[0].netChar.packetLoss = 0.0;
          scenario.deployment.domains[0].interZoneLatency = 0;
          scenario.deployment.domains[0].interZoneLatencyVariation = 0;
          scenario.deployment.domains[0].interZoneThroughput = 0;
          scenario.deployment.domains[0].interZonePacketLoss = 0.0;
          scenario.deployment.domains[0].meta = {key: ""};
          scenario.deployment.domains[0].userMeta = {key: ""};
          scenario.deployment.domains[0].cellularDomainConfig = new AdvantEdgePlatformControllerRestApi.CellularDomainConfig();
          scenario.deployment.domains[0].cellularDomainConfig.mnc = "";
          scenario.deployment.domains[0].cellularDomainConfig.mcc = "";
          scenario.deployment.domains[0].cellularDomainConfig.defaultCellId = "";
          scenario.deployment.domains[0].zones = [new AdvantEdgePlatformControllerRestApi.Zone()];
          scenario.deployment.domains[0].zones[0].id = "";
          scenario.deployment.domains[0].zones[0].name = "";
          scenario.deployment.domains[0].zones[0].type = "ZONE";
          scenario.deployment.domains[0].zones[0].netChar = new AdvantEdgePlatformControllerRestApi.NetworkCharacteristics();
          scenario.deployment.domains[0].zones[0].netChar.latency = 0;
          scenario.deployment.domains[0].zones[0].netChar.latencyVariation = 0;
          scenario.deployment.domains[0].zones[0].netChar.latencyDistribution = "Normal";
          scenario.deployment.domains[0].zones[0].netChar.throughput = 0;
          scenario.deployment.domains[0].zones[0].netChar.throughputDl = 0;
          scenario.deployment.domains[0].zones[0].netChar.throughputUl = 0;
          scenario.deployment.domains[0].zones[0].netChar.packetLoss = 0.0;
          scenario.deployment.domains[0].zones[0].interFogLatency = 0;
          scenario.deployment.domains[0].zones[0].interFogLatencyVariation = 0;
          scenario.deployment.domains[0].zones[0].interFogThroughput = 0;
          scenario.deployment.domains[0].zones[0].interFogPacketLoss = 0.0;
          scenario.deployment.domains[0].zones[0].interEdgeLatency = 0;
          scenario.deployment.domains[0].zones[0].interEdgeLatencyVariation = 0;
          scenario.deployment.domains[0].zones[0].interEdgeThroughput = 0;
          scenario.deployment.domains[0].zones[0].interEdgePacketLoss = 0.0;
          scenario.deployment.domains[0].zones[0].edgeFogLatency = 0;
          scenario.deployment.domains[0].zones[0].edgeFogLatencyVariation = 0;
          scenario.deployment.domains[0].zones[0].edgeFogThroughput = 0;
          scenario.deployment.domains[0].zones[0].edgeFogPacketLoss = 0.0;
          scenario.deployment.domains[0].zones[0].meta = {key: ""};
          scenario.deployment.domains[0].zones[0].userMeta = {key: ""};
          scenario.deployment.domains[0].zones[0].networkLocations = [new AdvantEdgePlatformControllerRestApi.NetworkLocation()];
          scenario.deployment.domains[0].zones[0].networkLocations[0].id = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].name = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].type = "POA";
          scenario.deployment.domains[0].zones[0].networkLocations[0].netChar = new AdvantEdgePlatformControllerRestApi.NetworkCharacteristics();
          scenario.deployment.domains[0].zones[0].networkLocations[0].netChar.latency = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].netChar.latencyVariation = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].netChar.latencyDistribution = "Normal";
          scenario.deployment.domains[0].zones[0].networkLocations[0].netChar.throughput = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].netChar.throughputDl = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].netChar.throughputUl = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].netChar.packetLoss = 0.0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].terminalLinkLatency = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].terminalLinkLatencyVariation = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].terminalLinkThroughput = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].terminalLinkPacketLoss = 0.0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].meta = {key: ""};
          scenario.deployment.domains[0].zones[0].networkLocations[0].userMeta = {key: ""};
          scenario.deployment.domains[0].zones[0].networkLocations[0].cellularPoaConfig = new AdvantEdgePlatformControllerRestApi.CellularPoaConfig();
          scenario.deployment.domains[0].zones[0].networkLocations[0].cellularPoaConfig.cellId = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].poa4GConfig = new AdvantEdgePlatformControllerRestApi.Poa4GConfig();
          scenario.deployment.domains[0].zones[0].networkLocations[0].poa4GConfig.cellId = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].poa5GConfig = new AdvantEdgePlatformControllerRestApi.Poa5GConfig();
          scenario.deployment.domains[0].zones[0].networkLocations[0].poa5GConfig.cellId = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].poaWifiConfig = new AdvantEdgePlatformControllerRestApi.PoaWifiConfig();
          scenario.deployment.domains[0].zones[0].networkLocations[0].poaWifiConfig.macId = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].geoData = new AdvantEdgePlatformControllerRestApi.GeoData();
          scenario.deployment.domains[0].zones[0].networkLocations[0].geoData.location = new AdvantEdgePlatformControllerRestApi.Point();
          scenario.deployment.domains[0].zones[0].networkLocations[0].geoData.location.type = "Point";
          scenario.deployment.domains[0].zones[0].networkLocations[0].geoData.location.coordinates = [];
          scenario.deployment.domains[0].zones[0].networkLocations[0].geoData.radius = ;
          scenario.deployment.domains[0].zones[0].networkLocations[0].geoData.path = new AdvantEdgePlatformControllerRestApi.LineString();
          scenario.deployment.domains[0].zones[0].networkLocations[0].geoData.path.type = "LineString";
          scenario.deployment.domains[0].zones[0].networkLocations[0].geoData.path.coordinates = [[]];
          scenario.deployment.domains[0].zones[0].networkLocations[0].geoData.eopMode = "LOOP";
          scenario.deployment.domains[0].zones[0].networkLocations[0].geoData.velocity = ;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations = [new AdvantEdgePlatformControllerRestApi.PhysicalLocation()];
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].id = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].name = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].type = "UE";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].isExternal = false;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].geoData = new AdvantEdgePlatformControllerRestApi.GeoData();
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].geoData.location = new AdvantEdgePlatformControllerRestApi.Point();
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].geoData.location.type = "Point";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].geoData.location.coordinates = [];
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].geoData.radius = ;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].geoData.path = new AdvantEdgePlatformControllerRestApi.LineString();
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].geoData.path.type = "LineString";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].geoData.path.coordinates = [[]];
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].geoData.eopMode = "LOOP";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].geoData.velocity = ;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].networkLocationsInRange = [""];
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].connected = false;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].wireless = false;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].wirelessType = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].meta = {key: ""};
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].userMeta = {key: ""};
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes = [new AdvantEdgePlatformControllerRestApi.Process()];
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].id = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].name = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].type = "UE-APP";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].isExternal = false;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].image = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].environment = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].commandArguments = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].commandExe = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].serviceConfig = new AdvantEdgePlatformControllerRestApi.ServiceConfig();
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].serviceConfig.name = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].serviceConfig.meSvcName = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].serviceConfig.ports = [new AdvantEdgePlatformControllerRestApi.ServicePort()];
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].serviceConfig.ports[0].protocol = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].serviceConfig.ports[0].port = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].serviceConfig.ports[0].externalPort = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].gpuConfig = new AdvantEdgePlatformControllerRestApi.GpuConfig();
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].gpuConfig.type = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].gpuConfig.count = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].memoryConfig = new AdvantEdgePlatformControllerRestApi.MemoryConfig();
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].memoryConfig.min = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].memoryConfig.max = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].cpuConfig = new AdvantEdgePlatformControllerRestApi.CpuConfig();
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].cpuConfig.min = 0.0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].cpuConfig.max = 0.0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].externalConfig = new AdvantEdgePlatformControllerRestApi.ExternalConfig();
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].externalConfig.ingressServiceMap = [new AdvantEdgePlatformControllerRestApi.IngressService()];
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].externalConfig.ingressServiceMap[0].name = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].externalConfig.ingressServiceMap[0].port = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].externalConfig.ingressServiceMap[0].externalPort = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].externalConfig.ingressServiceMap[0].protocol = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].externalConfig.egressServiceMap = [new AdvantEdgePlatformControllerRestApi.EgressService()];
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].externalConfig.egressServiceMap[0].name = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].externalConfig.egressServiceMap[0].meSvcName = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].externalConfig.egressServiceMap[0].ip = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].externalConfig.egressServiceMap[0].port = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].externalConfig.egressServiceMap[0].protocol = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].status = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].userChartLocation = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].userChartAlternateValues = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].userChartGroup = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].meta = {key: ""};
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].userMeta = {key: ""};
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].netChar = new AdvantEdgePlatformControllerRestApi.NetworkCharacteristics();
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].netChar.latency = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].netChar.latencyVariation = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].netChar.latencyDistribution = "Normal";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].netChar.throughput = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].netChar.throughputDl = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].netChar.throughputUl = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].netChar.packetLoss = 0.0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].appLatency = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].appLatencyVariation = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].appThroughput = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].appPacketLoss = 0.0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].processes[0].placementId = "";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].netChar = new AdvantEdgePlatformControllerRestApi.NetworkCharacteristics();
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].netChar.latency = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].netChar.latencyVariation = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].netChar.latencyDistribution = "Normal";
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].netChar.throughput = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].netChar.throughputDl = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].netChar.throughputUl = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].netChar.packetLoss = 0.0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].linkLatency = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].linkLatencyVariation = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].linkThroughput = 0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].linkPacketLoss = 0.0;
          scenario.deployment.domains[0].zones[0].networkLocations[0].physicalLocations[0].macId = "";

          instance.setScenario(name, scenario, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
    });
  });

}));
