/*
 * Copyright (c) 2020  InterDigital Communications, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the \"License\");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an \"AS IS\" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE Radio Network Information Service REST API
 *
 * Radio Network Information Service is AdvantEDGE's implementation of [ETSI MEC ISG MEC012 RNI API](http://www.etsi.org/deliver/etsi_gs/MEC/001_099/012/02.01.01_60/gs_MEC012v020101p.pdf) <p>[Copyright (c) ETSI 2017](https://forge.etsi.org/etsi-forge-copyright-notice.txt) <p>**Micro-service**<br>[meep-rnis](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-rnis) <p>**Type & Usage**<br>Edge Service used by edge applications that want to get information about radio conditions in the network <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_ <p>AdvantEDGE supports a selected subset of RNI API endpoints (see below) and a subset of subscription types. <p>Supported subscriptions: <p> - CellChangeSubscription <p> - RabEstSubscription <p> - RabRelSubscription
 *
 * API version: 2.1.1
 * Contact: AdvantEDGE@InterDigital.com
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */

package client

import (
	"context"
	"io/ioutil"
	"net/http"
	"net/url"
	"strings"

	"github.com/antihax/optional"
)

// Linger please
var (
	_ context.Context
)

type UnsupportedApiService service

/*
UnsupportedApiService Retrieve information on layer 2 measurements
Queries information about the layer 2 measurements.
 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param optional nil or *Layer2MeasInfoGETOpts - Optional Parameters:
     * @param "AppInsId" (optional.String) -  Application instance identifier
     * @param "CellId" (optional.Interface of []string) -  Comma separated list of E-UTRAN Cell Identities
     * @param "UeIpv4Address" (optional.Interface of []string) -  Comma separated list of IE IPv4 addresses as defined for the type for AssociateId
     * @param "UeIpv6Address" (optional.Interface of []string) -  Comma separated list of IE IPv6 addresses as defined for the type for AssociateId
     * @param "NatedIpAddress" (optional.Interface of []string) -  Comma separated list of IE NATed IP addresses as defined for the type for AssociateId
     * @param "GtpTeid" (optional.Interface of []string) -  Comma separated list of GTP TEID addresses as defined for the type for AssociateId
     * @param "DlGbrPrbUsageCell" (optional.Int32) -  PRB usage for downlink GBR traffic in percentage as defined in ETSI TS 136 314
     * @param "UlGbrPrbUsageCell" (optional.Int32) -  PRB usage for uplink GBR traffic in percentage as defined in ETSI TS 136 314
     * @param "DlNongbrPrbUsageCell" (optional.Int32) -  PRB usage for downlink non-GBR traffic in percentage as defined in ETSI TS 136 314
     * @param "UlNongbrPrbUsageCell" (optional.Int32) -  PRB usage for uplink non-GBR traffic in percentage as defined in ETSI TS 136 314
     * @param "DlTotalPrbUsageCell" (optional.Int32) -  PRB usage for total downlink traffic in percentage as defined in ETSI TS 136 314
     * @param "UlTotalPrbUsageCell" (optional.Int32) -  PRB usage for total uplink traffic in percentage as defined in ETSI TS 136 314
     * @param "ReceivedDedicatedPreamblesCell" (optional.Int32) -  Received dedicated preambles in percentage as defined in ETSI TS 136 314
     * @param "ReceivedRandomlySelectedPreamblesLowRangeCell" (optional.Int32) -  Received randomly selected preambles in the low range in percentage as defined in ETSI TS 136 314
     * @param "ReceivedRandomlySelectedPreamblesHighRangeCell" (optional.Int32) -  Received rendomly selected preambles in the high range in percentage as defined in ETSI TS 136 314
     * @param "NumberOfActiveUeDlGbrCell" (optional.Int32) -  Number of active UEs with downlink GBR traffic as defined in ETSI TS 136 314
     * @param "NumberOfActiveUeUlGbrCell" (optional.Int32) -  Number of active UEs with uplink GBR traffic as defined in ETSI TS 136 314
     * @param "NumberOfActiveUeDlNongbrCell" (optional.Int32) -  Number of active UEs with downlink non-GBR traffic as defined in ETSI TS 136 314
     * @param "NumberOfActiveUeUlNongbrCell" (optional.Int32) -  Number of active UEs with uplink non-GBR traffic as defined in ETSI TS 136 314
     * @param "DlGbrPdrCell" (optional.Int32) -  Packet discard rate for downlink GBR traffic in percentage as defined in ETSI TS 136 314
     * @param "UlGbrPdrCell" (optional.Int32) -  Packet discard rate for uplink GBR traffic in percentage as defined in ETSI TS 136 314
     * @param "DlNongbrPdrCell" (optional.Int32) -  Packet discard rate for downlink non-GBR traffic in percentage as defined in ETSI TS 136 314
     * @param "UlNongbrPdrCell" (optional.Int32) -  Packet discard rate for uplink non-GBR traffic in percentage as defined in ETSI TS 136 314
     * @param "DlGbrDelayUe" (optional.Int32) -  Packet delay of downlink GBR traffic of a UE as defined in ETSI TS 136 314
     * @param "UlGbrDelayUe" (optional.Int32) -  Packet delay of uplink GBR traffic of a UE as defined in ETSI TS 136 314
     * @param "DlNongbrDelayUe" (optional.Int32) -  Packet delay of downlink non-GBR traffic of a UE as defined in ETSI TS 136 314
     * @param "UlNongbrDelayUe" (optional.Int32) -  Packet delay of uplink non-GBR traffic of a UE as defined in ETSI TS 136 314
     * @param "DlGbrPdrUe" (optional.Int32) -  Packet discard rate of downlink GBR traffic of a UE in percentage as defined in ETSI TS 136 314
     * @param "UlGbrPdrUe" (optional.Int32) -  Packet discard rate of uplink GBR traffic of a UE in percentage as defined in ETSI TS 136 314
     * @param "DlNongbrPdrUe" (optional.Int32) -  Packet discard rate of downlink non-GBR traffic of a UE in percentage as defined in ETSI TS 136 314
     * @param "UlNongbrPdrUe" (optional.Int32) -  Packet discard rate of uplink non-GBR traffic of a UE in percentage as defined in ETSI TS 136 314
     * @param "DlGbrThroughputUe" (optional.Int32) -  Scheduled throughput of downlink GBR traffic of a UE as defined in ETSI TS 136 314
     * @param "UlGbrThroughputUe" (optional.Int32) -  Scheduled throughput of uplink GBR traffic of a UE as defined in ETSI TS 136 314
     * @param "DlNongbrThroughputUe" (optional.Int32) -  Scheduled throughput of downlink non-GBR traffic of a UE as defined in ETSI TS 136 314
     * @param "UlNongbrThroughputUe" (optional.Int32) -  Scheduled throughput of uplink non-GBR traffic of a UE as defined in ETSI TS 136 314
     * @param "DlGbrDataVolumeUe" (optional.Int32) -  Data volume of downlink GBR traffic of a UE as defined in ETSI TS 136 314
     * @param "UlGbrDataVolumeUe" (optional.Int32) -  Data volume of uplink GBR traffic of a UE as defined in ETSI TS 136 314
     * @param "DlNongbrDataVolumeUe" (optional.Int32) -  Data volume of downlink non-GBR traffic of a UE as defined in ETSI TS 136 314
     * @param "UlNongbrDataVolumeUe" (optional.Int32) -  Data volume of uplink non-GBR traffic of a UE as defined in ETSI TS 136 314

@return L2Meas
*/

type Layer2MeasInfoGETOpts struct {
	AppInsId                                       optional.String
	CellId                                         optional.Interface
	UeIpv4Address                                  optional.Interface
	UeIpv6Address                                  optional.Interface
	NatedIpAddress                                 optional.Interface
	GtpTeid                                        optional.Interface
	DlGbrPrbUsageCell                              optional.Int32
	UlGbrPrbUsageCell                              optional.Int32
	DlNongbrPrbUsageCell                           optional.Int32
	UlNongbrPrbUsageCell                           optional.Int32
	DlTotalPrbUsageCell                            optional.Int32
	UlTotalPrbUsageCell                            optional.Int32
	ReceivedDedicatedPreamblesCell                 optional.Int32
	ReceivedRandomlySelectedPreamblesLowRangeCell  optional.Int32
	ReceivedRandomlySelectedPreamblesHighRangeCell optional.Int32
	NumberOfActiveUeDlGbrCell                      optional.Int32
	NumberOfActiveUeUlGbrCell                      optional.Int32
	NumberOfActiveUeDlNongbrCell                   optional.Int32
	NumberOfActiveUeUlNongbrCell                   optional.Int32
	DlGbrPdrCell                                   optional.Int32
	UlGbrPdrCell                                   optional.Int32
	DlNongbrPdrCell                                optional.Int32
	UlNongbrPdrCell                                optional.Int32
	DlGbrDelayUe                                   optional.Int32
	UlGbrDelayUe                                   optional.Int32
	DlNongbrDelayUe                                optional.Int32
	UlNongbrDelayUe                                optional.Int32
	DlGbrPdrUe                                     optional.Int32
	UlGbrPdrUe                                     optional.Int32
	DlNongbrPdrUe                                  optional.Int32
	UlNongbrPdrUe                                  optional.Int32
	DlGbrThroughputUe                              optional.Int32
	UlGbrThroughputUe                              optional.Int32
	DlNongbrThroughputUe                           optional.Int32
	UlNongbrThroughputUe                           optional.Int32
	DlGbrDataVolumeUe                              optional.Int32
	UlGbrDataVolumeUe                              optional.Int32
	DlNongbrDataVolumeUe                           optional.Int32
	UlNongbrDataVolumeUe                           optional.Int32
}

func (a *UnsupportedApiService) Layer2MeasInfoGET(ctx context.Context, localVarOptionals *Layer2MeasInfoGETOpts) (L2Meas, *http.Response, error) {
	var (
		localVarHttpMethod  = strings.ToUpper("Get")
		localVarPostBody    interface{}
		localVarFileName    string
		localVarFileBytes   []byte
		localVarReturnValue L2Meas
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/queries/layer2_meas"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if localVarOptionals != nil && localVarOptionals.AppInsId.IsSet() {
		localVarQueryParams.Add("app_ins_id", parameterToString(localVarOptionals.AppInsId.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.CellId.IsSet() {
		localVarQueryParams.Add("cell_id", parameterToString(localVarOptionals.CellId.Value(), "multi"))
	}
	if localVarOptionals != nil && localVarOptionals.UeIpv4Address.IsSet() {
		localVarQueryParams.Add("ue_ipv4_address", parameterToString(localVarOptionals.UeIpv4Address.Value(), "multi"))
	}
	if localVarOptionals != nil && localVarOptionals.UeIpv6Address.IsSet() {
		localVarQueryParams.Add("ue_ipv6_address", parameterToString(localVarOptionals.UeIpv6Address.Value(), "multi"))
	}
	if localVarOptionals != nil && localVarOptionals.NatedIpAddress.IsSet() {
		localVarQueryParams.Add("nated_ip_address", parameterToString(localVarOptionals.NatedIpAddress.Value(), "multi"))
	}
	if localVarOptionals != nil && localVarOptionals.GtpTeid.IsSet() {
		localVarQueryParams.Add("gtp_teid", parameterToString(localVarOptionals.GtpTeid.Value(), "multi"))
	}
	if localVarOptionals != nil && localVarOptionals.DlGbrPrbUsageCell.IsSet() {
		localVarQueryParams.Add("dl_gbr_prb_usage_cell", parameterToString(localVarOptionals.DlGbrPrbUsageCell.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.UlGbrPrbUsageCell.IsSet() {
		localVarQueryParams.Add("ul_gbr_prb_usage_cell", parameterToString(localVarOptionals.UlGbrPrbUsageCell.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.DlNongbrPrbUsageCell.IsSet() {
		localVarQueryParams.Add("dl_nongbr_prb_usage_cell", parameterToString(localVarOptionals.DlNongbrPrbUsageCell.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.UlNongbrPrbUsageCell.IsSet() {
		localVarQueryParams.Add("ul_nongbr_prb_usage_cell", parameterToString(localVarOptionals.UlNongbrPrbUsageCell.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.DlTotalPrbUsageCell.IsSet() {
		localVarQueryParams.Add("dl_total_prb_usage_cell", parameterToString(localVarOptionals.DlTotalPrbUsageCell.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.UlTotalPrbUsageCell.IsSet() {
		localVarQueryParams.Add("ul_total_prb_usage_cell", parameterToString(localVarOptionals.UlTotalPrbUsageCell.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.ReceivedDedicatedPreamblesCell.IsSet() {
		localVarQueryParams.Add("received_dedicated_preambles_cell", parameterToString(localVarOptionals.ReceivedDedicatedPreamblesCell.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.ReceivedRandomlySelectedPreamblesLowRangeCell.IsSet() {
		localVarQueryParams.Add("received_randomly_selected_preambles_low_range_cell", parameterToString(localVarOptionals.ReceivedRandomlySelectedPreamblesLowRangeCell.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.ReceivedRandomlySelectedPreamblesHighRangeCell.IsSet() {
		localVarQueryParams.Add("received_randomly_selected_preambles_high_range_cell", parameterToString(localVarOptionals.ReceivedRandomlySelectedPreamblesHighRangeCell.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.NumberOfActiveUeDlGbrCell.IsSet() {
		localVarQueryParams.Add("number_of_active_ue_dl_gbr_cell", parameterToString(localVarOptionals.NumberOfActiveUeDlGbrCell.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.NumberOfActiveUeUlGbrCell.IsSet() {
		localVarQueryParams.Add("number_of_active_ue_ul_gbr_cell", parameterToString(localVarOptionals.NumberOfActiveUeUlGbrCell.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.NumberOfActiveUeDlNongbrCell.IsSet() {
		localVarQueryParams.Add("number_of_active_ue_dl_nongbr_cell", parameterToString(localVarOptionals.NumberOfActiveUeDlNongbrCell.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.NumberOfActiveUeUlNongbrCell.IsSet() {
		localVarQueryParams.Add("number_of_active_ue_ul_nongbr_cell", parameterToString(localVarOptionals.NumberOfActiveUeUlNongbrCell.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.DlGbrPdrCell.IsSet() {
		localVarQueryParams.Add("dl_gbr_pdr_cell", parameterToString(localVarOptionals.DlGbrPdrCell.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.UlGbrPdrCell.IsSet() {
		localVarQueryParams.Add("ul_gbr_pdr_cell", parameterToString(localVarOptionals.UlGbrPdrCell.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.DlNongbrPdrCell.IsSet() {
		localVarQueryParams.Add("dl_nongbr_pdr_cell", parameterToString(localVarOptionals.DlNongbrPdrCell.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.UlNongbrPdrCell.IsSet() {
		localVarQueryParams.Add("ul_nongbr_pdr_cell", parameterToString(localVarOptionals.UlNongbrPdrCell.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.DlGbrDelayUe.IsSet() {
		localVarQueryParams.Add("dl_gbr_delay_ue", parameterToString(localVarOptionals.DlGbrDelayUe.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.UlGbrDelayUe.IsSet() {
		localVarQueryParams.Add("ul_gbr_delay_ue", parameterToString(localVarOptionals.UlGbrDelayUe.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.DlNongbrDelayUe.IsSet() {
		localVarQueryParams.Add("dl_nongbr_delay_ue", parameterToString(localVarOptionals.DlNongbrDelayUe.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.UlNongbrDelayUe.IsSet() {
		localVarQueryParams.Add("ul_nongbr_delay_ue", parameterToString(localVarOptionals.UlNongbrDelayUe.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.DlGbrPdrUe.IsSet() {
		localVarQueryParams.Add("dl_gbr_pdr_ue", parameterToString(localVarOptionals.DlGbrPdrUe.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.UlGbrPdrUe.IsSet() {
		localVarQueryParams.Add("ul_gbr_pdr_ue", parameterToString(localVarOptionals.UlGbrPdrUe.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.DlNongbrPdrUe.IsSet() {
		localVarQueryParams.Add("dl_nongbr_pdr_ue", parameterToString(localVarOptionals.DlNongbrPdrUe.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.UlNongbrPdrUe.IsSet() {
		localVarQueryParams.Add("ul_nongbr_pdr_ue", parameterToString(localVarOptionals.UlNongbrPdrUe.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.DlGbrThroughputUe.IsSet() {
		localVarQueryParams.Add("dl_gbr_throughput_ue", parameterToString(localVarOptionals.DlGbrThroughputUe.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.UlGbrThroughputUe.IsSet() {
		localVarQueryParams.Add("ul_gbr_throughput_ue", parameterToString(localVarOptionals.UlGbrThroughputUe.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.DlNongbrThroughputUe.IsSet() {
		localVarQueryParams.Add("dl_nongbr_throughput_ue", parameterToString(localVarOptionals.DlNongbrThroughputUe.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.UlNongbrThroughputUe.IsSet() {
		localVarQueryParams.Add("ul_nongbr_throughput_ue", parameterToString(localVarOptionals.UlNongbrThroughputUe.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.DlGbrDataVolumeUe.IsSet() {
		localVarQueryParams.Add("dl_gbr_data_volume_ue", parameterToString(localVarOptionals.DlGbrDataVolumeUe.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.UlGbrDataVolumeUe.IsSet() {
		localVarQueryParams.Add("ul_gbr_data_volume_ue", parameterToString(localVarOptionals.UlGbrDataVolumeUe.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.DlNongbrDataVolumeUe.IsSet() {
		localVarQueryParams.Add("dl_nongbr_data_volume_ue", parameterToString(localVarOptionals.DlNongbrDataVolumeUe.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.UlNongbrDataVolumeUe.IsSet() {
		localVarQueryParams.Add("ul_nongbr_data_volume_ue", parameterToString(localVarOptionals.UlNongbrDataVolumeUe.Value(), ""))
	}
	// to determine the Content-Type header
	localVarHttpContentTypes := []string{}

	// set Content-Type header
	localVarHttpContentType := selectHeaderContentType(localVarHttpContentTypes)
	if localVarHttpContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHttpContentType
	}

	// to determine the Accept header
	localVarHttpHeaderAccepts := []string{"application/json", "application/problem+json"}

	// set Accept header
	localVarHttpHeaderAccept := selectHeaderAccept(localVarHttpHeaderAccepts)
	if localVarHttpHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHttpHeaderAccept
	}
	r, err := a.client.prepareRequest(ctx, localVarPath, localVarHttpMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHttpResponse, err := a.client.callAPI(r)
	if err != nil || localVarHttpResponse == nil {
		return localVarReturnValue, localVarHttpResponse, err
	}

	localVarBody, err := ioutil.ReadAll(localVarHttpResponse.Body)
	localVarHttpResponse.Body.Close()
	if err != nil {
		return localVarReturnValue, localVarHttpResponse, err
	}

	if localVarHttpResponse.StatusCode < 300 {
		// If we succeed, return the data, otherwise pass on to decode error.
		err = a.client.decode(&localVarReturnValue, localVarBody, localVarHttpResponse.Header.Get("Content-Type"))
		if err == nil {
			return localVarReturnValue, localVarHttpResponse, err
		}
	}

	if localVarHttpResponse.StatusCode >= 300 {
		newErr := GenericSwaggerError{
			body:  localVarBody,
			error: localVarHttpResponse.Status,
		}

		if localVarHttpResponse.StatusCode == 200 {
			var v L2Meas
			err = a.client.decode(&v, localVarBody, localVarHttpResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHttpResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHttpResponse, newErr
		}

		if localVarHttpResponse.StatusCode == 400 {
			var v ProblemDetails
			err = a.client.decode(&v, localVarBody, localVarHttpResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHttpResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHttpResponse, newErr
		}

		if localVarHttpResponse.StatusCode == 401 {
			var v ProblemDetails
			err = a.client.decode(&v, localVarBody, localVarHttpResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHttpResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHttpResponse, newErr
		}

		if localVarHttpResponse.StatusCode == 403 {
			var v ProblemDetails
			err = a.client.decode(&v, localVarBody, localVarHttpResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHttpResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHttpResponse, newErr
		}

		if localVarHttpResponse.StatusCode == 404 {
			var v ProblemDetails
			err = a.client.decode(&v, localVarBody, localVarHttpResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHttpResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHttpResponse, newErr
		}

		if localVarHttpResponse.StatusCode == 406 {
			var v ProblemDetails
			err = a.client.decode(&v, localVarBody, localVarHttpResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHttpResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHttpResponse, newErr
		}

		if localVarHttpResponse.StatusCode == 414 {
			var v ProblemDetails
			err = a.client.decode(&v, localVarBody, localVarHttpResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHttpResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHttpResponse, newErr
		}

		if localVarHttpResponse.StatusCode == 429 {
			var v ProblemDetails
			err = a.client.decode(&v, localVarBody, localVarHttpResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHttpResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHttpResponse, newErr
		}

		return localVarReturnValue, localVarHttpResponse, newErr
	}

	return localVarReturnValue, localVarHttpResponse, nil
}

/*
UnsupportedApiService Retrieve S1-U bearer information related to specific UE(s)
Queries information about the S1 bearer(s)
 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param optional nil or *S1BearerInfoGETOpts - Optional Parameters:
     * @param "TempUeId" (optional.Interface of []string) -  Comma separated list of temporary identifiers allocated for the specific UE as defined in   ETSI TS 136 413
     * @param "UeIpv4Address" (optional.Interface of []string) -  Comma separated list of IE IPv4 addresses as defined for the type for AssociateId
     * @param "UeIpv6Address" (optional.Interface of []string) -  Comma separated list of IE IPv6 addresses as defined for the type for AssociateId
     * @param "NatedIpAddress" (optional.Interface of []string) -  Comma separated list of IE NATed IP addresses as defined for the type for AssociateId
     * @param "GtpTeid" (optional.Interface of []string) -  Comma separated list of GTP TEID addresses as defined for the type for AssociateId
     * @param "CellId" (optional.Interface of []string) -  Comma separated list of E-UTRAN Cell Identities
     * @param "ErabId" (optional.Interface of []int32) -  Comma separated list of E-RAB identifiers

@return S1BearerInfo
*/

type S1BearerInfoGETOpts struct {
	TempUeId       optional.Interface
	UeIpv4Address  optional.Interface
	UeIpv6Address  optional.Interface
	NatedIpAddress optional.Interface
	GtpTeid        optional.Interface
	CellId         optional.Interface
	ErabId         optional.Interface
}

func (a *UnsupportedApiService) S1BearerInfoGET(ctx context.Context, localVarOptionals *S1BearerInfoGETOpts) (S1BearerInfo, *http.Response, error) {
	var (
		localVarHttpMethod  = strings.ToUpper("Get")
		localVarPostBody    interface{}
		localVarFileName    string
		localVarFileBytes   []byte
		localVarReturnValue S1BearerInfo
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/queries/s1_bearer_info"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if localVarOptionals != nil && localVarOptionals.TempUeId.IsSet() {
		localVarQueryParams.Add("temp_ue_id", parameterToString(localVarOptionals.TempUeId.Value(), "multi"))
	}
	if localVarOptionals != nil && localVarOptionals.UeIpv4Address.IsSet() {
		localVarQueryParams.Add("ue_ipv4_address", parameterToString(localVarOptionals.UeIpv4Address.Value(), "multi"))
	}
	if localVarOptionals != nil && localVarOptionals.UeIpv6Address.IsSet() {
		localVarQueryParams.Add("ue_ipv6_address", parameterToString(localVarOptionals.UeIpv6Address.Value(), "multi"))
	}
	if localVarOptionals != nil && localVarOptionals.NatedIpAddress.IsSet() {
		localVarQueryParams.Add("nated_ip_address", parameterToString(localVarOptionals.NatedIpAddress.Value(), "multi"))
	}
	if localVarOptionals != nil && localVarOptionals.GtpTeid.IsSet() {
		localVarQueryParams.Add("gtp_teid", parameterToString(localVarOptionals.GtpTeid.Value(), "multi"))
	}
	if localVarOptionals != nil && localVarOptionals.CellId.IsSet() {
		localVarQueryParams.Add("cell_id", parameterToString(localVarOptionals.CellId.Value(), "multi"))
	}
	if localVarOptionals != nil && localVarOptionals.ErabId.IsSet() {
		localVarQueryParams.Add("erab_id", parameterToString(localVarOptionals.ErabId.Value(), "multi"))
	}
	// to determine the Content-Type header
	localVarHttpContentTypes := []string{}

	// set Content-Type header
	localVarHttpContentType := selectHeaderContentType(localVarHttpContentTypes)
	if localVarHttpContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHttpContentType
	}

	// to determine the Accept header
	localVarHttpHeaderAccepts := []string{"application/json", "application/problem+json"}

	// set Accept header
	localVarHttpHeaderAccept := selectHeaderAccept(localVarHttpHeaderAccepts)
	if localVarHttpHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHttpHeaderAccept
	}
	r, err := a.client.prepareRequest(ctx, localVarPath, localVarHttpMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHttpResponse, err := a.client.callAPI(r)
	if err != nil || localVarHttpResponse == nil {
		return localVarReturnValue, localVarHttpResponse, err
	}

	localVarBody, err := ioutil.ReadAll(localVarHttpResponse.Body)
	localVarHttpResponse.Body.Close()
	if err != nil {
		return localVarReturnValue, localVarHttpResponse, err
	}

	if localVarHttpResponse.StatusCode < 300 {
		// If we succeed, return the data, otherwise pass on to decode error.
		err = a.client.decode(&localVarReturnValue, localVarBody, localVarHttpResponse.Header.Get("Content-Type"))
		if err == nil {
			return localVarReturnValue, localVarHttpResponse, err
		}
	}

	if localVarHttpResponse.StatusCode >= 300 {
		newErr := GenericSwaggerError{
			body:  localVarBody,
			error: localVarHttpResponse.Status,
		}

		if localVarHttpResponse.StatusCode == 200 {
			var v S1BearerInfo
			err = a.client.decode(&v, localVarBody, localVarHttpResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHttpResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHttpResponse, newErr
		}

		if localVarHttpResponse.StatusCode == 400 {
			var v ProblemDetails
			err = a.client.decode(&v, localVarBody, localVarHttpResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHttpResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHttpResponse, newErr
		}

		if localVarHttpResponse.StatusCode == 401 {
			var v ProblemDetails
			err = a.client.decode(&v, localVarBody, localVarHttpResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHttpResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHttpResponse, newErr
		}

		if localVarHttpResponse.StatusCode == 403 {
			var v ProblemDetails
			err = a.client.decode(&v, localVarBody, localVarHttpResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHttpResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHttpResponse, newErr
		}

		if localVarHttpResponse.StatusCode == 404 {
			var v ProblemDetails
			err = a.client.decode(&v, localVarBody, localVarHttpResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHttpResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHttpResponse, newErr
		}

		if localVarHttpResponse.StatusCode == 406 {
			var v ProblemDetails
			err = a.client.decode(&v, localVarBody, localVarHttpResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHttpResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHttpResponse, newErr
		}

		if localVarHttpResponse.StatusCode == 429 {
			var v ProblemDetails
			err = a.client.decode(&v, localVarBody, localVarHttpResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHttpResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHttpResponse, newErr
		}

		return localVarReturnValue, localVarHttpResponse, newErr
	}

	return localVarReturnValue, localVarHttpResponse, nil
}
