/*
 * Copyright (c) 2020  InterDigital Communications, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the \"License\");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an \"AS IS\" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE Radio Network Information Service REST API
 *
 * Radio Network Information Service is AdvantEDGE's implementation of [ETSI MEC ISG MEC012 RNI API](http://www.etsi.org/deliver/etsi_gs/MEC/001_099/012/02.01.01_60/gs_MEC012v020101p.pdf) <p>[Copyright (c) ETSI 2017](https://forge.etsi.org/etsi-forge-copyright-notice.txt) <p>**Micro-service**<br>[meep-rnis](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-rnis) <p>**Type & Usage**<br>Edge Service used by edge applications that want to get information about radio conditions in the network <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_
 *
 * API version: 2.1.1
 * Contact: AdvantEDGE@InterDigital.com
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */
package server

import (
	"net/http"
)

func Layer2MeasInfoGET(w http.ResponseWriter, r *http.Request) {
	notImplemented(w, r)
}

func PlmnInfoGET(w http.ResponseWriter, r *http.Request) {
	plmnInfoGet(w, r)
}

func RabInfoGET(w http.ResponseWriter, r *http.Request) {
	rabInfoGet(w, r)
}

func S1BearerInfoGET(w http.ResponseWriter, r *http.Request) {
	notImplemented(w, r)
}

func SubscriptionLinkListSubscriptionsGET(w http.ResponseWriter, r *http.Request) {
	subscriptionLinkListSubscriptionsGet(w, r)
}

func SubscriptionsDELETE(w http.ResponseWriter, r *http.Request) {
	subscriptionsDelete(w, r)
}

func SubscriptionsGET(w http.ResponseWriter, r *http.Request) {
	subscriptionsGet(w, r)
}

func SubscriptionsPOST(w http.ResponseWriter, r *http.Request) {
	subscriptionsPost(w, r)
}

func SubscriptionsPUT(w http.ResponseWriter, r *http.Request) {
	subscriptionsPut(w, r)
}
