/*
 * Copyright (c) 2022  The AdvantEDGE Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE Platform Controller REST API
 *
 * This API is the main Platform Controller API for scenario configuration & sandbox management <p>**Micro-service**<br>[meep-pfm-ctrl](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-platform-ctrl) <p>**Type & Usage**<br>Platform main interface used by controller software to configure scenarios and manage sandboxes in the AdvantEDGE platform <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_
 *
 * API version: 1.0.0
 * Contact: AdvantEDGE@InterDigital.com
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */

package server

import (
	"net/http"
)

// CreateScenario - Add new scenario to MEEP store
func CreateScenario(w http.ResponseWriter, r *http.Request) {
	pcCreateScenario(w, r)
}

// DeleteScenario - Delete scenario from MEEP store
func DeleteScenario(w http.ResponseWriter, r *http.Request) {
	pcDeleteScenario(w, r)
}

// DeleteScenarioList - Delete all scenarios in MEEP store
func DeleteScenarioList(w http.ResponseWriter, r *http.Request) {
	pcDeleteScenarioList(w, r)
}

// GetScenario - Retrieve scenario from MEEP store
func GetScenario(w http.ResponseWriter, r *http.Request) {
	pcGetScenario(w, r)
}

// GetScenarioList - Retrieve list of scenarios in MEEP store
func GetScenarioList(w http.ResponseWriter, r *http.Request) {
	pcGetScenarioList(w, r)
}

// SetScenario - Update scenario in MEEP store
func SetScenario(w http.ResponseWriter, r *http.Request) {
	pcSetScenario(w, r)
}
