# Go API client for swagger

GS MEC 046 Sensors Sharing Service APIs described using OpenAPI.

## Overview
This API client was generated by the [swagger-codegen](https://github.com/swagger-api/swagger-codegen) project.  By using the [swagger-spec](https://github.com/swagger-api/swagger-spec) from a remote server, you can easily generate an API client.

- API version: 3.1.1
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.go.GoClientCodegen
For more information, please visit [https://forge.etsi.org/rep/mec/gs046-ss-api](https://forge.etsi.org/rep/mec/gs046-ss-api)

## Installation
Put the package under your project folder and add the following in import:
```golang
import "./swagger"
```

## Documentation for API Endpoints

All URIs are relative to *https://localhost/sandboxname/sens/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ManagementnApi* | [**SensorMgmtPUT**](docs/ManagementnApi.md#sensormgmtput) | **Put** /sensor_management | The PUT method is used to update the value of the characteristics that can be set on a sensor or on a group of sensors
*SensorDataLookupApi* | [**SensorDataLookupGET**](docs/SensorDataLookupApi.md#sensordatalookupget) | **Get** /queries/status_data | The GET method is used to query the last sensor data from specific sensors
*SensorDataSubscriptionApi* | [**SensorDataIndividualSubscriptionGET**](docs/SensorDataSubscriptionApi.md#sensordataindividualsubscriptionget) | **Get** /queries/status_data/{subscriptionId} | The GET method is used to retrieve information about this subscription
*SensorDataSubscriptionApi* | [**SensorDataSubscriptionDELETE**](docs/SensorDataSubscriptionApi.md#sensordatasubscriptiondelete) | **Delete** /queries/status_data/{subscriptionId} | The DELETE method is used to cancel the existing subscription
*SensorDataSubscriptionApi* | [**SensorDataSubscriptionGET**](docs/SensorDataSubscriptionApi.md#sensordatasubscriptionget) | **Get** /subscriptions/sensor_data | The GET method is used to request information about the subscriptions related to sensor data for this requestor
*SensorDataSubscriptionApi* | [**SensorDataSubscriptionPOST**](docs/SensorDataSubscriptionApi.md#sensordatasubscriptionpost) | **Post** /subscriptions/sensor_data | The POST method is used to create a new subscription to sensor status notifications
*SensorDataSubscriptionApi* | [**SensorDataSubscriptionPUT**](docs/SensorDataSubscriptionApi.md#sensordatasubscriptionput) | **Put** /queries/status_data/{subscriptionId} | The PUT method is used to update the existing subscription
*SensorDiscoveryLookupApi* | [**SensorDiscoveryLookupGET**](docs/SensorDiscoveryLookupApi.md#sensordiscoverylookupget) | **Get** /queries/sensor_discovery | The GET method is used to query the available sensors
*SensorDiscoverySubscriptionApi* | [**SensorDiscoveryIndividualSubscriptionGET**](docs/SensorDiscoverySubscriptionApi.md#sensordiscoveryindividualsubscriptionget) | **Get** /subscriptions/sensor_discovery/{subscriptionId} | The GET method is used to request information about the subscriptions related to sensor status for this requestor
*SensorDiscoverySubscriptionApi* | [**SensorDiscoverySubscriptionDELETE**](docs/SensorDiscoverySubscriptionApi.md#sensordiscoverysubscriptiondelete) | **Delete** /subscriptions/sensor_discovery/{subscriptionId} | The DELETE method is used to cancel the existing subscription. Cancellation can be made by deleting the resource that represents existing sensor discovery subscription
*SensorDiscoverySubscriptionApi* | [**SensorDiscoverySubscriptionGET**](docs/SensorDiscoverySubscriptionApi.md#sensordiscoverysubscriptionget) | **Get** /subscriptions/sensor_discovery | The GET method is used to request information about the subscriptions related to sensor discovery for this requestor
*SensorDiscoverySubscriptionApi* | [**SensorDiscoverySubscriptionPOST**](docs/SensorDiscoverySubscriptionApi.md#sensordiscoverysubscriptionpost) | **Post** /subscriptions/sensor_discovery | The POST method is used to create a new subscription to sensor discovery notifications
*SensorDiscoverySubscriptionApi* | [**SensorDiscoverySubscriptionPUT**](docs/SensorDiscoverySubscriptionApi.md#sensordiscoverysubscriptionput) | **Put** /subscriptions/sensor_discovery/{subscriptionId} | The POST method is used to create a new subscription to sensor discovery notifications
*SensorManagementApi* | [**SensorMgmtGET**](docs/SensorManagementApi.md#sensormgmtget) | **Get** /sensor_management | The GET method is used to receive the sensor characteristics that can be modified on specific sensors
*SensorStatusLookupApi* | [**SensorStatusLookupGET**](docs/SensorStatusLookupApi.md#sensorstatuslookupget) | **Get** /queries/sensor_status | The GET method is used to query the available status
*SensorStatusSubscriptionApi* | [**SensorStatusIndividualSubscriptionGET**](docs/SensorStatusSubscriptionApi.md#sensorsatusindividualsubscriptionget) | **Get** /subscriptions/sensor_status/{subscriptionId} | The GET method is used to retrieve information about this subscription
*SensorStatusSubscriptionApi* | [**SensorStatusIndividualSubscriptionGET**](docs/SensorStatusSubscriptionApi.md#sensorstatusindividualsubscriptionget) | **Get** /subscriptions/sensor_status | The GET method is used to request information about the subscriptions related to sensor status for this requestor
*SensorStatusSubscriptionApi* | [**SensorStatusSubscriptionDELETE**](docs/SensorStatusSubscriptionApi.md#sensorstatussubscriptiondelete) | **Delete** /subscriptions/sensor_status/{subscriptionId} | The DELETE method is used to cancel the existing subscription
*SensorStatusSubscriptionApi* | [**SensorStatusSubscriptionPUT**](docs/SensorStatusSubscriptionApi.md#sensorstatussubscriptionput) | **Put** /subscriptions/sensor_status/{subscriptionId} | The PUT method is used to update the existing subscription
*StatusStatusSubscriptionApi* | [**SensorStatusSubscriptionPOST**](docs/StatusStatusSubscriptionApi.md#sensorstatussubscriptionpost) | **Post** /subscriptions/sensor_status | The POST method is used to create a new subscription to sensor status notifications

## Documentation For Models

 - [AreaInfo](docs/AreaInfo.md)
 - [LinkType](docs/LinkType.md)
 - [Point](docs/Point.md)
 - [ProblemDetails](docs/ProblemDetails.md)
 - [SensorCharacteristic](docs/SensorCharacteristic.md)
 - [SensorData](docs/SensorData.md)
 - [SensorDataSubscription](docs/SensorDataSubscription.md)
 - [SensorDiscoveryEventSubscription](docs/SensorDiscoveryEventSubscription.md)
 - [SensorDiscoveryInfo](docs/SensorDiscoveryInfo.md)
 - [SensorDiscoverySubscriptionIdBody](docs/SensorDiscoverySubscriptionIdBody.md)
 - [SensorInfo](docs/SensorInfo.md)
 - [SensorStatusInfo](docs/SensorStatusInfo.md)
 - [SensorStatusSubscription](docs/SensorStatusSubscription.md)
 - [SensorStatusSubscriptionIdBody](docs/SensorStatusSubscriptionIdBody.md)
 - [ShapeType](docs/ShapeType.md)
 - [SensorDataSubscriptionIdBody](docs/SensorDataSubscriptionIdBody.md)
 - [SubscriptionLinkList](docs/SubscriptionLinkList.md)
 - [SubscriptionLinkListLinks](docs/SubscriptionLinkListLinks.md)
 - [SubscriptionLinkListSubscription](docs/SubscriptionLinkListSubscription.md)
 - [SubscriptionLinks](docs/SubscriptionLinks.md)
 - [SubscriptionType](docs/SubscriptionType.md)
 - [SubscriptionsSensorDataBody](docs/SubscriptionsSensorDataBody.md)
 - [SubscriptionsSensorDiscoveryBody](docs/SubscriptionsSensorDiscoveryBody.md)
 - [SubscriptionsSensorStatusBody](docs/SubscriptionsSensorStatusBody.md)
 - [TimeStamp](docs/TimeStamp.md)
 - [WebsockNotifConfig](docs/WebsockNotifConfig.md)

## Documentation For Authorization
 Endpoints do not require authorization.


## Author

cti_support@etsi.org
