/*
 * MEC Service Management API
 *
 * The ETSI MEC ISG MEC011 MEC Service Management API described using OpenAPI
 *
 * API version: 3.1.1
 * Contact: cti_support@etsi.org
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */
package client

// This type represents the general information of a MEC service.
type ServiceInfo struct {
	// Identifier of the service instance assigned by the MEC platform.
	SerInstanceId string `json:"serInstanceId,omitempty"`
	// The name of the service. This is how the service producing MEC application identifies the service instance it produces.
	SerName string `json:"serName"`
	SerCategory *CategoryRef `json:"serCategory,omitempty"`
	// Service version
	Version string `json:"version"`
	State *ServiceState `json:"state"`
	// Identifier of the platform-provided transport to be used by the service.  Valid identifiers may be obtained using the \"Transport information query\"  procedure. May be present in POST requests to signal the use of a platform-provided  transport for the service, and shall be absent otherwise. See note 2.
	TransportId string `json:"transportId,omitempty"`
	TransportInfo *TransportInfo `json:"transportInfo"`
	Serializer *SerializerType `json:"serializer"`
	ScopeOfLocality *LocalityType `json:"scopeOfLocality,omitempty"`
	// Indicate whether the service can only be consumed by the MEC applications located in the same locality (as defined by scopeOfLocality) as this  service instance.
	ConsumedLocalOnly bool `json:"consumedLocalOnly,omitempty"`
	// Indicate whether the service is located in the same locality (as defined by scopeOfLocality) as the consuming MEC application.
	IsLocal bool `json:"isLocal,omitempty"`
	// Interval (in seconds) between two consecutive \"heartbeat\" messages (see clause 8.2.10.3.3). If the service-producing application supports sending \"heartbeat\" messages, it shall include this attribute in the registration request. In this case, the application shall either set the value of this attribute to zero or shall use this attribute to propose a non-zero positive value for the liveness interval. If the application has provided this attribute in the request and the MEC platform requires \"heartbeat\" messages, the MEC platform shall return this attribute value in the HTTP responses. The MEC platform may use the value proposed in the request or may choose a different value. If the MEC platform does not require \"heartbeat\" messages for this service instance it shall omit the attribute in responses.
	LivenessInterval int32 `json:"livenessInterval,omitempty"`
	Links *ServiceInfoLinks `json:"_links,omitempty"`
}
