/*
 * Copyright (c) 2022  InterDigital Communications, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the \"License\");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an \"AS IS\" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE Multi-access Traffic Steering API
 *
 * Multi-access Traffic Steering Sercice is AdvantEDGE's implementation of [ETSI MEC ISG MEC015 Traffic Management APIs](https://www.etsi.org/deliver/etsi_gs/MEC/001_099/015/02.02.01_60/gs_MEC015v020201p.pdf) <p>[Copyright (c) ETSI 2017](https://forge.etsi.org/etsi-forge-copyright-notice.txt) <p>**Micro-service**<br>[meep-tm](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-tm/server/mts) <p>**Type & Usage**<br>Edge Service used by edge applications that want to get information about MTS Info and Session(s) in the network <p>**Note**<br>AdvantEDGE supports all Multi-access Traffic Steering API endpoints.
 *
 * API version: 2.2.1
 * Contact: AdvantEDGE@InterDigital.com
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */
package server

// QoS requirement description of the MTS session, applicable only if mtsMode = 4 (QoS). If the qosD field is included, at least one of its subfields shall be included. Any qosD subfield that is not included shall be ignored in Multi-access Traffic Steering (MTS)
type MtsSessionInfoQosD struct {
	// tolerable jitter in [10 nanoseconds]
	MaxJitter uint32 `json:"maxJitter,omitempty"`
	// tolerable (one-way) delay in [10 nanoseconds]
	MaxLatency uint32 `json:"maxLatency,omitempty"`
	// tolerable packet loss rate in [1/10^x]
	MaxLoss uint32 `json:"maxLoss,omitempty"`
	// minimal throughput in [kbps]
	MinTpt uint32 `json:"minTpt,omitempty"`
	// numeric value (0 - 255) corresponding to the traffic priority 0: low; 1: medium; 2: high; 3: critical
	Priority uint32 `json:"priority,omitempty"`
}
