/*
 * Copyright (c) 2020 ETSI.  All rights reserved.
 */

import React, { Component } from 'react';
import BasicDialog from './basic-dialog';
import { Typography } from '@rmwc/typography';
import {
  WIKI_HELP_URL,
  WIKI_DISCUSSION_BOARD_URL
} from '../../app-constants';

class NewsDialog extends Component {
  constructor(props) {
    super(props);
  }

  render() {
    return (
      <BasicDialog
        title={this.props.title}
        open={this.props.open}
        onSubmit={this.props.onClose}
        onClose={this.props.onClose}
        submitLabel = {'Ok'}
      >
        <div style={styles.text}>
          <Typography theme="primary" use="body1">
            <p><b>October 2021</b></p>
          </Typography>
          <Typography use="body1">
            The following APIs are supported as Beta features:
            <ul>
              <li>MEC011 - Edge Platform Application Enablement (v2.1.1)</li>
              <li>MEC021 - Application Mobility Service API (v2.1.1)</li>
            </ul>
            <p>
              Usage details are available in the <a href={WIKI_HELP_URL} target="_blank">MEC Sandbox Wiki</a><br/>
              Questions & feedback are appreciated on the <a href={WIKI_DISCUSSION_BOARD_URL} target="_blank">Slack Discussion Board</a>
            </p>
            <p>
              Thank you in advance for your collaboration in trying out these new features.
            </p>
            <p style={styles.signature}>
              The MEC Sandbox Team
            </p>
          </Typography>
        </div>

      </BasicDialog>
    );
  }
}

const styles = {
  text: {
    // color: 'black',
    marginLeft: 10,
    marginRight: 15
  },
  signature: {
    textAlign: 'right'
  }
};

export default NewsDialog;
