/*
 * Copyright (c) 2020 ETSI.  All rights reserved.
 */

import { connect } from 'react-redux';
import React, { Component } from 'react';
import { Typography } from '@rmwc/typography';

import {
  PAGE_SANDBOX,
  HOST_PATH
} from '../../app-constants';

import {
} from '../../state/ui';

class TryIt extends Component {
  constructor(props) {
    super(props);
    this.baseTryIt = HOST_PATH + '/' + this.props.sandboxName + '/';
  }

  render() {

    if (this.props.page !== PAGE_SANDBOX) {
      return null;
    }

    let mecApiPath = '';
    let mecSwaggerApiUrl = '';

    switch(this.props.mecApi) {
    case this.props.mecApis[0]:
      mecApiPath = this.props.mecApisPath[0];
      mecSwaggerApiUrl = this.props.mecSwaggerApisUrl[0];
      break;
    case this.props.mecApis[1]:
      mecApiPath = this.props.mecApisPath[1];
      mecSwaggerApiUrl = this.props.mecSwaggerApisUrl[1];
      break;
    case this.props.mecApis[2]:
      mecApiPath = this.props.mecApisPath[2];
      mecSwaggerApiUrl = this.props.mecSwaggerApisUrl[2];
      break;
    default:
      //no update to mepApiPath if no selection made
      mecSwaggerApiUrl = 'api/';
      break;
    }

    let tryItMecApp = this.baseTryIt + mecApiPath;
    let tryItBrowser = this.baseTryIt + mecSwaggerApiUrl;

    return (
      <>
        <div title="Open a browser client to exercise selected MEC API">
          <Typography theme="primary" use="headline6">Try-it in the browser</Typography>
          <Typography className="text-color-main" use="body1">
            <p>
              Click <b><a href={tryItBrowser} target="_blank">here</a></b> to start a MEC client in the browser.
            </p>
            <p>
              The client allows to send HTTP requests to MEC Service APIs in your MEC Sandbox.
            </p>
          </Typography>
        </div>

        <div style={{ width: '100%', borderTop: '2px solid #e4e4e4', marginTop: 20, marginBottom: 20 }}/>

        <div title="Use URL in your client to exercise selected MEC API">
          <Typography theme="primary" use="headline6">Try-it from your MEC application</Typography>
          <Typography className="text-color-main" use="body1">
            <p>
              Use the following base path in your MEC application to interact directly with the MEC Service API in your MEC Sandbox.
            </p>
          </Typography>
          <Typography theme="primary" use="body1">
            <p><b>{tryItMecApp}</b></p>
          </Typography>
        </div>
      </>
    );
  }
}

const mapStateToProps = state => {
  return {
    page: state.ui.page,
    sandboxName: state.ui.sandboxName
  };
};

const ConnectedTryIt = connect(
  mapStateToProps
)(TryIt);

export default ConnectedTryIt;
