/*
 * Copyright (c) 2020 ETSI.  All rights reserved.
 */

import { combineReducers } from 'redux';

import { scenarioReducer } from './scenario-reducer';
import { mapReducer } from './map-reducer';
import { tableReducer } from './table-reducer';
import { apiTableReducer } from './api-table-reducer';

export * from './scenario-reducer';
export * from './map-reducer';
export * from './table-reducer';
export * from './api-table-reducer';

const sboxReducer = combineReducers({
  scenario: scenarioReducer,
  map: mapReducer,
  table: tableReducer,
  apiTable: apiTableReducer
});

export default sboxReducer;
