/*
 * Copyright (c) 2020 ETSI.  All rights reserved.
 */

import { connect } from 'react-redux';
import React, { Component } from 'react';
import { Select } from '@rmwc/select';
import TryIt from './try-it';
import ApiTable from './api-table';
import { Typography } from '@rmwc/typography';

import {
  PAGE_SANDBOX
} from '../../app-constants';

import {
  uiSandboxChangeMecApiSelected
} from '../../state/ui';

class ApiPane extends Component {
  constructor(props) {
    super(props);
    this.mecApis = ['Location (013)', 'Radio Network Information (012)', 'WLAN Access Information (028)'];
    this.mecSwaggerApisUrl = [
      'api/?urls.primaryName=Location%20Service%20REST%20API',
      'api/?urls.primaryName=Radio%20Network%20Information%20Service%20REST%20API',
      'api/?urls.primaryName=WLAN%20Access%20Information%20Service%20REST%20API'
    ];
    this.mecApisPath = ['location/v2', 'rni/v2', 'wai/v2'];
    this.data = null;
  }

  render() {
    if (this.props.page !== PAGE_SANDBOX) {
      return null;
    }

    return (
      <div>
        <div style={styles.title} title="Observe and interact with MEC APIs">
          <Typography theme="primary" use="headline6">API Console</Typography>
        </div>
        <div style={{ display: 'flex', height: '100%', marginBottom: 5 }}>
          <div style={{ flex: '1', marginRight: 5, padding: 10 }}>
            <ApiTable
              data={this.props.tableData}
            />
          </div>
          <div
            className="component-style"
            style={{ flex: '0 0 450px' }}
          >
            <div style={styles.section}>
              <Select
                title="Select the MEC API"
                style={styles.select}
                fullwidth="true"
                outlined
                label="MEC API"
                options={this.mecApis}
                onChange={event => {
                  this.props.changeMecApiSelected(event.target.value);
                }}
                value={this.props.mecApiSelected}
              />
            </div>
            <div style={styles.section}>
              <TryIt
                page={this.props.page}
                mecApi={this.props.mecApiSelected}
                mecApis={this.mecApis}
                mecApisPath={this.mecApisPath}
                mecSwaggerApisUrl={this.mecSwaggerApisUrl}
              />
            </div>
          </div>
        </div>
      </div>
    );
  }
}

const styles = {
  title: {
    paddingLeft: 15,
    paddingTop: 15
  },
  section: {
    padding: 15
  },
  select: {
    width: '100%',
    color: '#2f00ff'
  }
};

const mapStateToProps = state => {
  return {
    page: state.ui.page,
    sandboxName: state.ui.sandboxName,
    mecApiSelected: state.ui.mecApiSelected,
    networkFileSelected: state.ui.networkFileSelected,
    tableData: state.ui.tableData,
    detailedData: state.ui.detailedData
  };
};

const mapDispatchToProps = dispatch => {
  return {
    changeMecApiSelected: name => dispatch(uiSandboxChangeMecApiSelected(name))
  };
};

const ConnectedApiPane = connect(
  mapStateToProps,
  mapDispatchToProps
)(ApiPane);

export default ConnectedApiPane;
