#!/bin/sh

# Get full path to script directory
SCRIPT=$(readlink -f "$0")
BASEDIR=$(dirname "$SCRIPT")

MEEPDIR=~/AdvantEDGE
CONFIGDIR=$MEEPDIR/config
DASHBOARDDIR=$MEEPDIR/charts/grafana/dashboards
FRONTENDDIR=~/.meep/user/frontend
SWAGGERDIR=~/.meep/user/sandbox-swagger
VALUESDIR=~/.meep/user/values

echo ""
echo ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
echo ">> Deploying MEC Sandbox Frontend"
echo ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
echo ""

echo "+ Updating AdvantEDGE configuration"
echo "$MEEPDIR"
echo "$CONFIGDIR"
cd $BASEDIR
cp config/.meepctl-repocfg.yaml $MEEPDIR
cp config/permissions.yaml $CONFIGDIR
cp config/secrets.yaml $CONFIGDIR

echo ""
echo "+ Copying dashboards"
echo "$DASHBOARDDIR"
cp -r config/dashboards/* $DASHBOARDDIR

echo ""
echo "+ Deploying frontend"
echo "$FRONTENDDIR"
mkdir -p $FRONTENDDIR
rm -r $FRONTENDDIR/* 2> /dev/null
cp -r bin/frontend/* $FRONTENDDIR

echo ""
echo "+ Deploying swagger UI"
echo "$SWAGGERDIR"
mkdir -p $SWAGGERDIR
rm -r $SWAGGERDIR/* 2> /dev/null
cp -r js-apps/swagger-ui/* $SWAGGERDIR

# echo ""
# echo "+ Updating configuration user values"
# echo "$VALUESDIR"
# mkdir -p $VALUESDIR
# rm -r $VALUESDIR-bak 2> /dev/null
# mkdir -p $VALUESDIR-bak
# cp -r  $VALUESDIR/* $VALUESDIR-bak
# cp -r config/values/* $VALUESDIR

echo ""
echo ">>> MEC Sandbox deployment completed"
