#!/bin/sh

# Get full path to script directory
SCRIPT=$(readlink -f "$0")
BASEDIR=$(dirname "$SCRIPT")

MEEPDIR=~/AdvantEDGE

install_package() {
    echo ""
    echo "+ Installing $1"
    rm -rf $BASEDIR/js-packages/$1
    mkdir -p $BASEDIR/js-packages/$1
    cp -r $MEEPDIR/js-packages/$1 $BASEDIR/js-packages
    cd $BASEDIR/js-packages/$1
    npm ci
}

echo ""
echo ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
echo ">> Building MEC Sandbox Frontend"
echo ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
echo ""
cd $BASEDIR
rm -r bin/
mkdir -p bin/frontend

echo "+ Linting Frontend"
cd $BASEDIR/js-apps/frontend
eslint src

echo ""
echo "+ Installing client packages"
install_package meep-gis-engine-client
install_package meep-metrics-engine-client
install_package meep-platform-ctrl-client
install_package meep-sandbox-ctrl-client
install_package meep-mon-engine-client

echo ""
echo "+ Building Frontend"
cd $BASEDIR/js-apps/frontend
npm ci
rm -r dist
npm run build -- --output-path=$BASEDIR/bin/frontend

echo ""
echo ">>> MEC Sandbox build completed"
