# ETSI MEC Sandbox Frontend

>_NOTE: This repository contains the MEC Sandbox Frontend; the backend portion of the MEC Sandbox is realized using the open source project [AdvantEDGE](https://github.com/InterDigitalInc/AdvantEDGE)_

MEC Sandbox is an interactive environment that enables users to learn & experiment with ETSI MEC Service APIs.
These standardised RESTful APIs are targeted towards MEC application developers to expose the value added services
offered by MEC, including real time access to network and context information, as well as location awareness.
The design principles for developing the APIs have also been specified in ETSI GS MEC 009, along with http methods,
templates, conventions and patterns. The MEC service APIs are available in YAML and JSON format at https://forge.etsi.org,
presented via OpenAPI compliant descriptions.

MEC Sandbox provides the user with a choice of scenarios combining different network technologies (4G, 5G, Wi-Fi) and
terminal types. Combining these assets in a geolocated environment, a user can gain hands-on experience on the behaviour
and capabilities of the Location (MEC013), Radio Network Information (MEC012) and WLAN Information (MEC028) service APIs.
Such contextual information can offer significant differential performance for edge based MEC applications.

MEC Sandbox deploys the [AdvantEDGE edge emulation platform](https://github.com/InterDigitalInc/AdvantEDGE) to provide
real-time access to ETSI MEC service implementations.

The MEC Sandbox frontend (provided in this repo) uses the AdvantEDGE platform & service REST APIs to create secure,
user-specific sandboxes where signed-in users can:
- Deploy & dynamically configure a scenario
- Try-out the MEC Service APIs using Swagger UI
- Interact with the MEC Services directly from a user MEC Application

## Getting Started
To use the MEC Sandbox, check out the [live deployment](https://try-mec.etsi.org).

To learn more about the MEC Sandbox, have a look at the [wiki page](https://mecwiki.etsi.org/index.php?title=MEC_Sandbox_Help).

To install the MEC Sandbox, follow the installation instructions below.

## Install MEC Sandbox

### Prerequisites
MEC Sandbox has the following prerequisites:

1. [AdvantEDGE](https://github.com/InterDigitalInc/AdvantEDGE/wiki) runtime & development environments
   - Install [runtime environment](https://github.com/InterDigitalInc/AdvantEDGE/wiki/runtime-environment)
   - Install [development environment](https://github.com/InterDigitalInc/AdvantEDGE/wiki/development-environment)
1. OAuth Applications using external providers
   - **GitHub:**
     - github.com User Account --> Settings --> Developer settings --> OAuth Apps --> New OAuth App
     - _Application Name:_ ETSI MEC Sandbox
     - _Homepage URL:_ https://try-mec.etsi.org
     - _Application description:_ Optional description...
     - _Authorization callback URL:_ https://try-mec.etsi.org/platform-ctrl/v1/authorize
     - **NOTES:**
       - You can also add an application logo if you want users to see one during authentication
       - Once created, keep note of the OAuth App Client ID & Secret; this secret is only temporarily available on GitHub... keep a copy in a safe place!
       - If you need to generate a new secret the MEC Sandbox will have to be updated accordingly
   - **GitLab:**
     - gitlab.com User Account --> Settings --> Applications --> Add new application
     - _Name:_ ETSI MEC Sandbox
     - _Redirect URI:_ https://try-mec.etsi.org/platform-ctrl/v1/authorize
     - _Confidential:_ Unchecked
     - _Scopes:_ read_user
     - **NOTES:**
       - Once created, keep note of the OAuth App Client ID & Secret

### Build & Deploy
Build and deploy the MEC Sandbox as follows:

1. Stop AdvantEDGE (if running)
   - Delete user sandboxes
     - Using AdvantEDGE frontend:
       - Login as admin @ https://try-mec.etsi.org
       - Open AdvantEDGE frontend @ https://try-mec.etsi.org/alt
       - Go to Exec Page and delete user sandboxes
     - Manually:
       - `helm ls -A --short | grep <sandbox-name> | xargs -L1 helm delete`
   - Delete core & dependency microservices:
     - `meepctl delete core`
     - `meepctl delete dep`
     - **NOTE:** This will clear all sessions in Redis DB
1. Clone MEC Sandbox & AdvantEDGE repositories:
   - Fetch required MEC Sandbox baseline:
     - Clone this repo to the MEC Sandbox deployment VM
     - Place repo in home folder
   - Fetch required AdvantEDGE baseline:
     - Clone AdvantEDGE repo to the MEC Sandbox deployment VM
     - Place repo in home folder
     - Checkout the required AdvantEDGE version tag
1. Build & Deploy STF Frontend:
   - SSH to MEC Sandbox deployment VM
   - Build STF Frontend:
     - `cd ~/mec-sandbox`
     - `./build.sh`
   - Deploy STF Frontend & Configuration files:
     - `./deploy.sh`
     - **NOTE:** This updates the `~/.meep/user/` folder with the user frontend, sandbox swagger UI, and user chart values.yaml overrides
1. Configure AdvantEDGE:
   - Update deployment config & permissions files (from MEC Sandbox):
     - `cp ~/mec-sandbox/config/.meepctl-repocfg.yaml ~/AdvantEDGE/.meepctl-repocfg.yaml`
       - **NOTE:** Verify the Deployment config section values before deploying the platform
     - `cp ~/mec-sandbox/config/permissions.yaml ~/AdvantEDGE/config/permissions.yaml`
   - Configure session & OAuth secrets:
     - `vi ~/AdvantEDGE/config/secrets.yaml`
       - Set a unique session encryption key
       - Set the OAuth provider client ID & secrets using the values from the OAuth Applications
     - `python ~/AdvantEDGE/config/configure-secrets.py set ~/AdvantEDGE/config/secrets.yaml`
       - To install Python2: `sudo apt install python-minimal`
       - To install Python-pip: `sudo apt install python-pip`
       - **NOTE:** Once the kuberentes secrets have been created, it is recommended to remove the `~/AdvantEDGE/config/secrets.yaml` file containing the clear-text secrets
1. Build & Deploy AdvantEDGE:
   - Build meepctl:
     - `~/AdvantEDGE/go-apps/meepctl/install.sh`
   - Deploy dependency pods:
     - `meepctl deploy dep`
   - Build & Dockerize:
     - `meepctl build all`
     - `meepctl dockerize all`
   - Prune old docker images:
     - `docker image prune`
   - Deploy Core pods:
     - `meepctl deploy core`
     - **NOTE:** Wait for dep pods to be successfully deployed before deploying core

### Configure Scenarios
If necessary, configure the MEC Sandbox scenarios as follows:

1. Provide _admin_ privileges to a user account
   - SSH to MEC Sandbox machine
   - SSH into _meep-postgis-0_ pod
   - Login & connect to PostgreSQL user role database:
     - `psql -U postgres`
     - `\c meep_platform_ctrl`
   - Add entry to give _admin_ rights to a specific username from a specific provider. Examples:
     - `INSERT INTO users (provider, username, password, sboxname, role) VALUES ('github', 'user1', '', 'sbx-user1','admin');`
     - `INSERT INTO users (provider, username, password, sboxname, role) VALUES ('gitlab', 'user2', '', 'sbx-user2','admin');`
   - List configured user roles to verify proper configuration:
     - `SELECT * from users;`
1. Sign in to MEC Sandbox using an account with _admin_ privileges
   - Login as admin user @ https://try-mec.etsi.org
1. Open the AdvantEDGE frontend
   - Open AdvantEDGE frontend @ https://try-mec.etsi.org/alt
1. Import & save MEC Sandbox scenarios
   - In the AdvantEDGE Configuration view, import the required scenario _yaml_ file
   - Save the imported scenario to the AdvantEDGE backend to make it available in the MEC Sandbox

## Licensing
MEC Sandbox is a private repo with all rights reserved to ETSI.
```
Copyright (c) 2020 ETSI.  All rights reserved.
```
