#!/bin/sh

# Get full path to script directory
SCRIPT=$(readlink -f "$0")
BASEDIR=$(dirname "$SCRIPT")

MEEPDIR=~/AdvantEDGE
CONFIGDIR=$MEEPDIR/config
DASHBOARDDIR=$MEEPDIR/charts/grafana/dashboards
APIDIR=$MEEPDIR/config/api
GRIDDIR=$MEEPDIR/go-packages/meep-vis-traffic-mgr
FRONTENDDIR=~/.meep/user/frontend
VALUESDIR=~/.meep/user/values

echo ""
echo ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
echo ">> Deploying MEC Sandbox Frontend"
echo ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
echo ""

echo "+ Updating AdvantEDGE configuration"
echo "$MEEPDIR"
echo "$CONFIGDIR"
cd $BASEDIR
cp config/.meepctl-repocfg.yaml $MEEPDIR
cp config/permissions.yaml $CONFIGDIR
cp config/secrets.yaml $CONFIGDIR
cp config/objstore-influx.cfg $CONFIGDIR
cp config/objstore-thanos.yaml $CONFIGDIR
cp config/objstore-thanos-archive.yaml $CONFIGDIR

echo ""
echo "+ Copying swagger api files"
echo "$APIDIR"
mkdir -p $APIDIR
cp -r config/api/* $APIDIR

echo ""
echo "+ Copying dashboards"
echo "$DASHBOARDDIR"
mkdir -p $DASHBOARDDIR
cp -r config/dashboards/* $DASHBOARDDIR

echo ""
echo "+ Copying grid map file"
echo "$GRIDDIR"
mkdir -p $GRIDDIR
cp -r config/grid_map/* $GRIDDIR

echo ""
echo "+ Deploying frontend"
echo "$FRONTENDDIR"
mkdir -p $FRONTENDDIR
rm -r $FRONTENDDIR/* 2> /dev/null
cp -r bin/frontend/* $FRONTENDDIR

echo ""
echo "+ Updating configuration user values"
echo "$VALUESDIR"
mkdir -p $VALUESDIR
rm -r $VALUESDIR-bak 2> /dev/null
mkdir -p $VALUESDIR-bak
cp -r  $VALUESDIR/* $VALUESDIR-bak
cp -r config/values/* $VALUESDIR

echo ""
echo ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
echo ">> Updating demo4-UE entrypoint.sh script"
echo ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
echo ""

sed --in-place 's/advantedge/sandbox/' $MEEPDIR/examples/demo4-ue/src/demo-server/entrypoint.sh

echo ""
echo ">>> MEC Sandbox deployment completed"
