This repository contains the source code of the ETSI oneM2M Advanced Semantic Discovery protocol simulator developed in OMNeT++ with the goal of providing a *proof of concept* and a *performance evaluation* of the powerful resource discovery that will be included in the release 4 of oneM2M standard
(see https://member.onem2m.org/Application/documentapp/downloadLatestRevision/default.aspx?docID=34123).

This work has been conducted in the STF 589 (see https://portal.etsi.org/STF/STFs/STF-HomePages/STF589) of SmartM2M/oneM2M: Task 3: oneM2M Discovery and Query solution(s) simulation and performance evaluation.

Documentation about the underlying concepts of the simulator can be found in the STF 589 - Final Draft of TR 103 716 
(https://www.etsi.org/deliver/etsi_tr/103700_103799/103716/01.01.01_60/tr_103716v010101p.pdf)

Version History:

**ASDQ version 4.0.0**
- Capability to describe different network topology with respect to the previous version: AsdqNetwork.ned and AsdqNetworkSub.ned with separated *.ini* files;
- Capability to run simulation on a Cluster platform;
- Reduced number of notification messages which were flooding the network in previous release;
- Optimised *.cpp* source code for modules to run smoothly;
- Modified *.cpp* and *.ned* and *.ini* files to run without graphical user interface (GUI); 
- New notification method for AEs in order to be registered in CSEs;
- New registration method in advanced routing tables embedded in each CSE; 
- Modified method for semantic discovery and query based on four multicast parameters related to the Semantic Discovery Agreements (SDA) between CSEs (CustomerToProvider, ProviderToCustomer, PeerToPeer, SiblingToSibling), those latter agreement strongly inspired to the BGP Internet protocol.

**Here is the installation procedure and how to run the simulation:** 

1-Download and Install OMNeT++
- Open https://omnetpp.org;
- Download the installation files for Linux/Win/Mac;
- Extract the files;
- Inside the *doc* folder open the InstallGuide.pdf file and follow the instructions. 

2-Download the simulation source codes.
- Open ETSI Labs website;
- Go to the IoT > SmartM2M-Semantic and Query > OMNET-ASD-Network-Simulation > Repository;
- And download the desired version and source codes.

2-Start the OMNeT++ platform and follow the steps below.
- Create an OMNeT++ project.
- Choose "Empty project with src and simulations folders";
- Delete a package.ned file that has been generated in the project;
- In the src folder -> "Import code file system by selecting the local src folder that contains the gitlab code. 

3-Build your project.
- Click right on the package -> Build Project.

4-Run a simulation.
- Choose the desired *.ini* file as configuration file; 
- Run the simulation.
- You can run the simulation either with or without OMNeT++ GUI;
- For more information refer to the OMNeT++ SimulationManual.pdf inside the doc folder located in *omnetpp* folder. 

**How to run OMNeT++ on a Cluster environment and How to compile the project:**

- Download the OMNeT++ installation source file;
- Without extracting the file, upload it on the target Cluster;
- Extract the file on cluster based on the which OS your cluster is using;
- Configure OMNeT++ on cluster by following the steps in installation guide file;
- Compile the simulation by *make* command;
- Run the simulation in command line mode by uploading and passing the compiled file on cluster to the OMNeT++;
- Every Cluster has its own commands for passing the job to the nodes on cluster, so follow the target cluster user manual.

Enjoy! 

Luigi Liquori and Behrad Shirmard
INRIA Sophia Antipolis-Méditerranée and Université Côte d'Azur.
Contact: Luigi.Liquori@inria.fr and b.shirmard@gmail.com


 
