#ifndef AE_H_
#define AE_H_

#include <stdio.h>
#include <string.h>
#include <omnetpp.h>
#include "AEMessage_m.h"
#include "utils.h"

using namespace omnetpp;
//using namespace std;

enum InitStage {
    INIT_REGISTRATION = 0,
    INIT_QUERY = 1
};

class AE : public cSimpleModule  // one of the module type in omnet
{
  protected:
    // by default in omnet methods
      virtual void initialize(int stage) override;
      virtual void handleMessage(cMessage *msg) override;
    // application specific
      void sendAEMessage(int op_code);

      void registration();
      void sendQuery();

      virtual int numInitStages() const;

  private:
      int warmup;
      int queryIndex;
      int URI;
      int data;
      int maxHop;
      int ran_number;
      std::string feature_type;
      std::vector<std::string> feature_types {
          "thermometer","airStation","ATM","smartLock", "waterValve"
      };

      int resource_pool_size;


      int number_of_replies;
      int number_of_successfulResponse;
protected:
      simsignal_t successRate;

};
Define_Module(AE);





#endif /* AE_H_ */
