#ifndef AE_H_
#define AE_H_

#include <stdio.h>
#include <string.h>
#include <omnetpp.h>
#include "AEMessage_m.h"
#include "utils.h"

using namespace omnetpp;
//using namespace std;

enum InitStage {
    INIT_REGISTRATION = 0,
    INIT_QUERY = 1
};

class AE : public cSimpleModule  // one of the module type in omnet
{

public:
    AE();
    virtual ~AE();

  protected:
    // by default in omnet methods
      virtual void initialize(int stage) override;
      virtual void handleMessage(cMessage *msg) override;
    // application specific
      void sendAEMessage(int op_code);
      void registration();
      void sendQuery();
      virtual int numInitStages() const;
      virtual void finish() override;

  private:

      AEMessage *canMsg;
      AEMessage *regMsg;
      AEMessage *queryMsg;


      long numOfFound;
      int queryIndex;
      int URI;
      int data;
      int maxHop;
      int ran_number;
      std::string feature_type;
      std::vector<std::string> feature_types {
          "thermometer","airStation","ATM","smartLock", "waterValve"
      };

      std::map<std::string, std::pair<int, int>> resourceFrequency =
      {
              {"thermometer", {0, 30}},
              {"airStation", {30, 60}},
              {"ATM", {60, 80}},
              {"smartLock", {80, 95}},
              {"waterValve", {95, 100}},
      };


};


Define_Module(AE);


#endif
