package sd.simulator.run;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.tdb.TDBFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class PrepareData {

	
	public static final String SIM = "http://stf-589-sim.linkeddata.es/";
	public static Property RDFTYPE =ResourceFactory.createProperty(RDF.TYPE.toString());
	@SuppressWarnings("deprecation")
	public static void main(String[] args) throws IOException, ParseException {
		
		if(args.length==1) {
			JSONParser parser = new JSONParser();
			JSONObject obj = (JSONObject) parser.parse(new FileReader(args[0]));
			if(checkInputJson(obj)) {
				long startTime = System.currentTimeMillis();
				Integer numberOfCses = Integer.valueOf(obj.get("cses").toString()) ;
				Integer numberOfDevices = Integer.valueOf(obj.get("devices").toString()) ;
				Double deviceProbability = Double.valueOf(obj.get("deviceToCSE").toString()) ;
				Integer numberOfBuildings = Integer.valueOf(obj.get("buildings").toString()) ; 
				Double deviceToBuilding = Double.valueOf(obj.get("deviceToBuilding").toString()) ;
				String outputFile = obj.get("output").toString();
				
				Model stfModel = ModelFactory.createDefaultModel();
				
				List<Resource> buildingsSelected = instantiateBuildings(stfModel, numberOfBuildings); 
				
				Dataset dataset = TDBFactory.createDataset();
				dataset.addNamedModel("http://stf-589-sim.graphs.es/location", stfModel);
				for(int index=0; index<numberOfCses;index++) {
					Model cseModel = ModelFactory.createDefaultModel();
					// Build cse
					Resource cse = buildSimResource("syntectic-cse-"+index);
					cseModel.add(cse, RDFTYPE, ResourceFactory.createResource("http://stf-589-sim.es/core#CSE"));
					// Get devices
					for(int count=0; count<numberOfDevices;count++) {
						if(dice() < deviceProbability) {
							Resource randomId = stfModel.createResource();
							Resource device = buildSimResource("syntectic-device-"+String.valueOf(randomId.toString().hashCode()));
							// Assign static types + properties
							cseModel.add(device, RDFTYPE, thingType);
							cseModel.add(device, RDFTYPE, deviceType);
							cseModel.add(device, ResourceFactory.createProperty("http://purl.org/dc/elements/1.1/title"), ResourceFactory.createPlainLiteral(randomString()));
							// Get random tuple
							String[] tuple = getRandomElem(devices);
							cseModel.add(device, RDFTYPE, ResourceFactory.createResource(tuple[0]));
							// assign property
							Resource property = stfModel.createResource();
							cseModel.add(device, ResourceFactory.createProperty("https://saref.etsi.org/core/measuresProperty"), property);
							cseModel.add(property, RDFTYPE, propertyType);
							cseModel.add(property, RDFTYPE, ResourceFactory.createResource(tuple[1]));
							// assign building space
							Resource buildingSpace = stfModel.createResource();
							cseModel.add(property, ResourceFactory.createProperty("https://saref.etsi.org/core/isPropertyOf"), buildingSpace);
							cseModel.add(buildingSpace, RDFTYPE, buildingSpaceType);
							cseModel.add(buildingSpace, RDFTYPE, ResourceFactory.createResource(tuple[2]));
							if(dice() < deviceToBuilding) {
								Resource buildingResource = getRandomResource(buildingsSelected);
								cseModel.add(buildingSpace, ResourceFactory.createProperty("https://saref.etsi.org/saref4bldg/isSpaceOf"), buildingResource);
								cseModel.add(buildingResource, ResourceFactory.createProperty("https://saref.etsi.org/saref4bldg/hasSpace"), buildingSpace);
							}
							// register device
							cseModel.add(cse, ResourceFactory.createProperty("http://stf-589-sim.es/core#hasRegistered"), device);
							cseModel.add(device, ResourceFactory.createProperty("http://stf-589-sim.es/core#isRegisteredIn"), cse);
							// Add the named graph
							dataset.addNamedModel(cse.getURI(), cseModel);
						}
					}
				}
				dataset.asDatasetGraph();
				FileWriter data = new FileWriter(outputFile);
				RDFDataMgr.write(data,dataset,RDFFormat.NQUADS);
				long endTime   = System.currentTimeMillis();
				long totalTime = endTime - startTime;
				System.out.println("Generation took: "+totalTime+"(ms)");
			}
		}else {
			System.out.println("Please execute the generator in a terminal with the command: java -jar stf-generator ./config.json");
			System.out.println("The './config.json' file must be present in the same directory and contain the following keys");
			System.out.println("\t-'cses' (integer) its value represents the number of CSEs that will be created");
			System.out.println("\t-'devices' (integer) its value represents the number of devices that will be created. The maximum value must be 101 (inclusive)");
			System.out.println("\t-'buildings' (integer) its value represents the number of buildings that will be created. The maximum value must be 99 (inclusive)");
			System.out.println("\t-'deviceToCSE' (double) its value represents the probability with which a CSE will have registered each created device");
			System.out.println("\t-'deviceToBuilding' (double) its value represents the probability with which a device will be assigned to a building randomly");
			System.out.println("\t-'output' (string) its value is the file where the dataset will be written. Consider that the file must have the .nq extension");
		}
	}
	
	
	private static boolean checkInputJson(JSONObject obj) {
		Boolean correct = obj.containsKey("cses") 
				&& obj.containsKey("devices") 
				&& obj.containsKey("deviceToCSE")
				&& obj.containsKey("buildings")
				&& obj.containsKey("deviceToBuilding")
				&& obj.containsKey("output");
		
		if(!correct) {
			System.out.println("Please provide an input json containing the following keys: 'cses', 'devices', 'deviceToCSE', 'buildings', 'deviceToBuilding', 'output'");
		}
		
		return correct;
	}


	public static Resource spacialThingType = ResourceFactory.createResource("http://www.opengis.net/ont/geosparql#SpatialThing");	
	public static Resource buildingType = ResourceFactory.createResource("https://saref.etsi.org/saref4bldg/Building");	
	public static Resource buildingSpaceType = ResourceFactory.createResource("https://saref.etsi.org/saref4bldg/BuildingSpace");
	public static Resource cityType = ResourceFactory.createResource("https://saref.etsi.org/saref4city/City");	
	public static Resource countryType = ResourceFactory.createResource("https://saref.etsi.org/saref4city/Country");	

	
	public static Resource thingType = ResourceFactory.createResource("https://www.w3.org/2019/wot/td#Thing");
	public static Resource deviceType = ResourceFactory.createResource("https://saref.etsi.org/core/Device");
	public static Resource propertyType = ResourceFactory.createResource("https://saref.etsi.org/core/Property");
	public static Resource foiType = ResourceFactory.createResource("https://saref.etsi.org/core/FeatureOfInterest");
	public static List<String[]> devices;
	static {
		devices = new ArrayList<>();
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/DistributionDevice","https://saref.etsi.org/core/Occupancy","http://stf-589-sim.es/core#Balcony"});
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/FlowMovingDevice","https://saref.etsi.org/core/Motion","http://stf-589-sim.es/core#Balcony"});
		devices.add(new String[] {"https://saref.etsi.org/core/DoorSensor","https://saref.etsi.org/core/Occupancy","http://stf-589-sim.es/core#Balcony"});
		devices.add(new String[] {"https://saref.etsi.org/core/TemperatureSensor","https://saref.etsi.org/core/Temperature","http://stf-589-sim.es/core#Balcony"});
		devices.add(new String[] {"http://stf-589-sim.es/core#WeatherStation","https://saref.etsi.org/core/Light","http://stf-589-sim.es/core#Balcony"});
		devices.add(new String[] {"http://stf-589-sim.es/core#WeatherStation","https://saref.etsi.org/core/Temperature","http://stf-589-sim.es/core#Balcony"});
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/Alarm","https://saref.etsi.org/core/BinaryStatus","http://stf-589-sim.es/core#BoilerRoom"});
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/Boiler","https://saref.etsi.org/core/Temperature","http://stf-589-sim.es/core#BoilerRoom"});
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/CoolingTower","https://saref.etsi.org/core/Temperature","http://stf-589-sim.es/core#BoilerRoom"});
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/DistributionDevice","https://saref.etsi.org/core/Occupancy","http://stf-589-sim.es/core#BoilerRoom"});
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/ElectricMotor","https://saref.etsi.org/core/Energy","http://stf-589-sim.es/core#BoilerRoom"});
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/FlowMovingDevice","https://saref.etsi.org/core/Motion","http://stf-589-sim.es/core#BoilerRoom"});
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/Humidifier","https://saref.etsi.org/core/Humidity","http://stf-589-sim.es/core#BoilerRoom"});
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/SpaceHeater","https://saref.etsi.org/core/Temperature","http://stf-589-sim.es/core#BoilerRoom"});
		devices.add(new String[] {"https://saref.etsi.org/core/DoorSensor","https://saref.etsi.org/core/Occupancy","http://stf-589-sim.es/core#BoilerRoom"});
		devices.add(new String[] {"https://saref.etsi.org/core/Lightbulb","https://saref.etsi.org/core/Light","http://stf-589-sim.es/core#BoilerRoom"});
		devices.add(new String[] {"https://saref.etsi.org/core/LightSwitch","https://saref.etsi.org/core/Light","http://stf-589-sim.es/core#BoilerRoom"});
		devices.add(new String[] {"https://saref.etsi.org/core/SmokeSensor","https://saref.etsi.org/core/Smoke","http://stf-589-sim.es/core#BoilerRoom"});
		devices.add(new String[] {"https://saref.etsi.org/core/TemperatureSensor","https://saref.etsi.org/core/Temperature","http://stf-589-sim.es/core#BoilerRoom"});
		devices.add(new String[] {"http://stf-589-sim.es/core#FogSensor","https://saref.etsi.org/core/Load","http://stf-589-sim.es/core#BoilerRoom"});
		devices.add(new String[] {"http://stf-589-sim.es/core#PanicButton","https://saref.etsi.org/core/BinaryStatus","http://stf-589-sim.es/core#BoilerRoom"});
		devices.add(new String[] {"http://stf-589-sim.es/core#SoundSensor","http://stf-589-sim.es/core#sound","http://stf-589-sim.es/core#BoilerRoom"});
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/CoolingTower","https://saref.etsi.org/core/Temperature","http://stf-589-sim.es/core#Corridor"});
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/DistributionDevice","https://saref.etsi.org/core/Occupancy","http://stf-589-sim.es/core#Corridor"});
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/Fan", "http://stf-589-sim.es/core#BinaryStatus","http://stf-589-sim.es/core#Corridor"});
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/FlowMovingDevice","https://saref.etsi.org/core/Motion","http://stf-589-sim.es/core#Corridor"});
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/Humidifier","https://saref.etsi.org/core/Humidity","http://stf-589-sim.es/core#Corridor"});
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/SpaceHeater","https://saref.etsi.org/core/Temperature","http://stf-589-sim.es/core#Corridor"});
		devices.add(new String[] {"https://saref.etsi.org/core/DoorSensor","https://saref.etsi.org/core/Occupancy","http://stf-589-sim.es/core#Corridor"});
		devices.add(new String[] {"https://saref.etsi.org/core/Lightbulb","https://saref.etsi.org/core/Light","http://stf-589-sim.es/core#Corridor"});
		devices.add(new String[] {"https://saref.etsi.org/core/LightSwitch","https://saref.etsi.org/core/Light","http://stf-589-sim.es/core#Corridor"});
		devices.add(new String[] {"https://saref.etsi.org/core/SmokeSensor","https://saref.etsi.org/core/Smoke","http://stf-589-sim.es/core#Corridor"});
		devices.add(new String[] {"https://saref.etsi.org/core/TemperatureSensor","https://saref.etsi.org/core/Temperature","http://stf-589-sim.es/core#Corridor"});
		devices.add(new String[] {"http://stf-589-sim.es/core#SoundSensor","http://stf-589-sim.es/core#sound","http://stf-589-sim.es/core#Corridor"});
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/CoolingTower","https://saref.etsi.org/core/Temperature","http://stf-589-sim.es/core#Entrance"});
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/DistributionDevice","https://saref.etsi.org/core/Occupancy","http://stf-589-sim.es/core#Entrance"});
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/FlowMovingDevice","https://saref.etsi.org/core/Motion","http://stf-589-sim.es/core#Entrance"});
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/Humidifier","https://saref.etsi.org/core/Humidity","http://stf-589-sim.es/core#Entrance"});
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/SpaceHeater","https://saref.etsi.org/core/Temperature","http://stf-589-sim.es/core#Entrance"});
		devices.add(new String[] {"https://saref.etsi.org/core/DoorSensor","https://saref.etsi.org/core/Occupancy","http://stf-589-sim.es/core#Entrance"});
		devices.add(new String[] {"https://saref.etsi.org/core/Lightbulb","https://saref.etsi.org/core/Light","http://stf-589-sim.es/core#Entrance"});
		devices.add(new String[] {"https://saref.etsi.org/core/LightSwitch","https://saref.etsi.org/core/Light","http://stf-589-sim.es/core#Entrance"});
		devices.add(new String[] {"https://saref.etsi.org/core/SmokeSensor","https://saref.etsi.org/core/Smoke","http://stf-589-sim.es/core#Entrance"});
		devices.add(new String[] {"https://saref.etsi.org/core/TemperatureSensor","https://saref.etsi.org/core/Temperature","http://stf-589-sim.es/core#Entrance"});
		devices.add(new String[] {"http://stf-589-sim.es/core#SoundSensor","http://stf-589-sim.es/core#sound","http://stf-589-sim.es/core#Entrance"});
		devices.add(new String[] {"http://stf-589-sim.es/core#WeatherStation","https://saref.etsi.org/core/Light","http://stf-589-sim.es/core#Entrance"});
		devices.add(new String[] {"http://stf-589-sim.es/core#WeatherStation","https://saref.etsi.org/core/Temperature","http://stf-589-sim.es/core#Entrance"});
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/DistributionDevice","https://saref.etsi.org/core/Occupancy","http://stf-589-sim.es/core#Garden"});
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/FlowMovingDevice","https://saref.etsi.org/core/Motion","http://stf-589-sim.es/core#Garden"});
		devices.add(new String[] {"https://saref.etsi.org/core/DoorSensor","https://saref.etsi.org/core/Occupancy","http://stf-589-sim.es/core#Garden"});
		devices.add(new String[] {"https://saref.etsi.org/core/Lightbulb","https://saref.etsi.org/core/Light","http://stf-589-sim.es/core#Garden"});
		devices.add(new String[] {"https://saref.etsi.org/core/LightSwitch","https://saref.etsi.org/core/Light","http://stf-589-sim.es/core#Garden"});
		devices.add(new String[] {"https://saref.etsi.org/core/SmokeSensor","https://saref.etsi.org/core/Smoke","http://stf-589-sim.es/core#Garden"});
		devices.add(new String[] {"http://stf-589-sim.es/core#WeatherStation","https://saref.etsi.org/core/Light","http://stf-589-sim.es/core#Garden"});
		devices.add(new String[] {"http://stf-589-sim.es/core#WeatherStation","https://saref.etsi.org/core/Temperature","http://stf-589-sim.es/core#Garden"});
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/CoolingTower","https://saref.etsi.org/core/Temperature","http://stf-589-sim.es/core#Lounge"});
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/DistributionDevice","https://saref.etsi.org/core/Occupancy","http://stf-589-sim.es/core#Lounge"});
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/Fan", "http://stf-589-sim.es/core#BinaryStatus","http://stf-589-sim.es/core#Lounge"});
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/FlowMovingDevice","https://saref.etsi.org/core/Motion","http://stf-589-sim.es/core#Lounge"});
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/Humidifier","https://saref.etsi.org/core/Humidity","http://stf-589-sim.es/core#Lounge"});
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/SpaceHeater","https://saref.etsi.org/core/Temperature","http://stf-589-sim.es/core#Lounge"});
		devices.add(new String[] {"https://saref.etsi.org/core/DoorSensor","https://saref.etsi.org/core/Occupancy","http://stf-589-sim.es/core#Lounge"});
		devices.add(new String[] {"https://saref.etsi.org/core/Lightbulb","https://saref.etsi.org/core/Light","http://stf-589-sim.es/core#Lounge"});
		devices.add(new String[] {"https://saref.etsi.org/core/LightSwitch","https://saref.etsi.org/core/Light","http://stf-589-sim.es/core#Lounge"});
		devices.add(new String[] {"https://saref.etsi.org/core/SmokeSensor","https://saref.etsi.org/core/Smoke","http://stf-589-sim.es/core#Lounge"});
		devices.add(new String[] {"https://saref.etsi.org/core/TemperatureSensor","https://saref.etsi.org/core/Temperature","http://stf-589-sim.es/core#Lounge"});
		devices.add(new String[] {"http://stf-589-sim.es/core#SoundSensor","http://stf-589-sim.es/core#sound","http://stf-589-sim.es/core#Lounge"});
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/Alarm","https://saref.etsi.org/core/BinaryStatus","http://stf-589-sim.es/core#RedRoom"});
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/CoolingTower","https://saref.etsi.org/core/Temperature","http://stf-589-sim.es/core#RedRoom"});
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/DistributionDevice","https://saref.etsi.org/core/Occupancy","http://stf-589-sim.es/core#RedRoom"});
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/Fan", "http://stf-589-sim.es/core#BinaryStatus","http://stf-589-sim.es/core#RedRoom"});
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/FlowMovingDevice","https://saref.etsi.org/core/Motion","http://stf-589-sim.es/core#RedRoom"});
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/Humidifier","https://saref.etsi.org/core/Humidity","http://stf-589-sim.es/core#RedRoom"});
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/SpaceHeater","https://saref.etsi.org/core/Temperature","http://stf-589-sim.es/core#RedRoom"});
		devices.add(new String[] {"https://saref.etsi.org/core/DoorSensor","https://saref.etsi.org/core/Occupancy","http://stf-589-sim.es/core#RedRoom"});
		devices.add(new String[] {"https://saref.etsi.org/core/Lightbulb","https://saref.etsi.org/core/Light","http://stf-589-sim.es/core#RedRoom"});
		devices.add(new String[] {"https://saref.etsi.org/core/LightSwitch","https://saref.etsi.org/core/Light","http://stf-589-sim.es/core#RedRoom"});
		devices.add(new String[] {"https://saref.etsi.org/core/SmokeSensor","https://saref.etsi.org/core/Smoke","http://stf-589-sim.es/core#RedRoom"});
		devices.add(new String[] {"https://saref.etsi.org/core/TemperatureSensor","https://saref.etsi.org/core/Temperature","http://stf-589-sim.es/core#RedRoom"});
		devices.add(new String[] {"http://stf-589-sim.es/core#PanicButton","https://saref.etsi.org/core/BinaryStatus","http://stf-589-sim.es/core#RedRoom"});
		devices.add(new String[] {"http://stf-589-sim.es/core#SoundSensor","http://stf-589-sim.es/core#sound","http://stf-589-sim.es/core#RedRoom"});
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/ElectricGenerator","https://saref.etsi.org/core/Energy","http://stf-589-sim.es/core#Roof"});
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/FlowMovingDevice","https://saref.etsi.org/core/Motion","http://stf-589-sim.es/core#Roof"});
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/SolarDevice","https://saref.etsi.org/core/Energy","http://stf-589-sim.es/core#Roof"});
		devices.add(new String[] {"https://saref.etsi.org/core/DoorSensor","https://saref.etsi.org/core/Occupancy","http://stf-589-sim.es/core#Roof"});
		devices.add(new String[] {"https://saref.etsi.org/core/TemperatureSensor","https://saref.etsi.org/core/Temperature","http://stf-589-sim.es/core#Roof"});
		devices.add(new String[] {"http://stf-589-sim.es/core#PV","https://saref.etsi.org/core/Energy","http://stf-589-sim.es/core#Roof"});
		devices.add(new String[] {"http://stf-589-sim.es/core#WeatherStation","https://saref.etsi.org/core/Light","http://stf-589-sim.es/core#Roof"});
		devices.add(new String[] {"http://stf-589-sim.es/core#WeatherStation","https://saref.etsi.org/core/Temperature","http://stf-589-sim.es/core#Roof"});
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/CoolingTower","https://saref.etsi.org/core/Temperature","http://stf-589-sim.es/core#Room"});
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/DistributionDevice","https://saref.etsi.org/core/Occupancy","http://stf-589-sim.es/core#Room"});
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/FlowMovingDevice","https://saref.etsi.org/core/Motion","http://stf-589-sim.es/core#Room"});
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/Humidifier","https://saref.etsi.org/core/Humidity","http://stf-589-sim.es/core#Room"});
		devices.add(new String[] {"https://saref.etsi.org/saref4bldg/SpaceHeater","https://saref.etsi.org/core/Temperature","http://stf-589-sim.es/core#Room"});
		devices.add(new String[] {"https://saref.etsi.org/core/DoorSensor","https://saref.etsi.org/core/Occupancy","http://stf-589-sim.es/core#Room"});
		devices.add(new String[] {"https://saref.etsi.org/core/Lightbulb","https://saref.etsi.org/core/Light","http://stf-589-sim.es/core#Room"});
		devices.add(new String[] {"https://saref.etsi.org/core/LightSwitch","https://saref.etsi.org/core/Light","http://stf-589-sim.es/core#Room"});
		devices.add(new String[] {"https://saref.etsi.org/core/SmokeSensor","https://saref.etsi.org/core/Smoke","http://stf-589-sim.es/core#Room"});
		devices.add(new String[] {"https://saref.etsi.org/core/TemperatureSensor","https://saref.etsi.org/core/Temperature","http://stf-589-sim.es/core#Room"});
		devices.add(new String[] {"http://stf-589-sim.es/core#PanicButton","https://saref.etsi.org/core/BinaryStatus","http://stf-589-sim.es/core#Room"});
		devices.add(new String[] {"http://stf-589-sim.es/core#SoundSensor","http://stf-589-sim.es/core#sound","http://stf-589-sim.es/core#Room"});
		
	}
	
	public static String randomString() {
		 int leftLimit = 97; // letter 'a'
		    int rightLimit = 122; // letter 'z'
		    int targetStringLength = 10;
		    Random random = new Random();

		    return random.ints(leftLimit, rightLimit + 1)
		      .limit(targetStringLength)
		      .collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append)
		      .toString();
	}

	public static Resource buildSimResource(String val) {
		return ResourceFactory.createResource(SIM+val);
	}
	
	public static String[] getRandomElem(List<String[]> resources) {
		 Random rand = new Random();
		 return resources.get(rand.nextInt(resources.size()));
	}

	public static Resource getRandomResource(List<Resource> resources) {
		 Random rand = new Random();
		 return resources.get(rand.nextInt(resources.size()));
	}
	
	public static Double dice() {
		Random rd = new Random();
		return  rd.nextDouble();
	}
	
	private static List<Resource> instantiateBuildings(Model stfModel, Integer numberOfBuildings) {
		List<Resource> buildingsSelected = new ArrayList<>(); 
		
		for(int index=0; index < numberOfBuildings; index++) {
			String[] randomTuple = getRandomElem(buildings);
			
			Resource resource = buildSimResource("syntectic-building-"+String.valueOf(randomTuple[0].hashCode()));
			buildingsSelected.add(resource);
			stfModel.add(resource, RDFTYPE, buildingType);
			stfModel.add(resource, RDFTYPE, spacialThingType);
			stfModel.add(resource, RDFTYPE, ResourceFactory.createResource("http://stf-589-sim.es/core#"+randomTuple[4].replace(" ", "")));
			stfModel.add(resource, ResourceFactory.createProperty("http://www.w3.org/2000/01/rdf-schema#label"), ResourceFactory.createPlainLiteral(randomTuple[1]));
			stfModel.add(resource, ResourceFactory.createProperty("http://www.opengis.net/ont/geosparql#latitude"), ResourceFactory.createPlainLiteral(randomTuple[5]));
			stfModel.add(resource, ResourceFactory.createProperty("http://www.opengis.net/ont/geosparql#longitude"), ResourceFactory.createPlainLiteral(randomTuple[6]));
			
			Resource resourceCity = buildSimResource("syntectic-city-"+String.valueOf(randomTuple[2].hashCode()));
			stfModel.add(resourceCity, RDFTYPE, cityType);
			stfModel.add(resourceCity, RDFTYPE, spacialThingType);
			stfModel.add(resourceCity, ResourceFactory.createProperty("http://www.w3.org/2000/01/rdf-schema#label"), ResourceFactory.createPlainLiteral(randomTuple[2]));
			stfModel.add(resourceCity, ResourceFactory.createProperty("http://www.opengis.net/ont/geosparql#latitude"), ResourceFactory.createPlainLiteral(randomTuple[5]));
			stfModel.add(resourceCity, ResourceFactory.createProperty("http://www.opengis.net/ont/geosparql#longitude"), ResourceFactory.createPlainLiteral(randomTuple[6]));
			
			Resource resourceCountry = buildSimResource("syntectic-country-"+String.valueOf(randomTuple[3].hashCode()));
			stfModel.add(resourceCountry, RDFTYPE, countryType);
			stfModel.add(resourceCountry, RDFTYPE, spacialThingType);
			stfModel.add(resourceCountry, ResourceFactory.createProperty("http://www.w3.org/2000/01/rdf-schema#label"), ResourceFactory.createPlainLiteral(randomTuple[3]));
			
			
			stfModel.add(resource, ResourceFactory.createProperty("http://www.opengis.net/ont/geosparql#sfContainedIn"), resourceCity);
			stfModel.add(resourceCity, ResourceFactory.createProperty("http://www.opengis.net/ont/geosparql#sfContains"), resource);
			
			stfModel.add(resourceCity, ResourceFactory.createProperty("http://www.opengis.net/ont/geosparql#sfContainedIn"), resourceCountry);
			stfModel.add(resourceCountry, ResourceFactory.createProperty("http://www.opengis.net/ont/geosparql#sfContains"), resourceCity);
		}
		
		return buildingsSelected;
	}
	
	public static List<String[]> buildings;
	static {
		buildings = new ArrayList<>();
		buildings.add(new String[] {"Mont_Saint-Michel","Mont Saint-Michel","Normandy","France","Palace","48.636002","-1.5114"});
		buildings.add(new String[] {"Esplanade_Jean-Marie_Louvel","Esplanade Jean-Marie Louvel","Caen","France","Palace","49.181801","-0.372984"});
		buildings.add(new String[] {"Palace_of_Versailles","Palace of Versailles","Versailles","France","Palace","48.804722","2.121782"});
		buildings.add(new String[] {"Hotel_National_des_Invalides","Hotel National des Invalides","Paris","France","Palace","48.854904","2.312461"});
		buildings.add(new String[] {"The_Hotel_de_Ville","The Hotel de Ville","Paris","France","Palace","48.856373","2.353016"});
		buildings.add(new String[] {"The_Palace_of_Lezama_Leguizamon","The Palace of Lezama Leguizamon","Bilbao","Spain","Palace","43.264465","-2.939974"});
		buildings.add(new String[] {"Chavarri_Palace","Chavarri Palace","Bilbao","Spain","Palace","43.263432","-2.935648"});
		buildings.add(new String[] {"Palace_of_the_Dukes_of_Alba","Palace of the Dukes of Alba","Seville","Spain","Palace","37.394844","-5.989292"});
		buildings.add(new String[] {"Palacio_de_San_Telmo","Palacio de San Telmo","Seville","Spain","Palace","37.380852","-5.993192"});
		buildings.add(new String[] {"Palace_of_the_Countess_of_Lebrija","Palace of the Countess of Lebrija","Seville","Spain","Palace","37.39212","-5.993937"});
		buildings.add(new String[] {"Casa_de_Pilatos","Casa de Pilatos","Seville","Spain","Palace","37.390282","-5.987129"});
		buildings.add(new String[] {"Royal_Alcazar_of_Seville","Royal Alcazar of Seville","Seville","Spain","Palace","37.383053","-5.990226"});
		buildings.add(new String[] {"Aljafera_Palace","Aljafer’a Palace","Zaragoza","Spain","Palace","41.656456","-0.897113"});
		buildings.add(new String[] {"Cybele_Palace","Cybele Palace","Madrid","Spain","Palace","40.419159","-3.692122"});
		buildings.add(new String[] {"Palacio_de_Cristal","Palacio de Cristal","Madrid","Spain","Palace","40.413628","-3.68204"});
		buildings.add(new String[] {"El_Escorial_Palace","El Escorial Palace","Madrid","Spain","Palace","40.589043","-4.147727"});
		buildings.add(new String[] {"Royal_Palace_of_Madrid","Royal Palace of Madrid","Madrid","Spain","Palace","40.417953","-3.714312"});
		buildings.add(new String[] {"Palau_Nacional","Palau Nacional","Barcelona","Spain","Palace","41.368809","2.153392"});
		buildings.add(new String[] {"Palau_Guell","Palau GŸell","Barcelona","Spain","Palace","41.378883","2.17424"});
		buildings.add(new String[] {"Av_Juan_de_Borbon_y_Battemberg","Av Juan de Borbon y Battemberg","Madrid","Spain","Palace","40.589043","-4.147727"});
		buildings.add(new String[] {"Serantes_Kultur_Aretoa","Serantes Kultur Aretoa","Bilbao","Spain","Historical Building","43.326435","-3.033169"});
		buildings.add(new String[] {"Dogs_Fountain","Dog's Fountain","Bilbao","Spain","Historical Building","43.257793","-2.924329"});
		buildings.add(new String[] {"Mercado_de_la_Ribera","Mercado de la Ribera","Bilbao","Spain","Historical Building","43.255573","-2.924206"});
		buildings.add(new String[] {"Azkuna_Zentroa","Azkuna Zentroa","Bilbao","Spain","Historical Building","43.25983","-2.936812"});
		buildings.add(new String[] {"Cultural_Center_of_Flamenco_Casa_de_la_Memoria","Cultural Center of Flamenco 'Casade la Memoria'","Seville","Spain","Historical Building","37.392384","-5.993839"});
		buildings.add(new String[] {"CaixaForum_Seville","CaixaForum Seville","Seville","Spain","Historical Building","37.393955","-6.00929"});
		buildings.add(new String[] {"Casa_de_Murillo","Casa de Murillo","Seville","Spain","Historical Building","37.385647","-5.989047"});
		buildings.add(new String[] {"Metropol_Parasol","Metropol Parasol","Seville","Spain","Historical Building","37.393238","-5.991848"});
		buildings.add(new String[] {"Torre_del_Oro","Torre del Oro","Seville","Spain","Historical Building","37.382412","-5.99649"});
		buildings.add(new String[] {"Leaning_Tower_of_Zaragoza","Leaning Tower of Zaragoza","Zaragoza","Spain","Historical Building","41.655003","-0.88223"});
		buildings.add(new String[] {"CaixaForum","CaixaForum","Zaragoza","Spain","Historical Building","41.652164","-0.894163"});
		buildings.add(new String[] {"Torre_del_Agua","Torre del Agua","Zaragoza","Spain","Historical Building","41.670486","-0.907693"});
		buildings.add(new String[] {"Bridge_Pavilion","Bridge Pavilion","Zaragoza","Spain","Historical Building","41.66695","-0.904988"});
		buildings.add(new String[] {"Market_of_San_Miguel","Market of San Miguel","Madrid","Spain","Historical Building","40.415421","-3.709022"});
		buildings.add(new String[] {"Cuartel_del_Conde-Duque","Cuartel del Conde-Duque","Madrid","Spain","Historical Building","40.426674","-3.711092"});
		buildings.add(new String[] {"Cason_del_Buen_Retiro","Casón del Buen Retiro","Madrid","Spain","Historical Building","40.415283","-3.689601"});
		buildings.add(new String[] {"Royal_Academy_of_Fine_Arts_of_San_Fernando","Royal Academy of Fine Arts of San Fernando","Madrid","Spain","Historical Building","40.417789","-3.70071"});
		buildings.add(new String[] {"CaixaForum_Madrid","CaixaForum Madrid","Madrid","Spain","Historical Building","40.411114","-3.693571"});
		buildings.add(new String[] {"Teatro_de_La_Latina","Teatro de La Latina","Madrid","Spain","Historical Building","40.41106","-3.712291"});
		buildings.add(new String[] {"Casa_Batllo","Casa Batlló","Barcelona","Spain","Historical Building","41.39164","2.16477"});
		buildings.add(new String[] {"Center_of_Contemporary_Culture","Center of Contemporary Culture","Barcelona","Spain","Historical Building","41.383785","2.166775"});
		buildings.add(new String[] {"Barcelona_Pavilion","Barcelona Pavilion","Barcelona","Spain","Historical Building","41.370609","2.150163"});
		buildings.add(new String[] {"Casa_Amatller","Casa Amatller","Barcelona","Spain","Historical Building","41.391514","2.165016"});
		buildings.add(new String[] {"Casa_Vicens","Casa Vicens","Barcelona","Spain","Historical Building","41.4035","2.150645"});
		buildings.add(new String[] {"Aquarium_Barcelona","Aquarium Barcelona","Barcelona","Spain","Historical Building","41.376839","2.184338"});
		buildings.add(new String[] {"The_Tempodrom","The Tempodrom","Berlin","Germany","Historical Building","52.501667","13.381111"});
		buildings.add(new String[] {"Berlin_Central_Railway_Station","Berlin Central Railway Station","Berlin","Germany","Historical Building","52.524929","13.369181"});
		buildings.add(new String[] {"House_of_Schwarzenberg","House of Schwarzenberg","Berlin","Germany","Historical Building","52.524258","13.402868"});
		buildings.add(new String[] {"Reichstag","Reichstag","Berlin","Germany","Historical Building","52.518623","13.376198"});
		buildings.add(new String[] {"Galleria_Borghese","Galleria Borghese","Rome","Italy","Historical Building","41.914211","12.492144"});
		buildings.add(new String[] {"Villa_dEste","Villa d'Este","Rome","Italy","Historical Building","41.96331","12.795806"});
		buildings.add(new String[] {"Altare_della_Patria","Altare della Patria","Rome","Italy","Historical Building","41.894596","12.483127"});
		buildings.add(new String[] {"Villa_Doria_Pamphilj","Villa Doria Pamphilj","Rome","Italy","Historical Building","41.892567","12.445965"});
		buildings.add(new String[] {"Futurium","Futurium","Berlin","Germany","Museum","52.524136","13.37375"});
		buildings.add(new String[] {"Kulturforum","Kulturforum","Berlin","Germany","Museum","52.508522","13.366606"});
		buildings.add(new String[] {"Bauhaus-Archiv_Museum_fur_Gestaltung","Bauhaus-Archiv / Museum für Gestaltung","Berlin","Germany","Museum","52.506088","13.352802"});
		buildings.add(new String[] {"Jewish_Museum","Jewish Museum","Berlin","Germany","Museum","52.502182","13.395596"});
		buildings.add(new String[] {"Museum_Island","Museum Island","Berlin","Germany","Museum","52.51664","13.402318"});
		buildings.add(new String[] {"Vulci","Vulci","Montalto di Castro VT","Italy","Historical Building","42.424114","11.631095"});
		buildings.add(new String[] {"Baths_of_Caracalla","Baths of Caracalla","Rome","Italy","Historical Building","41.87904","12.492439"});
		buildings.add(new String[] {"Hadrians_Villa","Hadrian's Villa","Rome","Italy","Historical Building","41.942802","12.774399"});
		buildings.add(new String[] {"Circus_Maximus","Circus Maximus","Rome","Italy","Historical Building","41.886131","12.485133"});
		buildings.add(new String[] {"Spanish_Steps","Spanish Steps","Rome","Italy","Historical Building","41.905991","12.482775"});
		buildings.add(new String[] {"Pantheon","Pantheon","Rome","Italy","Historical Building","41.898609","12.476873"});
		buildings.add(new String[] {"Trevi_Fountain","Trevi Fountain","Rome","Italy","Historical Building","41.900932","12.483313"});
		buildings.add(new String[] {"Roman_Forum","Roman Forum","Rome","Italy","Historical Building","41.892464","12.485325"});
		buildings.add(new String[] {"Coliseum","Coliseum","Rome","Italy","Historical Building","41.890209","12.492231"});
		buildings.add(new String[] {"The_Colosseum_of_Rome","The Colosseum of Rome","Rome","Italy","Historical Building","41.890251","12.492373"});
		buildings.add(new String[] {"Berlin_Wall","Berlin Wall","Berlin","Germany","Historical Building","52.535152","13.390206"});
		buildings.add(new String[] {"Reichstag","Reichstag","Berlin","Germany","Historical Building","52.518589","13.376665"});
		buildings.add(new String[] {"Soviet_War_Memorial","Soviet War Memorial","Berlin","Germany","Historical Building","52.486191","13.471878"});
		buildings.add(new String[] {"Brandenburg_Gate","Brandenburg Gate","Berlin","Germany","Historical Building","52.516266","13.377775"});
		buildings.add(new String[] {"Chateau_de_Chambord","Château de Chambord","Loir-et-Cher","France","Historical Building","47.616341","1.516962"});
		buildings.add(new String[] {"Traiteor_du_Val_de_Loire","Traiteor du Val de Loire","La-Chapelle-sur-Erdre","France","Historical Building","47.311428","-1.577219"});
		buildings.add(new String[] {"Saint-Germain-des-Pres_Abbey","Saint-Germain-des-Prés Abbey","Paris","France","Historical Building","48.853867","2.334723"});
		buildings.add(new String[] {"Bamberg_Cathedral","Bamberg Cathedral","Bamberg","Germany","Cathedral","49.890774","10.882515"});
		buildings.add(new String[] {"Cathedral_of_Trier","Cathedral of Trier","Trier","Germany","Cathedral","49.755405","6.643762"});
		buildings.add(new String[] {"Meissen_Cathedral","Meissen Cathedral","Meissen","Germany","Cathedral","51.166515","13.471674"});
		buildings.add(new String[] {"Mainz_Cathedral","Mainz Cathedral","Mainz","Germany","Cathedral","49.998898","8.273946"});
		buildings.add(new String[] {"Dresden_Cathedral","Dresden Cathedral","Dresden","Germany","Cathedral","51.053493","13.737524"});
		buildings.add(new String[] {"Dreikonigsstrabe","Dreikönigsstraße","Frankfurt am Main","Germany","Cathedral","50.107254","8.685223"});
		buildings.add(new String[] {"New_St._Johns_Church","New St. John's Church","Munich","Germany","Cathedral","48.134052","11.59773"});
		buildings.add(new String[] {"Halberstadt_Cathedral","Halberstadt Cathedral","Halberstadt","Germany","Cathedral","51.895912","11.049378"});
		buildings.add(new String[] {"Paderborn_Cathedral","Paderborn Cathedral","Paderborn","Germany","Cathedral","51.718674","8.756093"});
		buildings.add(new String[] {"Frankfurt_Cathedral","Frankfurt Cathedral","Frankfurt","Germany","Cathedral","50.110573","8.684966"});
		buildings.add(new String[] {"Bremen_Cathedral","Bremen Cathedral","Bremen","Germany","Cathedral","53.07584","8.809254"});
		buildings.add(new String[] {"Cathedral_of_Magdeburg","Cathedral of Magdeburg","Magdeburg","Germany","Cathedral","52.12455","11.63376"});
		buildings.add(new String[] {"Ferienwohnung_am_Dom","Ferienwohnung am Dom","Regensburg","Germany","Cathedral","49.019653","12.097546"});
		buildings.add(new String[] {"St._Johns_Church","St. John's Church","Lüneburg","Germany","Cathedral","53.247684","10.412174"});
		buildings.add(new String[] {"The_Cathedral_of_St._Peter_at_Schleswig","The Cathedral of St. Peter at Schleswig","Schleswig","Germany","Cathedral","54.513329","9.569081"});
		buildings.add(new String[] {"Lubeck_Cathedral","Lübeck Cathedral","Lübeck","Germany","Cathedral","53.860802","10.686913"});
		buildings.add(new String[] {"Berlin_Cathedral","Berlin Cathedral","Berlin","Germany","Cathedral","52.518898","13.401797"});
		buildings.add(new String[] {"Schwerin_Cathedral","Schwerin Cathedral","Schwerin","Germany","Cathedral","53.629593","11.414763"});
		buildings.add(new String[] {"Frauenkirche_(The_Cathedral_of_Our_Dear_Lady)","Frauenkirche (The Cathedral of Our Dear Lady)","Munich","Germany","Cathedral","48.138641","11.573625"});
		buildings.add(new String[] {"Fulda_Cathedral","Fulda Cathedral","Fulda","Germany","Cathedral","50.553974","9.67255"});
		buildings.add(new String[] {"Cologne_Cathedral_(Kölner_Dom)","Cologne Cathedral (Kölner Dom)","Cologne","Germany","Cathedral","50.941357","6.958307"});
		buildings.add(new String[] {"Bordeaux_Cathedral","Bordeaux Cathedral","Bordeaux","France","Cathedral","44.837994","-0.576675"});
		buildings.add(new String[] {"Pl._Saint_Benigne","Pl. Saint Bénigne","Dijon","France","Cathedral","47.321491","5.034517"});
		buildings.add(new String[] {"Notre_Dame","Notre Dame","Paris","France","Cathedral","48.852737","2.350699"});
	}
}
