#!/usr/bin/python
##############################################################################
# profiler of oneM2M stacks
# creator:
# Thierry Monteil (thierry.monteil@irit.fr)
#
#BSD 3-Clause License
#
#Copyright (c) 2024, IoT / SmartM2M-oneM2M-performance-evaluation
#All rights reserved.

import socket
import os
import time
import signal

# port and host to receive order from client part
HOST = 'localhost'
PORT = 9998

# capacity of processor in term of mips
MIPS = 4589

def runoneM2MStack(STACK):
    newpid = os.fork()
    if newpid == -1:
        print("Error creating stack")
        exit(-1)

    elif newpid == 0: # should run +"stack
        print("start stack: "+STACK)
        if STACK=="ACME":
            os.execv('/usr/bin/python3',['python3','-m','acme'])
        print("error stack "+STACK+" has been stopped")
        exit(-2)

    else: # shoud open process image
        time.sleep(5)
        print("pid of stack is"+str(newpid))
        fic_cpu=open('/proc/'+str(newpid)+'/stat','r')
        fic_mem=open('/proc/'+str(newpid)+'/statm','r')
        #fic_cpu=open('./stat.txt','r')
        #fic_mem=open('./statm.txt','r')
        print("stat files have been opened")
    return fic_cpu, fic_mem, newpid

def getResources(fic_res, fic_mem):
    # tick per secodfor this processor
    CLK_TCK=100
    linecpu=fic_res.read()
    fic_res.seek(0)
    # find the fields
    fieldscpu = linecpu.strip().split(' ')
    # analyse fields
    cpu = (float(fieldscpu[13])+float(fieldscpu[14]))/CLK_TCK
    linemem=fic_mem.read()
    fic_mem.seek(0)
    fieldsmem = linemem.strip().split(' ')
    size_rss_pages = int(fieldsmem[1])  # size resident pages
    size_shared_pages = int(fieldsmem[2])  # size shared pages
        # convert in Bytes
    size_page_Bytes = os.sysconf('SC_PAGESIZE')
    memory=size_rss_pages * size_page_Bytes + size_shared_pages * size_page_Bytes
    print("cpu: "+str(cpu)+" mem: "+str(memory))
    return cpu, memory


def main():
    global fic_cpu
    global fic_mem
    global fic_stat
# run server part
    with socket.socket(socket.AF_INET,  socket.SOCK_STREAM) as s:
        s.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
        s.bind((HOST, PORT))
        s.listen(1)
        runServer=True
        print("-----------connect")
        conn, address = s.accept()
        with conn:
            while runServer:
                buff = conn.recv(512)
                message = buff.decode('utf-8')
                print("-----------receive "+message)
                # runserver=False for stop
                fieldsorder =message.strip().split(' ')
                
                if  fieldsorder[0]=="RUN":
                    # run the stack
                    fic_cpu, fic_mem, pid= runoneM2MStack(fieldsorder[1])
                    print("iot stack: "+fieldsorder[1]+" is running with pid:"+str(pid))
                    # open json file
                    fic_stat=open(fieldsorder[1]+"_Resources",'w')
                    fic_stat.write("Mips "+str(MIPS)+"\n")
                    print("-----------send OK")
                    conn.sendall("OK".encode('utf-8'))
                elif fieldsorder[0]=="START":
                    cpu_start, mem_start = getResources(fic_cpu, fic_mem)
                    print("-----------send OK")
                    conn.sendall("OK".encode('utf-8'))
                elif fieldsorder[0]=="STOP":
                    cpu_end, mem_end = getResources(fic_cpu, fic_mem)
                # write cpu and mem used per request
                    print("-----------write: "+fieldsorder[2]+", "+fieldsorder[3] + ", cpu, "+str((cpu_end-cpu_start)/int(fieldsorder[1]))+", mem, "+str((mem_end-mem_start)/int(fieldsorder[1])))
                    fic_stat.write(fieldsorder[2]+", "+fieldsorder[3] + ", cpu, "+str((cpu_end-cpu_start)/int(fieldsorder[1]))+", mem, "+str((mem_end-mem_start)/int(fieldsorder[1]))+"\n")
                    print("-----------send OK")
                    conn.sendall("OK".encode('utf-8'))
                elif fieldsorder[0]=="END":
                    time.sleep(2);
                    fic_stat.close()
                    fic_mem.close()
                    fic_cpu.close()
                    runServer=False
                    print("-----------send OK")
                    conn.sendall("OK".encode('utf-8'))
                    print("Stop IoT STACK")
                    os.kill(pid, signal.SIGKILL)

            
    

                
if __name__ == "__main__":
    main()
