# oneM2M-profiler

The simulation of an IoT infrastructure in terms of equipment, service layer and application require calibration of the inputs of the simulator. The different layers of the model proposed in the ETSI TS 103 840 document have an impact on the overall system. The aim of oneM2M-profiler is to propose a measurement architecture making it possible to extract measurements from particular real execution on given equipment, from a particular oneM2M stack for a particular application. Those measurements should be generalized at the simulator level to give KPIs having values as close as possible to the reality of deployment on other equipment for IoT applications with different configuration and behaviour.

## Struture and protocol for the profiler

The tool is based on two program one call proler and another one called onM2M query generation client. In the initial state, the profiler is executed on a machine and an onM2M query generation client is launched, then the experimental protocol is started:
1. The query generator begins by asking the profiler to launch and start monitoring a particular oneM2M CSE
2. The CSE is executed on the machine
3. The query generator warns the profiler that it must begin its observation on a particular sequence of queries that it will perform on the CSE
4. The profiler launches its observation
5. The query generator executes a set of queries to the CSE
6. The query generator notifies the profiler that the queries on the CSE have been completed and that it can generate the observation statistics of the hardware resources used by the CSE
7. The profiler saves its observations in a file which will be used as input to the simulator
8. When the entire profiling plan is completed, the query generator asks the profiler to stop the CSE
9. The profiler stops the CSE and terminates
10. The query generator ends

## Profiler usage

The installation and configuration process involves both the IoT stack you want to observe, the profiler and the query generator. The first step begins with installing the IoT stack you want to observe on the concerned machine. You must configure it (name of the CSE, address, etc.). Please note that version 1 of query generator only accepts the http protocol.
The second step concerns the installation of the profiler and the query generator to be downloaded from this git. All these programs are written in Python and therefore require the Python interpreter to be installed on the CSE machine and the query generator machine.
The third step concerns the profiler. The profiler program must be put in the directory where the CSE code is located. In version 1 of the profiler only CSEs from the ACME and OM2M distributions are created. Three parameters must be configured in the profiler: the HOST variable specifying the IP address of the profiler, the PORT specifying the port which will be used to communicate with the profiler and the MIPS (million instructions per second) constant for the processor processing capacity in term of MIPS.
The fourth step concerns the configuration of the query generator. The connection with the profiler must be made through the HOST and PORT variables of the generator which must have the same values as the HOST and PORT variables of the profiler. Then you must configure the information concerning the IoT stack through the variables CSE_URL_XXX and ORIGIN_XXX (XXX is to be replaced by the correct IoT stack name) which gives respectively the URL of the CSE and the authentication necessary for connection.
Finally, the last step of configuration concerns the connection with an http server in the case of using the notification mechanism via the HTTTP_SERVEUR variable. For example, the ACME notification server can be used.


## Getting started

The first step is to run the profiler via the command: "python3 profiler.py"
The second step is to run the query generator. Two modes exist:
- Interactive mode: in this mode an interaction with the user allows you to choose the IoT stack, the type of resource, the number of operations to be done on the same type of resources in order to generate averages;
 ```
 python3 oneM2M_Ressources.py manual
 ```
- Automatic mode:  in this mode a pre-defined scenario allows you to create and destroy the most classic oneM2M resources by choosing the stack to execute and the number of requests per resource to generate the statistic.
```
python3 oneM2M_Ressources.py auto [OM2M/ACME/MOBIUS] [number of iterations per test]"
```
These two executions generate in the directory where the profiler is located and on its machine a file with the statistics indexed by the name of the stack.


## Profiler output format

The profiler generates a text file. The format of this text file is:
- a first line gives an information on performance of the machine with indication of MIPS;
- all other lines have the format: type of oneM2M resources, type of action and a list of hardware type and value measured.

The first list of hardware resource on this first version is:
- cpu: average time of processors usage in second;
- mem: average size of memory in bytes.

For example:
```
MIPS 4589
AE,     Create,     cpu, 0.023333333333333428,     mem, 43690.666666666664
AE,     Delete,     cpu, 0.013333333333333345,     mem, 43690.666666666664
CNT,     Create,     cpu, 0.020000000000000018,     mem, 43690.666666666664
SUB,     Create,     cpu, 0.03333333333333336,     mem, 87381.33333333333
```

