var express = require('express');
var path = require('path');
var bodyParser = require('body-parser');
var request = require('request');
var app = express();
var fs = require('fs');
var config = require('./config.json');
var cseUri = config.csePoa+"/~/"+config.cseId+"/"+config.cseName;
const arima = require('arima')

const l = 1
threshold = 0,5

app.use(bodyParser.json())

app.listen(config.aePort, function () {
	console.log('AE Monitor listening on port '+config.aePort);
});


var ts = Array(100).fill(0).map((v,i) => Math.sin(i)+randomNumber(-0.2, 0.2))

app.post('/', function (req, res) {
	console.log("\n◀◀◀◀◀")
	console.log(req.body);
	var content = req.body['m2m:sgn'].nev.rep["m2m:cin"].con;
	//console.log("Content: "+JSON.stringify(content));

	var data= JSON.parse(content);

	console.log(data)
	res.sendStatus(204);

	ts.push(data)
	ts.shift()

	console.log(ts)
	
	const [pred, errors] = arima(ts.slice(0, ts.length-l), l, {
		method: 0,
		optimizer: 6,
		p: 10,
		d: 0,
		q: 1,
		verbose: true
	})

	console.log('Ytrue,Ypred,Err')

	pred.forEach((v, i) => {
		var o = ts[ts.length - l + i];
		var e= errors[i]
		console.log(o + ',' + v + ',' + e)
		var deviation = o - v;

		var jsonCon = {
			"original": o,
			"prediction":v,
			"error":e,
			"deviation":deviation,
			"targetContainer":config.targetCnt
		}

		if(e<1){
			createContenInstance(cseUri+"/"+config.aeName+"/report",jsonCon)
		}
		/*if(deviation>threshold || deviation<-threshold){
			ts[99]=undefined
		}*/
	})
	



});



createAE(cseUri);

function createAE(targetUri){
	console.log("\n▶▶▶▶▶");

	var representation = {
		"m2m:ae":{
			"rn":config.aeName,			
			"api":config.appId,
			"rr":"true",
			"poa":["http://"+config.aeIp+":"+config.aePort+"/"]
		}
	};

	console.log("POST "+targetUri);
	console.log(representation);

	var options = {
		uri: targetUri,
		method: "POST",
		headers: {
			"X-M2M-Origin": config.aeId,
			"X-M2M-RI": "123456",
			"Content-Type": "application/json;ty=2"
		},
		json: representation
	};

	request(options, function (error, response, body) {
		console.log("◀◀◀◀◀");
		if(error){
			console.log(error);
		}else{
			console.log(response.statusCode);
			console.log(body);

			createSubscription(cseUri+config.targetCnt);
			createContainer(targetUri+"/"+config.aeName,"report")
		}
	});
}

function createContainer(targetUri,name){
	console.log("\n▶▶▶▶▶");

	var representation = {
		"m2m:cnt":{
			"rn":name,
			"mni":config.cntMni
		}
	};

	console.log("POST "+ targetUri);
	console.log(representation);

	var options = {
		uri: targetUri,
		method: "POST",
		headers: {
			"X-M2M-Origin": config.aeId,
			"X-M2M-RI": "123456",
			"Content-Type": "application/json;ty=3"
		},
		json: representation
	};

	request(options, function (error, response, body) {
		console.log("◀◀◀◀◀");
		if(error){
			console.log(error);
		}else{
			console.log(response.statusCode);
			console.log(body);
		}
	});
}

function createSubscription(targetUri){
	console.log("\n▶▶▶▶▶");

	var representation = {
		"m2m:sub": {
			"rn": config.subName,
			"nu": ["/"+config.cseName+"/"+config.aeId],
			"nct": 2,
			"enc": {
				"net": [3]
			}
		}
	};

	console.log("POST "+targetUri);
	console.log(representation);

	var options = {
		uri: targetUri,
		method: "POST",
		headers: {
			"X-M2M-Origin": config.aeId,
			"X-M2M-RI": "123456",
			"Content-Type": "application/json;ty=23"
		},
		json: representation
	};

	request(options, function (error, response, body) {
		console.log("◀◀◀◀◀");
		if(error){
			console.log(error);
		}else{
			console.log(response.statusCode);
			console.log(body);

		}
	});
}

function createContenInstance(targetUri,jsonCon){
	console.log("\n▶▶▶▶▶");
	//stringify(jsonCon)
	var representation = {
		"m2m:cin":{
				"con": JSON.stringify(jsonCon)
			}
		};

	console.log("POST "+targetUri);
	console.log(representation);

	var options = {
		uri: targetUri,
		method: "POST",
		headers: {
			"X-M2M-Origin": config.aeId,
			"X-M2M-RI": "123456",
			"Content-Type": "application/json;ty=4"
		},
		json: representation
	};

	request(options, function (error, response, body) {
		console.log("◀◀◀◀◀");
		if(error){
			console.log(error);
		}else{
			console.log(response.statusCode);
			//console.log(body);
		}
	});
}

function randomNumber(min, max) {
	return Math.random() * (max - min) + min;
}

  function difference(a, b) {
	return Math.abs(a - b);
}