/*!
 * \file      xml_converters.hh
 * \brief     Header file for xml_converters functionality.
 * \author    ETSI STF637
 * \copyright ETSI Copyright Notification
 *            No part may be reproduced except as authorized by written permission.
 *            The copyright and the foregoing restriction extend to reproduction in all media.
 *            All rights reserved.
 * \version   0.1
 */
#pragma once

#include <string>

#include <libxml/tree.h>

/**
 * \class xml_converters
 * \brief This class provides XML converters such as canonicalization of XML documents before signature f encryption
 */
class xml_converters {

  static xml_converters *_instance;

private:
  xml_converters() {}; //! Can not be created manually
  static int xml_node_set_contains_callback(void* user_data, xmlNodePtr node, xmlNodePtr parent);
public:
  static inline xml_converters &get_instance();

  virtual ~xml_converters() {
    if (_instance != nullptr)
      delete _instance;
  };

public:
  int xml_canonicalization(const std::string& p_to_canonical, std::string& p_canonicalized) const;

}; // End of class xml_converters

// static functions
xml_converters &xml_converters::get_instance() { return (_instance != nullptr) ? *_instance : *(_instance = new xml_converters()); }

