/*!
 * \file      certs_db_record.cc
 * \brief     Source file for a storage of certificates mechanism.
 * \author    ETSI STF637
 * \copyright ETSI Copyright Notification
 *            No part may be reproduced except as authorized by written permission.
 *            The copyright and the foregoing restriction extend to reproduction in all media.
 *            All rights reserved.
 * \version   0.1
 */

#include <openssl/x509.h>

#include "loggers.hh"

#include "certs_db_record.hh"

certs_db_record::certs_db_record(const std::string& p_certificate_id, X509* p_certificate, EVP_PKEY* p_private_key, const std::string& p_certificate_pem) : _certificate_id(p_certificate_id), _certificate(p_certificate), _private_key(p_private_key), _pem(p_certificate_pem) {
  loggers::get_instance().log(">>> certs_db_record::certs_db_record: p_certificate_id: '%s'", _certificate_id.c_str());
  loggers::get_instance().log(">>> certs_db_record::certs_db_record: p_certificate: '%p'", _certificate_id);
  loggers::get_instance().log(">>> certs_db_record::certs_db_record: p_private_key: '%p'", _private_key);
  loggers::get_instance().log(">>> certs_db_record::certs_db_record: p_private_key: '%s'", _pem);
}

certs_db_record::~certs_db_record() {
  if (_certificate != nullptr) {
    ::X509_free(_certificate);
    ::EVP_PKEY_free(_private_key);
  }
}
