#pragma once

#include <memory>

#include <openssl/err.h>
#include <openssl/pem.h>
#include <openssl/x509.h>

#include "certs_db.hh"

class CHARSTRING;
class OCTETSTRING;


class security_services {
  /*std::unique_ptr<certs_db> _certs_db*/;
  static certs_db* _certs_db;

public: /*! \publicsection */
  /*!
   * \brief Default private ctor
   */
  security_services()/* : _certs_db{nullptr}*/ {};
  /*!
   * \brief Default private dtor
   */
  ~security_services() {
    //_certs_db.reset();
    delete _certs_db;
  };

  int initialize(const std::string& p_certs_db_path);
  int load_certificate(const std::string& p_certificate_name, const std::string& p_private_key_name, const X509** p_certificate);
  /*!
   * \fn int build_path(const std::string& p_root_directory);
   * \brief Set the pass of the certificate storage
   * \param[in] p_db_path The pass of the certificate storage
   */
  int do_sign(const OCTETSTRING& p_encoded_message, const CHARSTRING& p_certificate_name, OCTETSTRING& p_signature, OCTETSTRING& p_digest, CHARSTRING& p_x509_certificate_subject, CHARSTRING& p_x509_certificate_pem);
};