/*!
 * \file      certs_db.hh
 * \brief     Header file for a list of certificates storage mechanism.
 *            It is used to store certificates received from neighbors and not present in the data base
 * \author    ETSI STF637
 * \copyright ETSI Copyright Notification
 *            No part may be reproduced except as authorized by written permission.
 *            The copyright and the foregoing restriction extend to reproduction in all media.
 *            All rights reserved.
 * \version   0.1
 */
#pragma once

#include "certs_cache.hh"

/*!
 * \class certs_db
 * \brief This class provides security record description for security database
 */
class certs_db : public certs_cache {

public: /*! \publicsection */
  /*!
   * \brief Ctor with full path to the certificates storage
   * \param[in] p_db_path The full path to the certificates storage
   */
  certs_db(const std::string& p_db_path);
  /*!
   * \brief Default dtor
   */
  ~certs_db();

  /*!
   * \fn int store_certificate(const std::string& p_certificate_name, const std::string& p_certificate, const EVP_PKEY* p_private_key);
   * \brief Store a new certificate
   * \param[in] p_certificate_name The certificate name
   * \return 0 on success, -1 otherwise
   */
  int store_certificate(const std::string& p_certificate_name, const std::string& p_certificate, const EVP_PKEY* p_private_key);

private: /*! \privatesection */
  /*!
   * \fn int initialize_cache(const std::string& p_db_path);
   * \brief Initialise the storage of certificates mechanism
   * \param[in] p_db_path The full path to the certificates storage
   * \return 0 on success, -1 otherwise
   */
  int initialize_cache(const std::string& p_db_path);
}; // End of class certs_db
