/*!
 * \file      sha1.cc
 * \brief     Source file for SHA-1 helper methods.
 * \author    ETSI STF637
 * \copyright ETSI Copyright Notification
 *            No part may be reproduced except as authorized by written permission.
 *            The copyright and the foregoing restriction extend to reproduction in all media.
 *            All rights reserved.
 * \version   0.1
 */
#include <TTCN3.hh>

#include "sha1.hh"

int sha1::generate(const OCTETSTRING& p_buffer, OCTETSTRING& p_hash) {
  // Sanity check
  if (p_buffer.lengthof() == 0) {
    p_hash = get_sha1_empty_string();
    return 0;
  }

  return generate(static_cast<const uint8_t*>(p_buffer), p_buffer.lengthof(), p_hash);
}

int sha1::generate(const uint8_t* p_buffer, const size_t p_length, OCTETSTRING& p_hash) {
  // Sanity check
  if ((p_buffer == nullptr) || (p_length == 0)) {
    p_hash = get_sha1_empty_string();
    return 0;
  }

  // Resize data buffer
  p_hash = int2oct(0, SHA_DIGEST_LENGTH);
  // Compute the hash value
  ::SHA1_Init(&_ctx);
  ::SHA1_Update(&_ctx, p_buffer, p_length);
  ::SHA1_Final((uint8_t*)static_cast<const uint8_t*>(p_hash), &_ctx);
  return 0;
};
