#include "ip_offline_layer_factory.hh"

#include "loggers.hh"

ip_offline_layer::ip_offline_layer(const std::string&  p_type, const std::string&  p_param) : layer(p_type), _params() {
  loggers::get_instance().log(">>> ip_offline_layer::ip_offline_layer: '%s', %s", to_string().c_str(), p_param.c_str());
  // Setup parameters
  params::convert(_params, p_param);
}

void ip_offline_layer::send_data(OCTETSTRING& p_data, params& p_params) {
  loggers::get_instance().log_msg(">>> ip_offline_layer::send_data: ", p_data);

  //OCTETSTRING ip;
  // FIXME FSCOM: To be done
  loggers::get_instance().error("ip_offline_layer::send_data: Not implemented. On;ly for offline mode");
  //ip    += p_data;
  //send_to_all_layers(ip, static_cast<params&>(p_params));
}

void ip_offline_layer::receive_data(OCTETSTRING& p_data, params& p_params) {
  loggers::get_instance().log_msg(">>> ip_offline_layer::receive_data: ", p_data);

  // Version
  uint8_t v = static_cast<const uint8_t>(*p_data);
  OCTETSTRING version = int2oct(1, v >> 4);
  loggers::get_instance().log_msg("ip_offline_layer::receive_data: verion: ", version);
  // Length in bytes
  uint8_t length = (v & 0x0f) * 4;
  loggers::get_instance().log("ip_offline_layer::receive_data: length: %d", length);
  // DSF
  OCTETSTRING dsf = OCTETSTRING(1, 1 + static_cast<const uint8_t *>(p_data));
  loggers::get_instance().log_msg("ip_offline_layer::receive_data: dsf: ", dsf);
  // Total Length
  OCTETSTRING total_length = OCTETSTRING(2, 2 + static_cast<const uint8_t*>(p_data));
  loggers::get_instance().log_msg("ip_offline_layer::receive_data: total_length: ", total_length);
  // Identification
  OCTETSTRING id = OCTETSTRING(2, 4 + static_cast<const uint8_t*>(p_data));
  loggers::get_instance().log_msg("ip_offline_layer::receive_data: id: ", id);
  // Flags 
  OCTETSTRING flags = OCTETSTRING(2, 6 + static_cast<const uint8_t*>(p_data));
  loggers::get_instance().log_msg("ip_offline_layer::receive_data: id: ", flags);
  // TTL 
  OCTETSTRING ttl = OCTETSTRING(1, 8 + static_cast<const uint8_t*>(p_data));
  loggers::get_instance().log_msg("ip_offline_layer::receive_data: ttl: ", ttl);
  // Protocol 
  OCTETSTRING protocol = OCTETSTRING(1, 9 + static_cast<const uint8_t*>(p_data));
  loggers::get_instance().log_msg("ip_offline_layer::receive_data: protocol: ", protocol);
  // checksum 
  OCTETSTRING checksum = OCTETSTRING(2, 10 + static_cast<const uint8_t*>(p_data));
  loggers::get_instance().log_msg("ip_offline_layer::receive_data: checksum: ", checksum);
  // src 
  OCTETSTRING src = OCTETSTRING(4, 12 + static_cast<const uint8_t*>(p_data));
  loggers::get_instance().log_msg("ip_offline_layer::receive_data: src: ", src);
  // dst 
  OCTETSTRING dst = OCTETSTRING(4, 16 + static_cast<const uint8_t*>(p_data));
  loggers::get_instance().log_msg("ip_offline_layer::receive_data: dst: ", dst);

  OCTETSTRING data = OCTETSTRING(p_data.lengthof() - length, length + static_cast<const uint8_t *>(p_data));
  loggers::get_instance().log_msg("ip_offline_layer::receive_data: payload for upper layer:", data);

  // Update params
  CHARSTRING s = oct2str(dst);
  p_params.insert(std::pair<std::string, std::string>(params::ip_dst, std::string(static_cast<const char *>(s))));
  s = oct2str(src);
  p_params.insert(std::pair<std::string, std::string>(params::ip_src, std::string(static_cast<const char *>(s))));
  s = oct2str(protocol);
  p_params.insert(std::pair<std::string, std::string>(params::ip_proto, std::string(static_cast<const char *>(s))));

  receive_to_all_layers(data, static_cast<params&>(p_params));
}

ip_offline_layer_factory ip_offline_layer_factory::_f;
