#include "certs_db.hh"

#include "params.hh"
#include "loggers.hh"
#include "converter.hh"

using namespace std; // Required for isnan()
#include "certs_loader.hh"

certs_db::certs_db(const std::string& p_db_path) {
  loggers::get_instance().log(">>> certs_db::certs_db: '%s'", p_db_path.c_str());

  initialize_cache(p_db_path);
  loggers::get_instance().log("<<< certs_db::certs_db");
} // End of ctor

certs_db::~certs_db() { loggers::get_instance().log(">>> certs_db::~certs_db"); } // End of dtor

int certs_db::initialize_cache(const std::string& p_db_path) {
  loggers::get_instance().log(">>> certs_db::initialize_cache: '%s'", p_db_path.c_str());

  certs_loader::get_instance().build_path(p_db_path);

  loggers::get_instance().log("<<< certs_db::initialize_cache");
  return 0;
}
