#include <math.h>
#include <sstream>
#include <iomanip>
#include <random>

#include "LibHelpers_Functions.hh"

#include "base_time.hh"
#include "converter.hh"
#include "loggers.hh"
#include "xml_converters.hh"

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif
#define earthRadius 6378137.0L
#define rbis = ((double)(earthRadius * M_PI / 180))

namespace LibHelpers__Functions {

  /**
   * @desc    This external function gets the current time since 01/01/1970 in UTC format
   * @return  The current time since 01/01/1970 in UTC format in milliseconds
   * @see     fx_getCurrentTimeUtc() return UInt64
   */
  INTEGER fx__getCurrentTimeUtc() {
    INTEGER i;
    i.set_long_long_val(base_time::get_instance().get_current_time_ms());
    loggers::get_instance().log_msg("<<< fx__getCurrentTimeUtc: ", i);
    return i;
  }
  /**
   * @desc    Gets the Minute of current UTC year
   * @return  MinuteOfTheYear - tenths of a second in the current or next hour in units of 1/10th second from UTC time
   * @see     function f_getMinuteOfTheYear() return MinuteOfTheYear
   */
  INTEGER fx__getMinuteOfTheYear() {
    //	TODO: this is just a skeleton. fill in the function
    return 0;
  }

  /**
   * @desc    Gets the milliseconds point in the current UTC minute
   * @return  DSecond - The milliseconds point in the current UTC minute (0..60000)
   * @see     function f_getDSecond() return DSecond
   */
  INTEGER fx__getDSecond() {
    //	TODO: this is just a skeleton. fill in the function
    return 0;
  }

  /**
   * @desc    Encode into Base64
   * @return  p_to_encode - The buffer to be encoded
   * @see     function f_enc_base64(in octetstring p_to_encode) return octetstring
   */
  OCTETSTRING fx__enc__base64(const OCTETSTRING& p_to_encode) {
    loggers::get_instance().log_msg(">>> fx__enc__base64: ", p_to_encode);

    const std::vector<unsigned char> to_encode(static_cast<const unsigned char*>(p_to_encode), static_cast<const unsigned char*>(p_to_encode) + p_to_encode.lengthof());
    std::vector<unsigned char> b64 = converter::get_instance().buffer_to_base64(to_encode);
    OCTETSTRING os(b64.size(), b64.data());
    loggers::get_instance().log_msg("<<< fx__enc__base64: ", os);
    return os;
  }

  /**
   * @desc    Decode from Base64
   * @return  p_to_decode - The buffer to be decoded
   * @see     function f_dec_base64(in octetstring p_to_decode) return octetstring
   */
  OCTETSTRING fx__dec__base64(const OCTETSTRING& p_to_decode) {
    loggers::get_instance().log_msg(">>> fx__dec__base64: ", p_to_decode);

    const std::vector<unsigned char> to_decode(static_cast<const unsigned char*>(p_to_decode), static_cast<const unsigned char*>(p_to_decode) + p_to_decode.lengthof());
    std::vector<unsigned char> b64 = converter::get_instance().base64_to_buffer(to_decode);
    OCTETSTRING os(b64.size(), b64.data());
    loggers::get_instance().log_msg("<<< fx__dec__base64: ", os);
    return os;
  }

  static unsigned char random_char() {
    std::random_device rd;
    std::mt19937 gen(rd()); 
    std::uniform_int_distribution<> dis(0, 255);
    return static_cast<unsigned char>(dis(gen));
  }

  static std::string generate_hex(const unsigned int len) {
    std::stringstream ss;
    for(auto i = 0; i < len; i++) {
      auto rc = random_char();
      std::stringstream hexstream;
      hexstream << std::hex << int(rc);
      auto hex = hexstream.str(); 
      ss << (hex.length() < 2 ? '0' + hex : hex);
    }    
    return ss.str();
  }

  /**
   * @brief Generate a new UUID
   * @return The UUID in string format on success, a null string otherwise 
   */
  CHARSTRING fx__generate__uuid() { // ddb848c4-f7fd-445f-bdc8-033d15d7c528
    loggers::get_instance().log(">>> fx__generate__uuid");

    std::stringstream ss;
    ss << generate_hex(6) << "-";
    ss << generate_hex(2) << "-";
    ss << generate_hex(2) << "-";
    ss << generate_hex(2) << "-";
    ss << generate_hex(6);

    CHARSTRING uuid(ss.str().c_str());
    loggers::get_instance().log_msg("fx__generate__uuid: ", uuid);
    return uuid;
  }

  /**
   * @brief Retrieve the current local date/time formatted as yyyy-mm-ddThh:mm:ss.lll+nn:00
   * @return The the current date/time on success, a null string otherwise 
   */
  CHARSTRING fx__get__current__date__time(const INTEGER& p__shift__time) { //2018-01-18T13:19:35.367+01:00
    loggers::get_instance().log(">>> fx__get__current__date__time");

    time_t t = std::time(nullptr);
    if (p__shift__time != 0) {
      t += static_cast<int>(p__shift__time);
    }
    auto tm = *std::localtime(&t);
    std::ostringstream oss;
    oss << std::put_time(&tm, "%FT%TZ");//%FT%T%Z

    CHARSTRING dt(oss.str().c_str());
    loggers::get_instance().log_msg("fx__get__current__date__time: ", dt);
    return dt;
  }

  /**
   * @brief Retrieve the local date/time in the past formatted as yyyy-mm-ddThh:mm:ss.lll+nn:00
   * @return The the current date/time on success, a null string otherwise 
   */
  CHARSTRING fx__get__current__date__time__past() { //2018-01-18T13:19:35.367+01:00
    loggers::get_instance().log(">>> fx__get__current__date__time");

    time_t t = std::time(nullptr);
    auto tm = *std::localtime(&t);
    std::ostringstream oss;
    oss << std::put_time(&tm, "%FT%TZ");//%FT%T%Z

    CHARSTRING dt(oss.str().c_str());
    loggers::get_instance().log_msg("fx__get__current__date__time: ", dt);
    return dt;
  }

} // namespace LibHelpers__Functions
