/*!
 * \file      sctp_offline_layer.hh
 * \brief     Header file for offline Sctp layer.
 * \author    ETSI TTF T041
 * \copyright ETSI Copyright Notification
 *            No part may be reproduced except as authorized by written permission.
 *            The copyright and the foregoing restriction extend to reproduction in all media.
 *            All rights reserved.
 * \version   0.1
 */
#pragma once

#include "params.hh"
#include "t_layer.hh"

#include <Octetstring.hh>

/*!
 * \class sctp_offline_layer
 * \brief  This class provides description of offline Sctp layer protocol layer
 */
class sctp_offline_layer : public layer {
  params       _params; //! Layer parameters

  params      _o_params;
  OCTETSTRING _o_data;

  std::string _time_key;

  static void *run(void *p_this);

public:
  void *thread(void);

public: //! \publicsection
  /*!
   * \brief Specialised constructor
   *        Create a new instance of the sctp_offline_layer class
   * \param[in] p_type \todo
   * \param[in] p_param \todo
   */
  sctp_offline_layer(const std::string& p_type, const std::string& param);
  /*!
   * \brief Default destructor
   */
  virtual ~sctp_offline_layer();

  /*!
   * \virtual
   * \fn void send_data(OCTETSTRING& data, params& params);
   * \brief Send bytes formated data to the lower layers
   * \param[in] p_data The data to be sent
   * \param[in] p_params Some parameters to overwrite default value of the lower layers parameters
   */
  virtual void send_data(OCTETSTRING &p_data, params &p_params);
  /*!
   * \virtual
   * \fn void receive_data(OCTETSTRING& data, params& params);
   * \brief Receive bytes formated data from the lower layers
   * \param[in] p_data The bytes formated data received
   * \param[in] p_params Some lower layers parameters values when data was received
   */
  virtual void receive_data(OCTETSTRING &p_data, params &p_params);

private: //! \privatesection
  /*!
   * \fn void process_chunk(const OCTETSTRING& p_chunk, OCTETSTRING& p_payload);
   * \brief Process SCTP chunk and extrat the payload if the chunck is of DATA type
   * \param[in] p_data The bytes formated data received
   * \param[inout] p_params Some lower layers parameters values when data was received
   * \param[out] p_payload The payload if the chunck is of DATA type, unchanged otherwise
   */
  void process_chunk(const OCTETSTRING& p_chunk, params &p_params, OCTETSTRING& p_payload);

  void Handle_Fd_Event_Readable(int fd);
};
