#pragma once

#include <memory>

#include "codec_gen.hh"
#include "params.hh"

class Base_Type;
class Record_Type;
class TTCN_Typedescriptor_t;
class TTCN_Buffer;
class OCTETSTRING;

namespace LibHttp__TypesAndValues {
  class HttpMessage;
  class Request;
  class Response;
  class Headers;
  class Header;
} // namespace LibHttp__TypesAndValues
namespace LibHttp__MessageBodyTypes {
  class HttpMessageBody;
} // namespace LibHttp__MessageBodyTypes
namespace LibHttp__BinaryMessageBodyTypes {
  class BinaryBody;
} // namespace LibHttp__BinaryMessageBodyTypes
namespace LibHttp__XmlMessageBodyTypes {
  class XmlBody;
} // namespace LibHttp__XmlMessageBodyTypes
namespace LibHttp__JsonMessageBodyTypes {
  class JsonBody;
} // namespace LibHttp__JsonMessageBodyTypes

struct encoding_context {
  unsigned int  length;
  uint8_t is_content_length_present;

  encoding_context() { reset(); };
  void reset() {
    length                    = -1;
    is_content_length_present = 0x00;
  };
};

struct decoding_context {
  unsigned int  length;
  uint8_t is_binary;
  bool          chunked;

  decoding_context() { reset(); };
  void reset() {
    length    = -1;
    is_binary = 0x00;
    chunked   = false;
  };
};

class http_codec : public codec_gen<LibHttp__TypesAndValues::HttpMessage, LibHttp__TypesAndValues::HttpMessage> {
  encoding_context                                                        _ec;
  decoding_context                                                        _dc;

protected:
  std::map<std::string, std::unique_ptr<codec_gen<Record_Type, Record_Type>>> _codecs;
  std::vector<OCTETSTRING> _bufferized_buffers;
  unsigned int             _initial_content_length;
  unsigned int             _current_content_length;

public:
  explicit http_codec() : codec_gen<LibHttp__TypesAndValues::HttpMessage, LibHttp__TypesAndValues::HttpMessage>(), _ec(), _dc(), _codecs(), _bufferized_buffers(), _initial_content_length{0}, _current_content_length{0} {};
  virtual ~http_codec(){};

  virtual int encode(const LibHttp__TypesAndValues::HttpMessage &, OCTETSTRING &data);
  virtual int decode(const OCTETSTRING &data, LibHttp__TypesAndValues::HttpMessage &, params *params = NULL);

  void set_payload_codecs(const std::string& p_codecs);

protected: //! \protectedsection
  virtual bool encode_body_binary(const LibHttp__BinaryMessageBodyTypes::BinaryBody &p_binary_body, OCTETSTRING &p_encoding_buffer, const std::string& p_content_type) {return false;};
  virtual bool decode_body_binary(const OCTETSTRING &p_data, LibHttp__BinaryMessageBodyTypes::BinaryBody &p_binary_body, const std::string& p_content_type) {return false;};

  virtual bool encode_body_xml(const LibHttp__XmlMessageBodyTypes::XmlBody &p_xml_body, OCTETSTRING &p_encoding_buffer, const std::string& p_content_type) {return false;};
  virtual bool decode_body_xml(const OCTETSTRING &p_data, LibHttp__XmlMessageBodyTypes::XmlBody &p_body, const std::string& p_content_type, params* p_params) {return false;};

  virtual bool encode_body_html(const CHARSTRING &p_html_body, OCTETSTRING &p_encoding_buffer, const std::string& p_content_type) {return false;};
  virtual bool decode_body_html(const OCTETSTRING &p_data, CHARSTRING &p_html_body, const std::string& p_content_type, params* p_params);

  virtual bool encode_body_json(const LibHttp__JsonMessageBodyTypes::JsonBody &p_json_body, OCTETSTRING &p_encoding_buffer, const std::string& p_content_type) {return false;};
  virtual bool decode_body_json(const OCTETSTRING &p_data, LibHttp__JsonMessageBodyTypes::JsonBody &p_json_body, const std::string& p_content_type, params* p_params) {return false;};

private:
  int encode_request(const LibHttp__TypesAndValues::Request &p_request, TTCN_Buffer &p_encoding_buffer);
  int encode_response(const LibHttp__TypesAndValues::Response &p_response, TTCN_Buffer &p_encoding_buffer);
  int encode_body(const LibHttp__MessageBodyTypes::HttpMessageBody &p_message_body, OCTETSTRING &p_encoding_buffer, const std::string& p_content_type);

  int decode_headers(TTCN_Buffer &decoding_buffer, LibHttp__TypesAndValues::Headers &headers, std::string& p_content_type);
  int decode_header(CHARSTRING &header_line, LibHttp__TypesAndValues::Header &header);
  int decode_body(TTCN_Buffer &decoding_buffer, LibHttp__MessageBodyTypes::HttpMessageBody &message_body, const std::string& p_content_type);
  int get_line(TTCN_Buffer &buffer, CHARSTRING &to, const bool concatenate_header_lines = false);

}; // End of class http_codec
