//
// This file is a part of UERANSIM open source project.
// Copyright (c) 2021 ALİ GÜNGÖR.
//
// The software and all associated files are licensed under GPL-3.0
// and subject to the terms and conditions defined in LICENSE file.
//

#include "client.hh"
#include "internal.hh"

#include "loggers.hh"

sctp::SctpClient::SctpClient(PayloadProtocolId ppid, sctp_layer* sl) :  sd(CreateSocket()), ppid(ppid), sl(sl)
{
    try
    {
        SetInitOptions(sd, 10, 10, 10, 10 * 1000);
        SetEventOptions(sd);
    }
    catch (const std::exception &e)
    {
        CloseSocket(sd);
        throw;
    }
//	 loggers::get_instance().log(">>> client::client: %d",sd);
}

sctp::SctpClient::~SctpClient()
{
    CloseSocket(sd);
}

void sctp::SctpClient::connect(const std::string &address, uint16_t port) const
{
    Connect(sd, address, port);
}

void sctp::SctpClient::send(uint16_t stream, const uint8_t *buffer, size_t offset, size_t length)
{
    SendMessage(sd, buffer + offset, length, (int)ppid, stream);
}

void sctp::SctpClient::send(uint16_t stream, const uint8_t *buffer, size_t length)
{
    send(stream, buffer, 0, length);
}

void sctp::SctpClient::send( const uint8_t *buffer, size_t length)
{
//	 loggers::get_instance().log(">>> client::send: %d",sd);

    send(sd, buffer, 0, length);
}

void sctp::SctpClient::send(uint16_t stream, const std::vector<uint8_t> &data)
{
    send(stream, data.data(), data.size());
}


//void sctp::SctpClient::receive(ISctpHandler *handler)
void sctp::SctpClient::receive()
{
//     loggers::get_instance().log(">>> client::receive: %d",sd);
    //ReceiveMessage(sd, static_cast<uint32_t>(ppid), handler);
    ReceiveMessage(sd, static_cast<uint32_t>(ppid),sl);
}

[[noreturn]]  void sctp::SctpClient::ReceiverThread(sctp::SctpClient* client)

//[[noreturn]] static void ReceiverThread(std::pair<sctp::SctpClient *, sctp_layer *> *args)	
{
  //  sctp::SctpClient *client = args->first;
  //  sctp_layer *handler = args->second;

    //delete args;

    while (true)
       // receive();
       client->receive();
}

void sctp::SctpClient::bind(const std::string &address, uint16_t port)
{
//	 loggers::get_instance().log(">>> client::bind: %d",sd);
    BindSocket(sd, address, port);
}
