/*!
 * \file      layer_factory.hh
 * \brief     Header file for ITS abstract protocol layer definition.
 * \author    ETSI STF525
 * \copyright ETSI Copyright Notification
 *            No part may be reproduced except as authorized by written permission.
 *            The copyright and the foregoing restriction extend to reproduction in all media.
 *            All rights reserved.
 * \version   0.1
 */
#pragma once

#include <algorithm>
#include <map>
#include <string>
#include <vector>

#include "layer.hh"

/*!
 * \class layer_factory
 * \brief  This class provides a factory class to create layer class instances
 * \abstract
 */
class layer_factory {
public: //! \publicsection
  /*!
   * \fn codec();
   * \brief  Default constructor
   */
  layer_factory(){};
  /*!
   * \fn layer* create_layer(const std::string&  type, const std::string&  param);
   * \brief  Create the layers stack based on the provided layers stack description (cf. remark)
   * \param[in] p_type The provided layers stack description
   * \param[in] p_params Optional parameters
   * \return 0 on success, -1 otherwise
   * \remark The description below introduces layers stack in case of ITS project:
   *     Ethernet layer
   *       mac_src  :Source MAC address
   *       mac_bc   :Broadcast address
   *       eth_type : Ethernet type
   *     UDP layer (IP/UDP based on Pcap)
   *       dst_ip  : destination IPv4 address (aa.bb.cc.dd)
   *       dst_port: destination port
   *       src_ip  : source IPv4 address (aa.bb.cc.dd)
   *       src_port: source port
   *     Pcap layer
   *       mac_src    : Source MAC address, used to exclude from capture the acket sent by the Test System
   *       filter     : Pcap filter (compliant with tcpdump syntax)
   *                    E.g. filter=and ether src 04e548000001
   *       Online mode:
   *         nic: Local NIC
   *              If set, online mode is used
   *       Offline mode (nic is present but not set):
   *         file        : File to read
   *         frame_offset: Frame offset, used to skip packets with frame number < frame_offset
   *         time_offset : Time offset, used to skip packets with time offset < time_offset
   *         save_mode   : 1 to save sent packet, 0 otherwise
   * \pure
   */
  virtual layer *create_layer(const std::string& p_type, const std::string& p_params) = 0;
}; // End of class layer_factory
