#pragma once

#include <memory>

#include <openssl/err.h>
#include <openssl/pem.h>
#include <openssl/x509.h>

#include "certs_db.hh"

class CHARSTRING;
class OCTETSTRING;


class security_services {
  /*std::unique_ptr<certs_db> _certs_db*/;
  static certs_db* _certs_db;

public: /*! \publicsection */
  /*!
   * \brief Default private ctor
   */
  security_services()/* : _certs_db{nullptr}*/ {};
  /*!
   * \brief Default private dtor
   */
  ~security_services() {
    //_certs_db.reset();
    delete _certs_db;
  };

  int initialize(const std::string& p_certs_db_path);
  /*!
   * \fn int load_certificate(const std::string& p_certificate_name, const std::string& p_private_key_name, const std::string& p_private_key_passwd, std::map<std::string, std::unique_ptr<const certs_db_record>> & p_certificates);
   * \brief Store in memory the specified certificate
   * \param[in] p_certificate_name The certificate full path bame
   * \param[in] p_private_key_name The certificate's private key full path name, in PKCS#8 format
   * \param[in] p_private_key_passwd The certificate's private key password for PKCS#8 format encryption. Empty if no encryption
   * \param[out] p_certificate_id The certificate identifier
   * \param[inout] p_certificates The map of the loaded in memory certificates
   * \return 0 on success, -1 otherwise
   */
  int load_certificate(const std::string& p_certificate_name, const std::string& p_private_key_name, const std::string& p_private_key_passwd, const X509** p_certificate);
  /*!
   * \fn int do_sign(const OCTETSTRING& p_encoded_message, const CHARSTRING& p_certificate_name, const CHARSTRING& p_private_key_name, const CHARSTRING& p_private_key_passwd, OCTETSTRING& p_signature, OCTETSTRING& p_digest, CHARSTRING& p_x509_certificate_subject, CHARSTRING& p_x509_certificate_pem);
   * \brief Sign message
   * \param[in] p_encoded_message The raw message to be signed
   * \param[in] TODO The raw message to be signed
   * \return 0 on success, -1 otherwise
   */
  int do_sign(const OCTETSTRING& p_encoded_message, const OCTETSTRING& p_empty_signature, const CHARSTRING& p_certificate_name, const CHARSTRING& p_private_key_name, const CHARSTRING& p_private_key_passwd, OCTETSTRING& p_signature, OCTETSTRING& p_digest, CHARSTRING& p_x509_certificate_subject, CHARSTRING& p_x509_certificate_pem, CHARSTRING& p_pull_request_canonicalized);
  /*!
   * \fn int build_path(const std::string& p_root_directory);
   * \brief Verify message signature
   * \param[in] p_message The raw message to be verified
   * \param[in] TODO
   * \return true on success, false otherwise
   */
  bool do_sign_verify(const CHARSTRING& p_message, const OCTETSTRING& p_empty_signature, const UNIVERSAL_CHARSTRING& p_canonicalization_method, const UNIVERSAL_CHARSTRING& p_signature_method, const UNIVERSAL_CHARSTRING& p_digest_method, const UNIVERSAL_CHARSTRING& p_digest_value, const UNIVERSAL_CHARSTRING& p_signature_value, const UNIVERSAL_CHARSTRING& p_subject_name, const UNIVERSAL_CHARSTRING& p_certificate, CHARSTRING& p_debug_message);
};