"""
Contains utility class `TestEntry`
"""

class TestEntry:
    """
    Models a single entry (row) in the resulting xlsx file.

    Contains all the relevant information about a single test:
        id:             Test ID
        name:           Test Name
        result:         PASS/FAIL
        error_message:  In case of FAIL, contains reason
        robot_file:     Robot file containing the test
    """
    def __init__(self, test_id, name, status, test_info):
        self.test_id = test_id
        self.name = name
        self.result = status[0]
        self.error_message = status[1]
        self.api = test_info[0]
        self.robot_file = test_info[1]

    def __str__(self):
        base_str = "[{}] {}:{}".format(self.test_id, self.name, self.result)
        if self.error_message != "":
            return "{}: {} ({}/{})".format(base_str, self.error_message, self.api, self.robot_file)

        return base_str

    def __repr__(self):
        return "{}: {}".format(self.name, self.result)

    def as_list(self):
        """
        Construct a list-representation of the entry
        """
        return [self.test_id, self.name, self.result, self.error_message, self.api, self.robot_file]
