class TestEntry:
    def __init__(self, id, name, result, errorMsg=""):
        self.id = id
        self.name = name
        self.result = result
        self.errorMsg = errorMsg
    
    def __str__(self):
        baseStr = "[{}] {}:{}".format(self.id, self.name, self.result)
        if self.errorMsg != "":
            return "{}: {}".format(baseStr, self.errorMsg)
        else:
            return baseStr
    
    def __repr__(self):
        return "{}: {}".format(self.name, self.result)
    
    def asList(self):
        return [self.id, self.name, self.result, self.errorMsg]