#
# ARF - Augmented Reality Framework (ETSI ISG ARF)
#
# Copyright 2024 ETSI
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http:#www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Last change: Mai 2024
#

import time
import openapi_client
from openapi_client.api import default_api
from pprint import pprint

# recommended to create enviroment
# conda create -n openapi
# conda activate openapi
# to install the World Storage OpenAPI: cd to /CHANGE_PATH/generated folder, and then run "pip install ."

# then to run, activate first enviroment:
# conda activate openapi
# and then run python script:
# python <this script>.py


# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host="https://etsi.hhi.fraunhofer.de/"
)

print()
print("ETSI ISG - ARF World Storage")
print()
print("Simple request tests")
print("====================")
print()
print("Using WS server" + configuration.host)
print()

success = 0

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = default_api.DefaultApi(api_client)

    # example, this endpoint has no required or optional parameters
    try:
        # Test the server availability.
        api_response = api_instance.get_ping()
        print("Sending 'ping', got response: " + api_response)
        success += 1
    except openapi_client.ApiException as e:
        print("Exception when calling DefaultApi->get_ping: %s\n" % e)

    # example, this endpoint has no required or optional parameters
    try:
        # Test the server availability.
        api_response = api_instance.get_version()
        print("Sending 'version', got response: " + api_response)
        success += 1
    except openapi_client.ApiException as e:
        print("Exception when calling DefaultApi->get_ping: %s\n" % e)

    # example, this endpoint has no required or optional parameters
    try:
        # Test the server availability.
        api_response = api_instance.get_admin()
        print("Sending 'admin', got response: " + api_response)
        success += 1
    except openapi_client.ApiException as e:
        print("Exception when calling DefaultApi->get_ping: %s\n" % e)

if success == 3:
    print ("Connection was succesfull.")
else:
    print ("Connection was not succesfull!")

