*This repository is part of the outcomes of the Specialist Task Force 669 focusing on the communication between a World Analysis and World Representation components as part of the ETSI ISG Augmented Reality Framework architecture (https://www.etsi.org/deliver/etsi_gs/ARF/001_099/003/01.01.01_60/gs_ARF003v010101p.pdf).*
*The set of the World Representation authoring components includes:*

*•	The Python, C++ and C# source code for servers and clients generated from OpenAPI available here (https://forge.etsi.org/rep/arf/arf005)*

*•	A Unity plugin and a Unity editor for authoring and accessing a World Representation hosted on a World Storage server.*

*All these components are available under the ETSI Labs group “World Storage API Helpers”: https://labs.etsi.org/rep/arf/world-storage-api-helpers*

*If you wish to contribute to this project or any other projects in the context of the [ETSI ISG Augmented Reality Framework architecture](https://www.etsi.org/committee/1420-arf), please refer to the ["How to get involved in an ISG" section on the ETSI website](https://www.etsi.org/how-to-get-involved-in-an-isg)*

---

# Description

This repo should be used to construct a Python server compliant to the ARF World Storage API. It uses auto-generated python server code. We propose to use the open source OpenAPI-Generator for this.


## Repo Content

|   |  Files / Folders |                                                                                    Description                                                                                    |
|:-:|:--------------:|:---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|
| 📂 | openapi         | A git submodule (ForgeETSI ) pointing to the repo containing the API specification file                                                                                                |
| 📂 | client  | The folder where the python code will be generated, the openapi generator is set to not overwrite some files used to test the client system |
| 📂 | client/ETSI-ARF  | Folder with a python script to test the availibility of a World Storage  |

## Requirements

What you need:

1.	Installed npm: https://phoenixnap.com/kb/install-node-js-npm-on-windows
2.	Installed openapi generator with npm: https://openapi-generator.tech/docs/installation/
3.	Optional: Installed docker (recommanded): https://www.docker.com/get-started 

# Code Generation

We provide the file `.openapi-generator-ignore` in `client`, which prevents openapi-generator to override some adapted files.

## Auto-generate client code

Use/define following setup for the config file `openapitools.json`:

```
{
  "$schema": "node_modules/@openapitools/openapi-generator-cli/config.schema.json",
  "spaces": 2,
  "generator-cli": {
    "version": "5.3.0",
    "generators":{
      "v1.1": {
     "generatorName": "python",
     "output": "./client",
     "inputSpec": "./openapi/API/worldstorage/worldstorageopenapi.yaml",
     "additionalProperties": {
      }
     }
    }
  }
}
```

Open a command shell and execute:
```
  npx openapi-generator-cli generate
```

## Installing the python module on your local computer

It's recommended to create the enviroment with conda (if available)

```
conda create -n openapi
conda activate openapi
```

Install the World Storage OpenAPI:

```
cd client\generated
pip install .
```

## Running the test script

If using conda, activate first enviroment:
```
conda activate openapi
```

Run python script with:
```
cd client\ETSI-ARF
python WorldServerTest.py
```