//
// ARF - Augmented Reality Framework (ETSI ISG ARF)
//
// Copyright 2022 ETSI
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Last change: June 2022
//

#ifndef WORLDSTORAGEMANAGER_H_
#define WORLDSTORAGEMANAGER_H_

#include <string>
#include <list>
#include <mutex>
#include <map>
#include <Trackable.h>
#include <boost/uuid/uuid.hpp>
#include <boost/uuid/uuid_generators.hpp> 

/**
 * The WorldStorageManager class defines the `GetInstance` method that serves as an
 * alternative to constructor and lets clients access the same instance of this
 * class over and over.
 */
class WorldStorageManager
{

    /**
     * The WorldStorageManager's constructor/destructor should always be private to
     * prevent direct construction/desctruction calls with the `new`/`delete`
     * operator.
     */
private:
    static WorldStorageManager * pinstance_;
    static std::mutex mutex_;
    std::map<boost::uuids::uuid, org::openapitools::server::model::Trackable> m_trackableMap;

protected:
    WorldStorageManager() {}
    ~WorldStorageManager() {}

public:
    /**
     * WorldStorageManagers should not be cloneable.
     */
    WorldStorageManager(WorldStorageManager &other) = delete;
    /**
     * WorldStorageManagers should not be assignable.
     */
    void operator=(const WorldStorageManager &) = delete;
    /**
     * This is the static method that controls the access to the singleton
     * instance. On the first run, it creates a singleton object and places it
     * into the static field. On subsequent runs, it returns the client existing
     * object stored in the static field.
     */

    static WorldStorageManager *GetInstance();
    
    boost::uuids::uuid addTrackable(org::openapitools::server::model::Trackable trackable);
    void deleteTrackable(boost::uuids::uuid trackableId);
    std::list<org::openapitools::server::model::Trackable> getTrackables();
    org::openapitools::server::model::Trackable getTrackableById(boost::uuids::uuid trackableId);
};

#endif
