//
// ARF - Augmented Reality Framework (ETSI ISG ARF)
//
// Copyright 2022 ETSI
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Last change: June 2022
//

#include "WorldStorageManager.h"
#include <thread>
#include <iostream>

/**
 * The first time we call GetInstance we will lock the storage location
 *      and then we make sure again that the variable is null and then we
 *      set the value. RU:
 */
WorldStorageManager *WorldStorageManager::GetInstance()
{
    std::lock_guard<std::mutex> lock(mutex_);
    if (pinstance_ == nullptr)
    {
        pinstance_ = new WorldStorageManager();
    }
    return pinstance_;
}

boost::uuids::uuid WorldStorageManager::addTrackable(org::openapitools::server::model::Trackable trackable){
    boost::uuids::uuid trackableId = boost::uuids::random_generator()();
    m_trackableMap.insert(std::make_pair(trackableId, trackable));
    return trackableId;
}
    
void WorldStorageManager::deleteTrackable(boost::uuids::uuid trackableId){
    m_trackableMap.erase(trackableId);
}
    
std::list<org::openapitools::server::model::Trackable> WorldStorageManager::getTrackables(){
    std::list<org::openapitools::server::model::Trackable> ret;
    std::map<boost::uuids::uuid, org::openapitools::server::model::Trackable>::iterator it;
    for (it = m_trackableMap.begin(); it != m_trackableMap.end(); it++)
    {        
        ret.push_back(it->second);
    }
    return ret;
}
    
org::openapitools::server::model::Trackable WorldStorageManager::getTrackableById(boost::uuids::uuid trackableId){
    auto ret = m_trackableMap.find(trackableId);
    return ret->second;
}

/**
 * Static methods should be defined outside the class.
 */

WorldStorageManager* WorldStorageManager::pinstance_{nullptr};
std::mutex WorldStorageManager::mutex_;
