//
// ARF - Augmented Reality Framework (ETSI ISG ARF)
//
// Copyright 2022 ETSI
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Last change: June 2022
//

#ifndef TrackableApiEtsi_H_
#define TrackableApiEtsi_H_



#include <pistache/endpoint.h>
#include <pistache/http.h>
#include <pistache/router.h>
#include <memory>
#include <optional>
#include <WorldStorageManager.h>
#include <TrackablesApi.h>

namespace etsi
{
using namespace org::openapitools::server::model;

class TrackableApiEtsi : public org::openapitools::server::api::TrackablesApi {
public:
    explicit TrackableApiEtsi(const std::shared_ptr<Pistache::Rest::Router>& rtr);
    ~TrackableApiEtsi() override = default;

    void add_trackable(const Trackable &trackable, Pistache::Http::ResponseWriter &response);
    void delete_trackable(const std::string &trackableId, Pistache::Http::ResponseWriter &response);
    void get_trackable_by_id(const std::string &trackableId, Pistache::Http::ResponseWriter &response);
    void get_trackables(Pistache::Http::ResponseWriter &response);
    
private:
    WorldStorageManager *m_manager;
};
}

#endif
