//
// ARF - Augmented Reality Framework (ETSI ISG ARF)
//
// Copyright 2022 ETSI
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Last change: June 2022
//

#include "TrackableApiEtsi.h"
#include <boost/uuid/uuid.hpp>
#include <boost/lexical_cast.hpp>
#include <boost/uuid/uuid_io.hpp>
#include <pistache/http.h>
#include <nlohmann/json.hpp>

namespace etsi {

using json = nlohmann::json;
using namespace org::openapitools::server::model;

TrackableApiEtsi::TrackableApiEtsi(const std::shared_ptr<Pistache::Rest::Router>& rtr)
    : TrackablesApi(rtr)
{
    m_manager = WorldStorageManager::GetInstance();
}

void TrackableApiEtsi::add_trackable(const Trackable &trackable, Pistache::Http::ResponseWriter &response) {
    boost::uuids::uuid trackableId = m_manager->addTrackable(trackable);
    const std::string tmp = boost::lexical_cast<std::string>(trackableId);
    const char * ret = tmp.c_str();
    response.send(Pistache::Http::Code::Ok, ret);
}
void TrackableApiEtsi::delete_trackable(const std::string &trackableId, Pistache::Http::ResponseWriter &response) {
    const boost::uuids::uuid id = boost::lexical_cast<boost::uuids::uuid>(trackableId);
    m_manager->deleteTrackable(id);
    response.send(Pistache::Http::Code::Ok, "Trackable deleted\n");
}
void TrackableApiEtsi::get_trackable_by_id(const std::string &trackableId, Pistache::Http::ResponseWriter &response) {
    auto jsonObjects = json::array();
    const boost::uuids::uuid id = boost::lexical_cast<boost::uuids::uuid>(trackableId);
    Trackable trackable = m_manager->getTrackableById(id);
    to_json(jsonObjects, trackable);
    response.headers().add<Pistache::Http::Header::ContentType>(MIME(Application, Json));
    response.send(Pistache::Http::Code::Ok, jsonObjects.dump());
}
void TrackableApiEtsi::get_trackables(Pistache::Http::ResponseWriter &response) {
    auto jsonObjects = json::array();
    json toAdd;
    for (Trackable t : m_manager->getTrackables()){
        to_json(toAdd, t);
        jsonObjects.push_back(toAdd);
    }
    response.headers().add<Pistache::Http::Header::ContentType>(MIME(Application, Json));
    response.send(Pistache::Http::Code::Ok, jsonObjects.dump());
}

}
