//
// ARF - Augmented Reality Framework (ETSI ISG ARF)
//
// Copyright 2022 ETSI
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Last change: June 2022
//

#include "DefaultApiEtsi.h"


namespace etsi {

DefaultApiEtsi::DefaultApiEtsi(const std::shared_ptr<Pistache::Rest::Router>& rtr)
    : DefaultApi(rtr)
{
}

void DefaultApiEtsi::get_version(Pistache::Http::ResponseWriter &response) {
    response.send(Pistache::Http::Code::Ok, "Version 0.0.1\n");
}
void DefaultApiEtsi::get_ping(Pistache::Http::ResponseWriter &response) {
    response.send(Pistache::Http::Code::Ok, "Server online !\n Have fun\n");
}

}

