*This repository is part of the outcomes of the Specialist Task Force 620 and 669 focusing on the authoring and use of a World Representation as part of the ETSI ISG Augmented Reality Framework architecture (https://www.etsi.org/deliver/etsi_gs/ARF/001_099/003/01.01.01_60/gs_ARF003v010101p.pdf).*
*The set of the World Representation components includes:*

*•	The C, C++ and C# source code for servers and clients  generated from OpenAPI available here (https://forge.etsi.org/rep/arf/arf005)*

*•	A Unity plugin and a Unity editor for authoring and accessing a World Representation hosted on a World Storage server.*

*All these components are available under the ETSI Labs group “World Storage API Helpers”: https://labs.etsi.org/rep/arf/world-storage-api-helpers*

*If you wish to contribute to this project or any other projects in the context of the [ETSI ISG Augmented Reality Framework architecture](https://www.etsi.org/committee/1420-arf), please refer to the ["How to get involved in an ISG" section on the ETSI website](https://www.etsi.org/how-to-get-involved-in-an-isg)*

---

# WORLD STORAGE C CLIENT (LibCurl)

## Description

This repo contains a libCurl client library generation pipeline compliant to the World Storage API.

## Repo Content

|   |  File / Folder |                                                                                    Description                                                                                    |
|:-:|:--------------:|:---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|
| 📂 | EtsiClientGen  | The folder where the library code will be generated, the openapi generator is set to not overwrite the CmakeLists.txt used to generate and export the library to the user's sytem |
          |
| 📂 | arf005         | A submodule pointing to the git containing the API specification file                                                                                                             |
| 📃 | package.json   | The file containing the npm scripts automating the whole library generation process                                                                                               |

## Requirements

- Ubuntu 22.04
- CMake > 2.22
- conan V2
- npm

## Install or update cmake
To install the last version of Cmake, we recommend to follow the instruction detailed on the following link (Using APT Repositories): https://askubuntu.com/questions/355565/how-do-i-install-the-latest-version-of-cmake-from-the-command-line

## Install conan v2

Check if conan is already installed on your machine, and if the version 2 is installed:

    conan version

If conan version 1 is installed, you will have to remove it before installing version 2.

To install conan version 2, simply run:
    
    pip install conan

To setup your conan profile, run:

    conan profile detect

Conan is installed on your machine, you are ready to generate the cpp code for RestBed server.

## Code Generation

To generate the code and the DLLs use the following commands:

    npm install (if not already done)
    npm run generate && npm run build

You will find the header files in:
    
    /usr/local/include/worldStorageCClient/

and the library file in:
    
    /usr/local/lib/libworldStorageCClient.a
