//
// ARF - Augmented Reality Framework (ETSI ISG ARF)
//
// Copyright 2022 ETSI
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Last change: June 2022
//

using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using ETSI.ARF.OpenAPI.WorldStorage.Models;
using MongoDB.Driver;

#pragma warning disable CS1591 // Fehlendes XML-Kommentar fr ffentlich sichtbaren Typ oder Element
namespace ETSI.ARF.OpenAPI.WorldStorage.Services
{
    public class TrackableService : BaseService<Trackable>
    {
        /// <summary>
        /// 
        /// </summary>
        public TrackableService(IDatabaseSettings settings) : base(settings)
        {
            // Select the collection
            mongoCollection = mongoDatabase.GetCollection<Trackable>(settings.CollectionNameTrackables);
        }
    }
}
#pragma warning restore CS1591 // Fehlendes XML-Kommentar fr ffentlich sichtbaren Typ oder Element


