using System;
using System.Linq;
using System.Text;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using ETSI.ARF.OpenAPI.WorldStorage.Converters;
using MongoDB.Bson;
using MongoDB.Bson.Serialization.Attributes;

namespace ETSI.ARF.OpenAPI.WorldStorage.Models
{
    /// <summary>
    /// An element representing an xxx in the MongoDB.
    /// To ignore entries see: https://mongodb.github.io/mongo-csharp-driver/2.0/reference/bson/mapping/#ignoring-extra-elements
    /// </summary>
    [BsonIgnoreExtraElements]
    public partial class Trackable : IModels
    {
        /// <summary>
        /// If an element from the DB is not existing in the class
        /// we can receive the info which elements
        /// </summary>
        [BsonExtraElements]
        public BsonDocument CatchAll { get; set; }

        /// <summary>
        /// ID is managed by mongo
        /// </summary>
        [BsonId]
        [BsonRepresentation(BsonType.ObjectId)] 
        public ObjectId _id;

        /// <summary>
        /// Get mongo ID
        /// </summary>
        //[BsonIgnore] - don't ignore, so mongo replace can use it!
        public ObjectId _mongoID { get => _id; set => _id = value; }
    }
}