//
// ARF - Augmented Reality Framework (ETSI ISG ARF)
//
// Copyright 2024 ETSI
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Last change: September 2024
//

/*
 * World Storage API
 *
 * API ensuring interoperability between an authoring tool and a World Storage service
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 * Generated by: https://openapi-generator.tech
 */

using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Http;
using Swashbuckle.AspNetCore.Annotations;
using Swashbuckle.AspNetCore.SwaggerGen;
using Newtonsoft.Json;
using ETSI.ARF.OpenAPI.WorldStorage.Attributes;
using ETSI.ARF.OpenAPI.WorldStorage.Models;
using ETSI.ARF.OpenAPI.WorldStorage.Services;
using MongoDB.Driver;

namespace ETSI.ARF.OpenAPI.WorldStorage.Controllers
{
    /// <summary>
    /// 
    /// </summary>
    [ApiController]
    public class WorldLinksApiControllerImpl : WorldLinksApiController
    {
        private readonly WorldLinkService _worldLinkService;

        /// <summary>
        /// 
        /// </summary>
        public WorldLinksApiControllerImpl(WorldLinkService worldLinkService)
        {
            _worldLinkService = worldLinkService;
        }

        /// <summary>
        /// Create a World Link between elements (world anchors and/or trackables).
        /// </summary>
        public override IActionResult AddWorldLink([FromBody] WorldLink worldLink, [FromHeader] string token)
        {
            if (!Startup.IsAccessGranted(token)) return StatusCode(511, new Error() { Message = "Invalid token!" });

            if (String.IsNullOrEmpty(worldLink.UUID.ToString()))
            {
                worldLink.UUID = Guid.NewGuid();
            }
            try
            {
                WorldLink myworldlink = _worldLinkService.Create(worldLink);
                if (myworldlink == null)
                {
                    return StatusCode(409, new Error() { Message = "UUID already existing!" });
                }
                else return StatusCode(200, new Success() { Message = myworldlink.UUID.ToString() });
            }
            catch (Exception e)
            {
                return StatusCode(400, new Error() { Message = e.Message});
            }
        }

        /// <summary>
        /// Delete a World Link.
        /// </summary>
        public override IActionResult DeleteWorldLink([FromRoute(Name = "worldLinkUUID")][Required] Guid worldLinkUUID, [FromHeader] string token)
        {
            if (!Startup.IsAccessGranted(token)) return StatusCode(511, new Error() { Message = "Invalid token!" });

            long count = _worldLinkService.Remove(worldLinkUUID);
            return (count > 0) ? StatusCode(200, new Success() { Message = "ok" } ) : StatusCode(404, new Error() { Message = "Not found, could not find UUID in database." });
        }


        /// <summary>
        /// Find a World Link by its UUID.
        /// </summary>
        public override IActionResult GetWorldLinkById([FromRoute(Name = "worldLinkUUID")][Required] Guid worldLinkUUID, [FromHeader] string token)
        {
            if (!Startup.IsAccessGranted(token)) return StatusCode(511, new Error() { Message = "Invalid token!" });

            // Access other service(s)
            TrackableService _trackableService = TrackableService.Singleton as TrackableService;
            WorldAnchorService _worldAnchorService = WorldAnchorService.Singleton as WorldAnchorService;

            WorldLink myworldlink = _worldLinkService.Get(worldLinkUUID);
            if (null != myworldlink)
            {
                // check TypeFrom
                if (myworldlink.TypeFrom == TypeWorldStorage.TRACKABLEEnum)
                {
                    if (null == _trackableService.Get(myworldlink.UUIDFrom))
                    {
                        myworldlink.TypeFrom = TypeWorldStorage.UNKNOWNEnum;
                        myworldlink.UUIDFrom = Guid.Empty;
                    }
                }
                else if (myworldlink.TypeFrom == TypeWorldStorage.ANCHOREnum)
                {
                    if (null == _worldAnchorService.Get(myworldlink.UUIDFrom))
                    {
                        myworldlink.TypeFrom = TypeWorldStorage.UNKNOWNEnum;
                        myworldlink.UUIDFrom = Guid.Empty;
                    }
                }
                // check TypeTo
                if (myworldlink.TypeTo == TypeWorldStorage.TRACKABLEEnum)
                {
                    if (null == _trackableService.Get(myworldlink.UUIDTo))
                    {
                        myworldlink.TypeTo = TypeWorldStorage.UNKNOWNEnum;
                        myworldlink.UUIDTo = Guid.Empty;
                    }
                }
                else if (myworldlink.TypeTo == TypeWorldStorage.ANCHOREnum)
                {
                    if (null == _worldAnchorService.Get(myworldlink.UUIDTo))
                    {
                        myworldlink.TypeTo = TypeWorldStorage.UNKNOWNEnum;
                        myworldlink.UUIDTo = Guid.Empty;
                    }
                }
            }
            return (null != myworldlink) ? new ObjectResult(myworldlink) : StatusCode(404, new Error() { Message = "Not found, could not find UUID in database." });
        }

        /// <summary>
        /// Return all World Links.
        /// </summary>
        public override IActionResult GetWorldLinks([FromHeader] string token)
        {
            if (!Startup.IsAccessGranted(token)) return StatusCode(511, new Error() { Message = "Invalid token!" });

            WorldLinksResponse response = new WorldLinksResponse();

            // Access other service(s)
            TrackableService _trackableService = TrackableService.Singleton as TrackableService;
            WorldAnchorService _worldAnchorService = WorldAnchorService.Singleton as WorldAnchorService;

            response.WorldLinks = _worldLinkService.Get();
            foreach (WorldLink myworldlink in response.WorldLinks)
            {
                // check TypeFrom
                if (myworldlink.TypeFrom == TypeWorldStorage.TRACKABLEEnum)
                {
                    if (null == _trackableService.Get(myworldlink.UUIDFrom))
                    {
                        myworldlink.TypeFrom = TypeWorldStorage.UNKNOWNEnum;
                        myworldlink.UUIDFrom = Guid.Empty;
                    }
                }
                else if (myworldlink.TypeFrom == TypeWorldStorage.ANCHOREnum)
                {
                    if (null == _worldAnchorService.Get(myworldlink.UUIDFrom))
                    {
                        myworldlink.TypeFrom = TypeWorldStorage.UNKNOWNEnum;
                        myworldlink.UUIDFrom = Guid.Empty;
                    }
                }
                // check TypeTo
                if (myworldlink.TypeTo == TypeWorldStorage.TRACKABLEEnum)
                {
                    if (null == _trackableService.Get(myworldlink.UUIDTo))
                    {
                        myworldlink.TypeTo = TypeWorldStorage.UNKNOWNEnum;
                        myworldlink.UUIDTo = Guid.Empty;
                    }
                }
                else if (myworldlink.TypeTo == TypeWorldStorage.ANCHOREnum)
                {
                    if (null == _worldAnchorService.Get(myworldlink.UUIDTo))
                    {
                        myworldlink.TypeTo = TypeWorldStorage.UNKNOWNEnum;
                        myworldlink.UUIDTo = Guid.Empty;
                    }
                }
            }
            return new ObjectResult(response);
        }



        /// <summary>
        /// Modify a World Link.
        /// </summary>
        public override IActionResult ModifyWorldLink([FromBody] WorldLink worldLink, [FromHeader] string token)
        {
            if (!Startup.IsAccessGranted(token)) return StatusCode(511, new Error() { Message = "Invalid token!" });

            long count = _worldLinkService.Replace(worldLink);
            if (count == 0)
            {
                return StatusCode(404, new Error() { Message = "Not found, could not find UUID in database." });
            }
            else
            {
                return StatusCode(200, new Success() { Message = worldLink.UUID.ToString() });
            }
        }
    }
}
