//
// ARF - Augmented Reality Framework (ETSI ISG ARF)
//
// Copyright 2022 ETSI
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Last change: June 2024
//

/*
 * World Storage API
 *
 * API ensuring interoperability between an authoring tool and a World Storage service
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 * Generated by: https://openapi-generator.tech
 */

using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Http;
using Swashbuckle.AspNetCore.Annotations;
using Swashbuckle.AspNetCore.SwaggerGen;
using Newtonsoft.Json;
using ETSI.ARF.OpenAPI.WorldStorage.Attributes;
using ETSI.ARF.OpenAPI.WorldStorage.Models;
using ETSI.ARF.OpenAPI.WorldStorage.Services;
using MongoDB.Driver;

namespace ETSI.ARF.OpenAPI.WorldStorage.Controllers
{
    /// <summary>
    /// 
    /// </summary>
    [ApiController]
    public class WorldAnchorsApiControllerImpl : WorldAnchorsApiController
    {
        private readonly WorldAnchorService _worldAnchorService;

        /// <summary>
        /// 
        /// </summary>
        public WorldAnchorsApiControllerImpl(WorldAnchorService worldAnchorService)
        {
            _worldAnchorService = worldAnchorService;
        }


        /// <summary>
        /// Create a World Anchor.
        /// </summary>
        public override IActionResult AddWorldAnchor([FromBody] WorldAnchor worldAnchor, [FromHeader] string token)
        {
            if (!Startup.IsAccessGranted(token)) return StatusCode(511, new Error() { Message = "Invalid token!" });

            if (String.IsNullOrEmpty(worldAnchor.UUID.ToString()))
            {
                worldAnchor.UUID = Guid.NewGuid();
            }
            try
            {
                WorldAnchor myworldanchor = _worldAnchorService.Create(worldAnchor);
                if (myworldanchor == null)
                {
                    return StatusCode(409, new Error() { Message = "UUID alread exexisting!" });
                }
                else return StatusCode(200, new Success() { Message = myworldanchor.UUID.ToString() });
            }
            catch (Exception e)
            {
                return StatusCode(400, new Error() { Message = e.Message });
            }
        }

        /// <summary>
        /// Delete a World Anchor.
        /// </summary>
        public override IActionResult DeleteWorldAnchor([FromRoute(Name = "worldAnchorUUID")][Required] Guid worldAnchorUUID, [FromHeader] string token)
        {
            if (!Startup.IsAccessGranted(token)) return StatusCode(511, new Error() { Message = "Invalid token!" });

            // Access other service(s)
            WorldLinkService _worldLinkService = WorldLinkService.Singleton as WorldLinkService;

            long count = _worldAnchorService.Remove(worldAnchorUUID);
            // check, if used in WorldLink
            string result = "ok";
            string worldlinkinfo = "";

            // Update world links
            List<WorldLink> worldlinklistfrom = _worldLinkService.GetWorldLinkUUIDFrom(worldAnchorUUID);
            foreach (WorldLink worldlink in worldlinklistfrom)
            {
                worldlinkinfo += worldlink.UUID.ToString() + "; ";
                worldlink.UUIDFrom = Guid.Empty;
                worldlink.TypeFrom = TypeWorldStorage.UNKNOWNEnum;
                _worldLinkService.Replace(worldlink);
            }

            // Update world links
            List<WorldLink> worldlinklistto = _worldLinkService.GetWorldLinkUUIDTo(worldAnchorUUID);
            foreach (WorldLink worldlink in worldlinklistto)
            {
                worldlinkinfo += worldlink.UUID.ToString() + "; ";
                worldlink.UUIDTo = Guid.Empty;
                worldlink.TypeTo = TypeWorldStorage.UNKNOWNEnum;
                _worldLinkService.Replace(worldlink);
            }
            if (worldlinkinfo.Length > 1)
            {
                result += ", but removed object was referenced in " + worldlinkinfo + " and removed there as well";
            }
            return (count > 0) ? StatusCode(200, new Success() { Message = result }) : StatusCode(404, new Error() { Message = "Not found, could not find UUID in database." });
        }

        /// <summary>
        /// Find a World Anchor by its UUID.
        /// </summary>
        public override IActionResult GetWorldAnchorById([FromRoute(Name = "worldAnchorUUID")][Required] Guid worldAnchorUUID, [FromHeader] string token)
        {
            if (!Startup.IsAccessGranted(token)) return StatusCode(511, new Error() { Message = "Invalid token!" });

            WorldAnchor myworldanchor = _worldAnchorService.Get(worldAnchorUUID);
            return (null != myworldanchor) ? new ObjectResult(myworldanchor) : StatusCode(404, new Error() { Message = "Not found, could not find UUID in database." });
        }

        /// <summary>
        /// Return all the World Anchors.
        /// </summary>
        public override IActionResult GetWorldAnchors([FromHeader] string token)
        {
            if (!Startup.IsAccessGranted(token)) return StatusCode(511, new Error() { Message = "Invalid token!" });

            WorldAnchorsResponse response = new WorldAnchorsResponse();
            response.WorldAnchors = _worldAnchorService.Get();
            return new ObjectResult(response);
        }



        /// <summary>
        /// Modify a World Anchor.
        /// </summary>
        public override IActionResult ModifyWorldAnchor([FromBody] WorldAnchor worldAnchor, [FromHeader] string token)
        {
            if (!Startup.IsAccessGranted(token)) return StatusCode(511, new Error() { Message = "Invalid token!" });

            long count = _worldAnchorService.Replace(worldAnchor);
            if (count == 0)
            {
                return StatusCode(404, new Error() { Message = "Not found, could not find UUID in database." });
            }
            else
            {
                return StatusCode(200, new Success() { Message = worldAnchor.UUID.ToString() });
            }
        }


    }
}
