using System;
using System.Linq;
using System.Numerics;
using System.Text;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using ETSI.ARF.OpenAPI.WorldStorage.Converters;
using MongoDB.Bson;
using MongoDB.Bson.Serialization.Attributes;

namespace ETSI.ARF.OpenAPI.WorldStorage.Models
{
    /// <summary>
    /// An element representing an xxx in the MongoDB.
    /// To ignore entries see: https://mongodb.github.io/mongo-csharp-driver/2.0/reference/bson/mapping/#ignoring-extra-elements
    /// </summary>
    [BsonIgnoreExtraElements]
    public partial class Trackable : IModels
    {
        /// <summary>
        /// If an element from the DB is not existing in the class
        /// we can receive the info which elements
        /// </summary>
        [BsonExtraElements]
        public BsonDocument CatchAll { get; set; }

        /// <summary>
        /// ID is managed by mongo
        /// </summary>
        [BsonId]
        [BsonRepresentation(BsonType.ObjectId)] 
        public ObjectId _id;

        /// <summary>
        /// Get mongo ID
        /// </summary>
        //[BsonIgnore] - don't ignore, so mongo replace can use it!
        public ObjectId _mongoID { get => _id; set => _id = value; }

        /// <summary>
        /// Check for capabilities
        /// </summary>
        public bool Match(List<Capability> capabilities)
        {
            if (capabilities.Count == 0)
            {
                return true;
            }

            foreach(var capability in capabilities)
            {
                if (capability.TrackableType == TrackableType &&
                    capability.EncodingInformation.DataFormat == TrackableEncodingInformation.DataFormat &&
                    capability.EncodingInformation.VarVersion == TrackableEncodingInformation.VarVersion)
                {
                    return true;
                }
            }
            
            return false;
        }

        /// <summary>
        /// Give the matrix from the array of the object
        /// </summary>
        public Matrix4x4 Matrix()
        {
            return new Matrix4x4(
                LocalCRS[0], LocalCRS[1], LocalCRS[2], LocalCRS[3],
                LocalCRS[4], LocalCRS[5], LocalCRS[6], LocalCRS[7],
                LocalCRS[8], LocalCRS[9], LocalCRS[10], LocalCRS[11],
                LocalCRS[12], LocalCRS[13], LocalCRS[14], LocalCRS[15]
            );
        }
    }
}